/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Commented;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.Type;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class ExternalArgument
implements BoostObject,
Commented {
    private boolean read;
    private boolean write;
    private Type type;
    private final List<String> commentList = new ArrayList<String>();

    public ExternalArgument() {
    }

    protected ExternalArgument(Boost boost) {
        boost.register((BoostObject)this);
        this.read = boost.readBoolean();
        this.write = boost.readBoolean();
        this.type = (Type)boost.readObject(Type.class);
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.commentList.add(oneChild);
        }
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean newValue) {
        if (this.read != newValue) {
            this.read = newValue;
        }
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setWrite(boolean newValue) {
        if (this.write != newValue) {
            this.write = newValue;
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type newValue) {
        if (this.type == null ? newValue != null : !this.type.equals(newValue)) {
            this.type = newValue;
        }
    }

    @Override
    public List<String> getCommentList() {
        return Collections.unmodifiableList(this.commentList);
    }

    @Override
    public int getCommentCount() {
        return this.commentList.size();
    }

    @Override
    public String getComment(int index) {
        if (index < 0 || index >= this.getCommentCount()) {
            return null;
        }
        return this.commentList.get(index);
    }

    @Override
    public void addComment(String newValue) {
        this.addComment(this.getCommentCount(), newValue);
    }

    @Override
    public void addComment(int index, String newValue) {
        this.commentList.add(index, newValue);
    }

    @Override
    public String setComment(int index, String newValue) {
        return this.commentList.set(index, newValue);
    }

    @Override
    public void addAllComment(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addComment(this.getCommentCount(), newValue);
        }
    }

    @Override
    public void removeComment(String value) {
        int index = this.commentList.indexOf(value);
        if (index >= 0) {
            this.removeComment(index);
        }
    }

    @Override
    public void removeComment(int index) {
        this.commentList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeBoolean(this.read);
        boost.writeBoolean(this.write);
        boost.writeObject((BoostObject)this.type);
        BoostUtil.writeStringCollection((Boost)boost, this.commentList);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitExternalArgument(this);
    }
}

