/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.fiacre;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Stack;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.evaluator.ArrayEvaluator;
import obp.explorer.runtime.evaluator.ArrayLengthEvaluator;
import obp.explorer.runtime.evaluator.BehaviorEvaluator;
import obp.explorer.runtime.evaluator.ComparisonEvaluator;
import obp.explorer.runtime.evaluator.ComposedEvaluator;
import obp.explorer.runtime.evaluator.ConstantEvaluator;
import obp.explorer.runtime.evaluator.EqualityEvaluator;
import obp.explorer.runtime.evaluator.Evaluator;
import obp.explorer.runtime.evaluator.FieldEvaluator;
import obp.explorer.runtime.evaluator.LeafEvaluator;
import obp.explorer.runtime.evaluator.MatcherEvaluator;
import obp.explorer.runtime.evaluator.StateEvaluator;
import obp.explorer.runtime.fiacre.LiteralToJavaObject;
import obp.explorer.runtime.fiacre.LiteralToMatcher;
import obp.explorer.runtime.matcher.Matcher;
import obp.explorer.runtime.obs.ObsBehavior;
import obp.explorer.runtime.obs.ObsConfiguration;
import obp.explorer.runtime.util.EvaluatorUtil;
import obp.explorer.runtime.util.NameUtil;
import obp.predicate.AllPredicate;
import obp.predicate.ArrayAccess;
import obp.predicate.AtomicAccess;
import obp.predicate.ComparisonOperator;
import obp.predicate.FieldAccess;
import obp.predicate.LiteralComparisonPredicate;
import obp.predicate.LiteralEqualityPredicate;
import obp.predicate.LogicPredicate;
import obp.predicate.Predicate;
import obp.predicate.PredicateReference;
import obp.predicate.PredicateVisitor;
import obp.predicate.StatePredicate;
import obp.predicate.SystemAccess;
import obp.predicate.VariableComparisonPredicate;
import obp.predicate.VariableEqualityPredicate;
import obp.util.CDLUtil;

public class PredicateToEvaluator
implements PredicateVisitor {
    private final ExplorationContext context;
    private final SymbolsTable symbols;
    private final Stack<Evaluator> evaluatorStack = new Stack();

    public static Evaluator toEvaluator(Predicate predicate, ExplorationContext context, SymbolsTable symbols) {
        PredicateToEvaluator transformer = new PredicateToEvaluator(context, symbols);
        predicate.accept(transformer);
        return transformer.evaluatorStack.pop();
    }

    public static Evaluator toEvaluator(SystemAccess access, ExplorationContext context, SymbolsTable symbols) {
        PredicateToEvaluator transformer = new PredicateToEvaluator(context, symbols);
        transformer.evaluatorStack.push(new LeafEvaluator(context));
        access.accept(transformer);
        return transformer.evaluatorStack.pop();
    }

    private PredicateToEvaluator(ExplorationContext context, SymbolsTable symbols) {
        this.context = context;
        this.symbols = symbols;
    }

    @Override
    public void visitStatePredicate(StatePredicate toVisit) {
        short behaviorId = this.symbols.getBehaviorId(CDLUtil.toString(toVisit.getPid()));
        Behavior behavior = this.context.getBehavior(behaviorId);
        int stateId = behavior.getStateId(toVisit.getState());
        Class configurationClass = null;
        if (behavior instanceof ObsBehavior) {
            configurationClass = ObsConfiguration.class;
        } else {
            try {
                Class<?> programClass = this.context.getProgram().getClass();
                String packageName = programClass.getPackage().getName();
                String processClassName = packageName + "." + NameUtil.capName(toVisit.getPid().getName()) + "Configuration";
                configurationClass = programClass.getClassLoader().loadClass(processClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Process '" + toVisit.getPid().getName() + "' doesn't exist.");
            }
        }
        StateEvaluator stateEvaluator = EvaluatorUtil.createStateEvaluator(this.context, configurationClass, stateId);
        BehaviorEvaluator behaviorEvaluator = new BehaviorEvaluator(this.context, behaviorId, stateEvaluator);
        this.evaluatorStack.push(behaviorEvaluator);
    }

    @Override
    public void visitLiteralEqualityPredicate(LiteralEqualityPredicate toVisit) {
        Matcher matcher = LiteralToMatcher.toMatcher(toVisit.getRight(), this.context);
        this.evaluatorStack.push(new LeafEvaluator(this.context));
        toVisit.getLeft().accept(this);
        MatcherEvaluator matcherEvaluator = new MatcherEvaluator(this.context, this.evaluatorStack.pop(), matcher);
        this.evaluatorStack.push(matcherEvaluator);
    }

    @Override
    public void visitVariableEqualityPredicate(VariableEqualityPredicate toVisit) {
        this.evaluatorStack.push(new LeafEvaluator(this.context));
        toVisit.getLeft().accept(this);
        Evaluator leftEvaluator = this.evaluatorStack.pop();
        this.evaluatorStack.push(new LeafEvaluator(this.context));
        toVisit.getRight().accept(this);
        Evaluator rightEvaluator = this.evaluatorStack.pop();
        EqualityEvaluator result = new EqualityEvaluator(this.context, leftEvaluator, rightEvaluator);
        this.evaluatorStack.push(result);
    }

    @Override
    public void visitSystemAccess(SystemAccess toVisit) {
        short id = this.symbols.getBehaviorId(CDLUtil.toString(toVisit.getPid()));
        Class<?> programClass = this.context.getProgram().getClass();
        Class<?> processClass = null;
        try {
            String packageName = programClass.getPackage().getName();
            String processClassName = packageName + "." + NameUtil.capName(toVisit.getPid().getName()) + "Configuration";
            processClass = programClass.getClassLoader().loadClass(processClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Process '" + toVisit.getPid().getName() + "' doesn't exist.");
        }
        Class<Object> currentClass = processClass;
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (AtomicAccess atomicAccess : toVisit.getAccessList()) {
            Field field;
            String fieldName;
            if (atomicAccess instanceof ArrayAccess) {
                ArrayAccess arrayAccess = (ArrayAccess)atomicAccess;
                try {
                    fieldName = NameUtil.uncapName(arrayAccess.getName());
                    field = currentClass.getField(fieldName);
                    arguments.add(0, field);
                    arguments.add(0, arrayAccess.getIndex());
                    currentClass = field.getType().getComponentType();
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Field '" + arrayAccess.getName() + "' doesn't exist (in class '" + currentClass.getSimpleName() + "').");
                }
            }
            if (!(atomicAccess instanceof FieldAccess)) continue;
            FieldAccess fieldAccess = (FieldAccess)atomicAccess;
            try {
                fieldName = NameUtil.uncapName(fieldAccess.getName());
                if (currentClass.isArray() && fieldName.equals("length")) {
                    arguments.add(0, "length");
                    currentClass = Integer.TYPE;
                    continue;
                }
                field = currentClass.getField(fieldName);
                arguments.add(0, field);
                currentClass = field.getType();
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("Field '" + fieldAccess.getName() + "' doesn't exist (in class '" + currentClass.getSimpleName() + "').");
            }
        }
        for (AtomicAccess atomicAccess : arguments) {
            Evaluator matcher;
            if (atomicAccess instanceof Field) {
                Field field = (Field)((Object)atomicAccess);
                matcher = new FieldEvaluator(this.context, field, this.evaluatorStack.pop());
                this.evaluatorStack.push(matcher);
                continue;
            }
            if (atomicAccess instanceof Integer) {
                Integer index = (Integer)((Object)atomicAccess);
                matcher = new ArrayEvaluator(this.context, index, this.evaluatorStack.pop());
                this.evaluatorStack.push(matcher);
                continue;
            }
            if (!"length".equals(atomicAccess)) continue;
            ArrayLengthEvaluator evaluator = new ArrayLengthEvaluator(this.context, this.evaluatorStack.pop());
            this.evaluatorStack.push(evaluator);
        }
        BehaviorEvaluator behaviorMatcher = new BehaviorEvaluator(this.context, id, this.evaluatorStack.pop());
        this.evaluatorStack.push(behaviorMatcher);
    }

    @Override
    public void visitFieldAccess(FieldAccess toVisit) {
    }

    @Override
    public void visitArrayAccess(ArrayAccess toVisit) {
    }

    @Override
    public void visitLogicPredicate(LogicPredicate toVisit) {
        Evaluator[] children = null;
        ComposedEvaluator result = null;
        switch (toVisit.getOperator()) {
            case NOT: {
                children = new Evaluator[1];
                toVisit.getLeft().accept(this);
                children[0] = this.evaluatorStack.pop();
                result = new ComposedEvaluator(this.context, ComposedEvaluator.Type.Not, children);
                this.evaluatorStack.push(result);
                break;
            }
            case AND: {
                children = new Evaluator[2];
                toVisit.getLeft().accept(this);
                children[0] = this.evaluatorStack.pop();
                toVisit.getRight().accept(this);
                children[1] = this.evaluatorStack.pop();
                result = new ComposedEvaluator(this.context, ComposedEvaluator.Type.And, children);
                this.evaluatorStack.push(result);
                break;
            }
            case OR: {
                children = new Evaluator[2];
                toVisit.getLeft().accept(this);
                children[0] = this.evaluatorStack.pop();
                toVisit.getRight().accept(this);
                children[1] = this.evaluatorStack.pop();
                result = new ComposedEvaluator(this.context, ComposedEvaluator.Type.Or, children);
                this.evaluatorStack.push(result);
                break;
            }
            case IMPLICATION: {
                children = new Evaluator[2];
                toVisit.getLeft().accept(this);
                children[0] = this.evaluatorStack.pop();
                toVisit.getRight().accept(this);
                children[1] = this.evaluatorStack.pop();
                result = new ComposedEvaluator(this.context, ComposedEvaluator.Type.Implication, children);
                this.evaluatorStack.push(result);
                break;
            }
            case EQUIVALENCE: {
                children = new Evaluator[2];
                toVisit.getLeft().accept(this);
                children[0] = this.evaluatorStack.pop();
                toVisit.getRight().accept(this);
                children[1] = this.evaluatorStack.pop();
                result = new ComposedEvaluator(this.context, ComposedEvaluator.Type.Equivalence, children);
                this.evaluatorStack.push(result);
                break;
            }
        }
    }

    @Override
    public void visitLiteralComparisonPredicate(LiteralComparisonPredicate toVisit) {
        this.evaluatorStack.push(new LeafEvaluator(this.context));
        toVisit.getLeft().accept(this);
        Evaluator leftEvaluator = this.evaluatorStack.pop();
        Object rightValue = LiteralToJavaObject.toJava(toVisit.getRight(), this.context.getProgram());
        ConstantEvaluator rightEvaluator = new ConstantEvaluator(this.context, rightValue);
        ComparisonEvaluator.Type type = this.integerComparisonType(toVisit.getOperator());
        ComparisonEvaluator result = new ComparisonEvaluator(this.context, type, leftEvaluator, rightEvaluator);
        this.evaluatorStack.push(result);
    }

    @Override
    public void visitVariableComparisonPredicate(VariableComparisonPredicate toVisit) {
        this.evaluatorStack.push(new LeafEvaluator(this.context));
        toVisit.getLeft().accept(this);
        Evaluator leftEvaluator = this.evaluatorStack.pop();
        this.evaluatorStack.push(new LeafEvaluator(this.context));
        toVisit.getRight().accept(this);
        Evaluator rightEvaluator = this.evaluatorStack.pop();
        ComparisonEvaluator.Type type = this.integerComparisonType(toVisit.getOperator());
        ComparisonEvaluator result = new ComparisonEvaluator(this.context, type, leftEvaluator, rightEvaluator);
        this.evaluatorStack.push(result);
    }

    private ComparisonEvaluator.Type integerComparisonType(ComparisonOperator operator) {
        switch (operator) {
            case GREATER: {
                return ComparisonEvaluator.Type.GREATER;
            }
            case GREATER_OR_EQUAL: {
                return ComparisonEvaluator.Type.GREATER_OR_EQUAL;
            }
            case LESSER: {
                return ComparisonEvaluator.Type.LESSER;
            }
            case LESSER_OR_EQUAL: {
                return ComparisonEvaluator.Type.LESSER_OR_EQUAL;
            }
        }
        return null;
    }

    @Override
    public void visitPredicateReference(PredicateReference toVisit) {
        toVisit.getReference().getIs().accept(this);
    }

    @Override
    public void visitAllPredicate(AllPredicate toVisit) {
        this.evaluatorStack.push(new ConstantEvaluator(this.context, Boolean.TRUE));
    }
}

