/*
 * Decompiled with CFR 0.152.
 */
package plug.modules.synchronization.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.modules.synchronization.ISynchronizingRuntime;
import plug.modules.synchronization.runtime.SynchronizationConfiguration;
import plug.statespace.transitions.FiredTransition;

public class SynchronizationTransitionRelation<C extends IConfiguration, T>
implements ITransitionRelation<SynchronizationConfiguration<C>, SynchronizationConfiguration<C>> {
    public C initial;
    public T[][] availableTransitions;
    public ISynchronizingRuntime<C, T> runtime;
    public Set<C> results;

    public Set<SynchronizationConfiguration<C>> initialConfigurations() {
        SynchronizationConfiguration initialState = new SynchronizationConfiguration();
        initialState.conf = this.initial;
        initialState.phase = 0;
        initialState.firedTransitions = new boolean[this.availableTransitions[0].length];
        return Collections.singleton(initialState);
    }

    public Collection<SynchronizationConfiguration<C>> fireableTransitionsFrom(SynchronizationConfiguration<C> configuration) {
        SynchronizationConfiguration<C> source = configuration;
        T[] pool = this.availableTransitions[source.phase];
        ArrayList<SynchronizationConfiguration<C>> fireableHACK = new ArrayList<SynchronizationConfiguration<C>>();
        for (int i = 0; i < pool.length; ++i) {
            IConfiguration newConf;
            IFiredTransition<C, ?> fired;
            if (source.firedTransitions[i] || (fired = this.runtime.executeOneTransition(source.conf, pool[i])) == null || (newConf = (IConfiguration)fired.getTarget(0)) == null) continue;
            SynchronizationConfiguration target = new SynchronizationConfiguration();
            target.conf = newConf;
            target.phase = source.phase;
            target.firedTransitions = Arrays.copyOf(source.firedTransitions, source.firedTransitions.length);
            target.firedTransitions[i] = true;
            target.canonize(source.phase + 1 == this.availableTransitions.length ? 0 : this.availableTransitions[source.phase + 1].length);
            if (this.isFinal(target)) {
                this.results.add(newConf);
                continue;
            }
            fireableHACK.add(target);
        }
        return fireableHACK;
    }

    public IFiredTransition<SynchronizationConfiguration<C>, ?> fireOneTransition(SynchronizationConfiguration<C> source, SynchronizationConfiguration<C> transition) {
        return new FiredTransition(source, transition, transition);
    }

    boolean isFinal(SynchronizationConfiguration configuration) {
        return configuration.phase == this.availableTransitions.length;
    }
}

