/*
 * Decompiled with CFR 0.152.
 */
package plug.modules.synchronization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import plug.core.IFiredTransition;
import plug.modules.synchronization.ISynchronizingRuntime;

public class SynchronizationExplorer<C, T> {
    private final List<T> outputs = new ArrayList<T>();
    private final List<T> inputs = new ArrayList<T>();
    private final Set<IntermediateState> known = new HashSet<IntermediateState>();
    private Queue<IntermediateState> currentToSee = new LinkedList<IntermediateState>();
    private Queue<IntermediateState> nextToSee = new LinkedList<IntermediateState>();
    protected boolean[] noFiredInputs;
    protected boolean[] noFiredOutputs;
    public ISynchronizingRuntime<C, T> runtime;

    public SynchronizationExplorer(ISynchronizingRuntime<C, T> runtime) {
        this.runtime = runtime;
    }

    public void addOutputs(Collection<T> outputs) {
        this.outputs.addAll(outputs);
    }

    public void addInputs(Collection<T> inputs) {
        this.inputs.addAll(inputs);
    }

    public void reset() {
        this.inputs.clear();
        this.outputs.clear();
    }

    private void initExploration(C source) {
        this.known.clear();
        this.currentToSee.clear();
        this.nextToSee.clear();
        this.noFiredInputs = new boolean[this.inputs.size()];
        Arrays.fill(this.noFiredInputs, false);
        this.noFiredOutputs = new boolean[this.outputs.size()];
        Arrays.fill(this.noFiredOutputs, false);
        IntermediateState initialState = new IntermediateState();
        initialState.conf = source;
        initialState.outputPhase = true;
        initialState.firedTransitions = this.noFiredOutputs;
        initialState.canonize();
        this.currentToSee.add(initialState);
    }

    private IntermediateState<C> nextConfiguration() {
        if (this.currentToSee.isEmpty()) {
            Queue<IntermediateState> tmp = this.currentToSee;
            this.currentToSee = this.nextToSee;
            this.nextToSee = tmp;
        }
        return this.currentToSee.remove();
    }

    private void explorationStep() {
        IntermediateState<C> source = this.nextConfiguration();
        List<T> pool = source.outputPhase ? this.outputs : this.inputs;
        for (int i = 0; i < pool.size(); ++i) {
            Object newConf;
            IFiredTransition<C, ?> fired;
            if (source.firedTransitions[i] || (fired = this.runtime.executeOneTransition(source.conf, pool.get(i))) == null || (newConf = fired.getTarget(0)) == null) continue;
            IntermediateState target = new IntermediateState();
            target.conf = newConf;
            target.outputPhase = source.outputPhase;
            target.firedTransitions = Arrays.copyOf(source.firedTransitions, source.firedTransitions.length);
            target.firedTransitions[i] = true;
            target.canonize();
            if (!this.known.add(target) || target.isFinal()) continue;
            this.nextToSee.add(target);
        }
        if (this.currentToSee.isEmpty() && !this.nextToSee.isEmpty()) {
            this.known.clear();
        }
    }

    private void explore(C source) {
        this.initExploration(source);
        while (this.hasNext()) {
            this.explorationStep();
        }
    }

    public void execute(C configuration, Set<C> ioResults) {
        this.explore(configuration);
        for (IntermediateState state : this.known) {
            ioResults.add(state.conf);
        }
    }

    private boolean hasNext() {
        return !this.currentToSee.isEmpty() || !this.nextToSee.isEmpty();
    }

    private class IntermediateState<C> {
        public C conf;
        public boolean outputPhase;
        public boolean[] firedTransitions;

        private IntermediateState() {
        }

        public boolean hasNextForPhase() {
            for (int i = 0; i < this.firedTransitions.length; ++i) {
                if (this.firedTransitions[i]) continue;
                return true;
            }
            return false;
        }

        public void canonize() {
            if (this.outputPhase && !this.hasNextForPhase()) {
                this.outputPhase = false;
                this.firedTransitions = SynchronizationExplorer.this.noFiredInputs;
            }
        }

        public boolean isFinal() {
            return !this.outputPhase && !this.hasNextForPhase();
        }

        public int hashCode() {
            return this.conf.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IntermediateState)) {
                return false;
            }
            IntermediateState other = (IntermediateState)obj;
            if (this.outputPhase != other.outputPhase) {
                return false;
            }
            if (!this.conf.equals(other.conf)) {
                return false;
            }
            for (int i = 0; i < this.firedTransitions.length; ++i) {
                if (this.firedTransitions[i] == other.firedTransitions[i]) continue;
                return false;
            }
            return true;
        }
    }
}

