/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.model;

import spinja.concurrent.model.ConcurrentModel;
import spinja.exceptions.ValidationException;
import spinja.promela.exceptions.TooManyChannelsException;
import spinja.promela.exceptions.TooManyProcessesException;
import spinja.promela.model.Channel;
import spinja.promela.model.PromelaProcess;
import spinja.promela.model.PromelaTransition;
import spinja.promela.model.PromelaTransitionFactory;
import spinja.util.ByteArrayStorage;

public abstract class PromelaModel
extends ConcurrentModel<PromelaTransition> {
    public static final int _NO_PROCESS = 255;
    protected PromelaProcess[] _procs;
    protected int _nrProcs = 0;
    private final String _name;
    protected int _exclusive;
    protected Channel[] _channels;
    protected int _nrChannels = 0;
    protected boolean _ignore_assert;
    protected boolean _timeout;
    protected final int _global_size;
    protected int _process_size;
    private final ByteArrayStorage _store = new ByteArrayStorage();

    PromelaTransition newEndAtomic() {
        return new PromelaTransition(){
            private int _backup;

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public PromelaProcess getProcess() {
                return null;
            }

            @Override
            public boolean isLocal() {
                return true;
            }

            @Override
            public int getId() {
                return -2;
            }

            @Override
            public void take() throws ValidationException {
                this._backup = PromelaModel.this._exclusive;
                PromelaModel.this._exclusive = 255;
            }

            @Override
            public void undo() {
                PromelaModel.this._exclusive = this._backup;
            }

            public String toString() {
                return "-end-atomic-";
            }

            @Override
            public PromelaTransitionFactory getFactory() {
                return null;
            }
        };
    }

    protected PromelaModel(String string, int n) {
        this._procs = new PromelaProcess[255];
        this._channels = new Channel[255];
        this._name = string;
        this._exclusive = 255;
        this._ignore_assert = false;
        this._global_size = n;
    }

    public void enableAssertions() {
        this._ignore_assert = false;
    }

    public void disableAssertions() {
        this._ignore_assert = true;
    }

    public int addChannel(Channel channel) throws TooManyChannelsException {
        if (this._nrChannels >= 255) {
            throw new TooManyChannelsException("Maximum number of channels reached: 255");
        }
        this._channels[this._nrChannels] = channel;
        return this._nrChannels++;
    }

    public int addProcess(PromelaProcess promelaProcess) throws TooManyProcessesException {
        if (this._nrProcs >= 255) {
            throw new TooManyProcessesException("too many processes");
        }
        this._procs[this._nrProcs++] = promelaProcess;
        this._process_size += promelaProcess.getSize();
        return this._nrProcs - 1;
    }

    public Channel[] endProcess() {
        this._process_size -= this._procs[--this._nrProcs].getSize();
        int n = this._nrChannels - this._procs[this._nrProcs].getNrChannelsBefore();
        this._procs[this._nrProcs] = null;
        if (n > 0) {
            Channel[] channelArray = new Channel[n];
            while (--n >= 0) {
                channelArray[n] = this._channels[--this._nrChannels];
                this._channels[this._nrChannels] = null;
            }
            return channelArray;
        }
        return null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public PromelaProcess getNever() throws ValidationException {
        return null;
    }

    @Override
    public int getNrProcesses() {
        return this._nrProcs;
    }

    public PromelaProcess getProcess(int n) {
        return this._procs[n];
    }

    @Override
    public int getSize() {
        int n = this._global_size + this._process_size;
        for (int i = 0; i < this._nrChannels; ++i) {
            n += this._channels[i].getSize();
        }
        return n;
    }

    protected void printf(String string, Object ... objectArray) {
        this.sendPrintEvent(String.format(string, objectArray));
    }

    @Override
    public boolean conditionHolds(int n) {
        if (n == 4) {
            return this._exclusive == 255;
        }
        return super.conditionHolds(n);
    }

    @Override
    public String toString() {
        return this._name;
    }

    @Override
    public PromelaTransition nextTransition(PromelaTransition promelaTransition) {
        PromelaTransition promelaTransition2 = null;
        if (this._nrProcs > 0) {
            if (this._exclusive == 255) {
                int n = promelaTransition == null ? this._nrProcs - 1 : promelaTransition.getProcess()._pid;
                PromelaProcess promelaProcess = promelaTransition == null ? this._procs[n] : promelaTransition.getProcess();
                promelaTransition2 = promelaProcess.nextTransition(promelaTransition);
                while (promelaTransition2 == null && n > 0) {
                    promelaProcess = this._procs[--n];
                    promelaTransition2 = promelaProcess.nextTransition((PromelaTransition)null);
                }
            } else {
                promelaTransition2 = this._procs[this._exclusive].nextTransition(promelaTransition);
            }
        }
        return promelaTransition2;
    }

    @Override
    public PromelaModel clone() {
        try {
            return (PromelaModel)this.getClass().getConstructor(Boolean.TYPE).newInstance(this._ignore_assert);
        }
        catch (Exception exception) {
            System.err.println("error: kan geen correcte constructor vinden van dit model, er moet een constructor zijn met alleen een boolean als parameter");
            return null;
        }
    }

    public byte[] encode() {
        this._store.init(this.getSize());
        this.encode(this._store);
        return this._store.getBuffer();
    }

    public boolean decode(byte[] byArray) {
        this._store.setBuffer(byArray);
        return this.decode(this._store);
    }
}

