/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.variable.ChannelType;
import spinja.promela.compiler.variable.ChannelVariable;
import spinja.promela.compiler.variable.Variable;
import spinja.promela.compiler.variable.VariableStore;
import spinja.util.StringWriter;

public class Specification
implements Iterable<Proctype> {
    private final String name;
    private final List<Proctype> procs;
    private final List<ChannelType> channels;
    private Proctype never;
    private final VariableStore varStore;
    private final List<String> mtypes;

    public Specification(String string) {
        this.name = string;
        this.procs = new ArrayList<Proctype>();
        this.channels = new ArrayList<ChannelType>();
        this.varStore = new VariableStore();
        this.mtypes = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public ChannelType newChannelType(int n) {
        ChannelType channelType = new ChannelType(this.channels.size(), n);
        this.channels.add(channelType);
        return channelType;
    }

    public boolean usesRendezvousChannel() {
        for (ChannelType channelType : this.channels) {
            if (channelType.getBufferSize() != 0) continue;
            return true;
        }
        return false;
    }

    public void addMType(String string) {
        this.mtypes.add(string);
    }

    public void addProc(Proctype proctype) throws ParseException {
        if (this.getProcess(proctype.getName()) != null) {
            throw new ParseException("Duplicate proctype with name: " + proctype.getName());
        }
        this.procs.add(proctype);
    }

    private void generateConstructor(StringWriter stringWriter) throws ParseException {
        stringWriter.appendLine("public ", this.name, "Model() throws SpinJaException {").indent();
        stringWriter.appendLine("super(\"", this.name, "\", ", this.varStore.getBufferSize() + 1 + (ChannelVariable.isChannelsUsed() ? 1 : 0) + (this.usesAtomic() ? 1 : 0), ");");
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("// Initialize the default values");
        for (Variable object : this.varStore.getVariables()) {
            object.printInitExpr(stringWriter);
        }
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("// Initialize the starting processes");
        for (Proctype proctype : this.procs) {
            for (int i = 0; i < proctype.getNrActive(); ++i) {
                stringWriter.appendLine("addProcess(new ", proctype.getName(), "());");
            }
        }
        stringWriter.appendLine(new Object[0]);
        stringWriter.outdent().appendLine("}");
        stringWriter.appendLine(new Object[0]);
    }

    private void generateMain(StringWriter stringWriter) {
        stringWriter.appendLine("public static void main(String[] args) {").indent();
        stringWriter.appendLine("Run run = new Run();");
        stringWriter.appendLine("run.parseArguments(args,\"" + this.name + "\");");
        stringWriter.appendLine("run.search(" + this.name + "Model.class);");
        stringWriter.outdent().appendLine("}");
        stringWriter.appendLine(new Object[0]);
    }

    public String generateModel() throws ParseException {
        StringWriter stringWriter = new StringWriter();
        stringWriter.appendLine("package spinja;");
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("import spinja.util.DataReader;");
        stringWriter.appendLine("import spinja.util.DataWriter;");
        stringWriter.appendLine("import spinja.Run;");
        stringWriter.appendLine("import spinja.promela.model.*;");
        stringWriter.appendLine("import spinja.exceptions.*;");
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("public class ", this.name, "Model extends PromelaModel {").indent();
        stringWriter.appendLine(new Object[0]);
        this.generateMain(stringWriter);
        this.generateCustomTypes(stringWriter);
        this.generateVariables(stringWriter);
        this.generateConstructor(stringWriter);
        this.generateStore(stringWriter);
        this.generateToString(stringWriter);
        this.generateProctypes(stringWriter);
        stringWriter.outdent().appendLine("}");
        return stringWriter.toString();
    }

    private void generateCustomTypes(StringWriter stringWriter) {
        for (ChannelType channelType : this.channels) {
            channelType.generateClass(stringWriter);
        }
    }

    private void generateProctypes(StringWriter stringWriter) throws ParseException {
        for (Proctype proctype : this.procs) {
            stringWriter.appendLine(new Object[0]);
            proctype.generateCode(stringWriter);
        }
        if (this.never != null) {
            stringWriter.appendLine("public PromelaProcess getNever() throws ValidationException {").indent();
            stringWriter.appendLine("return new never();");
            stringWriter.outdent().appendLine("}").appendLine(new Object[0]);
            this.never.generateCode(stringWriter);
        }
    }

    private void generateStore(StringWriter stringWriter) {
        int n;
        stringWriter.appendLine("public void encode(DataWriter _writer) {").indent();
        stringWriter.appendLine("_writer.writeByte(_nrProcs);");
        if (this.usesAtomic()) {
            stringWriter.appendLine("_writer.writeByte(_exclusive);");
        }
        if (ChannelVariable.isChannelsUsed()) {
            stringWriter.appendLine("_writer.writeByte(_nrChannels);");
        }
        this.varStore.printEncode(stringWriter);
        if (ChannelVariable.isChannelsUsed()) {
            stringWriter.appendLine("for(int _i = 0; _i < _nrChannels; _i++) {");
            stringWriter.indent();
            stringWriter.appendLine("_channels[_i].encode(_writer);");
            stringWriter.outdent();
            stringWriter.appendLine("}");
        }
        stringWriter.appendLine("for(int _i = 0; _i < _nrProcs; _i++) {");
        stringWriter.indent();
        stringWriter.appendLine("_procs[_i].encode(_writer);");
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.outdent().appendLine("}");
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("public boolean decode(DataReader _reader) {").indent();
        stringWriter.appendLine("_nrProcs = _reader.readByte();");
        if (this.usesAtomic()) {
            stringWriter.appendLine("_exclusive = _reader.readByte();");
        }
        if (ChannelVariable.isChannelsUsed()) {
            stringWriter.appendLine("_nrChannels = _reader.readByte();");
        }
        this.varStore.printDecode(stringWriter);
        if (ChannelVariable.isChannelsUsed()) {
            stringWriter.appendLine(new Object[0]);
            stringWriter.appendLine("for(int _i = 0; _i < _nrChannels; _i++) {");
            stringWriter.indent();
            stringWriter.appendLine("_reader.storeMark();");
            stringWriter.appendLine("if(_channels[_i] == null || !_channels[_i].decode(_reader)) {");
            stringWriter.indent();
            stringWriter.appendLine("_reader.resetMark();");
            stringWriter.appendLine("switch(_reader.peekByte()) {");
            stringWriter.indent();
            for (n = 0; n < this.channels.size(); ++n) {
                stringWriter.appendLine("case ", n, ": _channels[_i] = new Channel", this.channels.get(n).getId(), "(); break;");
            }
            stringWriter.appendLine("default: return false;");
            stringWriter.outdent();
            stringWriter.appendLine("}");
            stringWriter.appendLine("if(!_channels[_i].decode(_reader)) return false;");
            stringWriter.outdent();
            stringWriter.appendLine("}");
            stringWriter.outdent();
            stringWriter.appendLine("}");
        }
        stringWriter.appendLine(new Object[0]);
        stringWriter.appendLine("int _start = _reader.getMark();");
        stringWriter.appendLine("for(int _i = 0; _i < _nrProcs; _i++) {");
        stringWriter.indent();
        stringWriter.appendLine("_reader.storeMark();");
        stringWriter.appendLine("if(_procs[_i] == null || !_procs[_i].decode(_reader)) {");
        stringWriter.indent();
        stringWriter.appendLine("_reader.resetMark();");
        stringWriter.appendLine("switch(_reader.peekByte()) {");
        stringWriter.indent();
        for (n = 0; n < this.procs.size(); ++n) {
            stringWriter.appendLine("case ", n, ": _procs[_i] = new ", this.procs.get(n).getName(), "(true); break;");
        }
        stringWriter.appendLine("default: return false;");
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine("if(!_procs[_i].decode(_reader)) return false;");
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.outdent();
        stringWriter.appendLine("}");
        stringWriter.appendLine("_process_size = _reader.getMark() - _start;");
        stringWriter.appendLine("return true;");
        stringWriter.outdent().appendLine("}");
        stringWriter.appendLine(new Object[0]);
    }

    private void generateToString(StringWriter stringWriter) {
        stringWriter.appendLine("public String toString() {").indent();
        stringWriter.appendLine("StringBuilder sb = new StringBuilder();");
        stringWriter.appendLine("sb.append(\"", this.name, "Model: \");");
        this.varStore.printToString(stringWriter);
        stringWriter.appendLine("for(int i = 0; i < _nrProcs; i++) {");
        stringWriter.appendLine("  sb.append('\\n').append(_procs[i]);");
        stringWriter.appendLine("}");
        stringWriter.appendLine("for(int i = 0; i < _nrChannels; i++) {");
        stringWriter.appendLine("  sb.append('\\n').append(_channels[i]);");
        stringWriter.appendLine("}");
        stringWriter.appendLine("return sb.toString();");
        stringWriter.outdent().appendLine("}");
    }

    private void generateVariables(StringWriter stringWriter) {
        for (Variable variable : this.varStore.getVariables()) {
            if (variable.getName().charAt(0) == '_') continue;
            stringWriter.appendLine(variable.getType().getJavaName(), variable.getArraySize() > 1 ? "[]" : "", " ", variable.getName(), ";");
        }
        stringWriter.appendLine(new Object[0]);
    }

    public int getMType(String string) {
        return this.mtypes.indexOf(string);
    }

    public Proctype getNever() {
        return this.never;
    }

    public Proctype getProcess(String string) {
        for (Proctype proctype : this.procs) {
            if (!proctype.getName().equals(string)) continue;
            return proctype;
        }
        return null;
    }

    public VariableStore getVariableStore() {
        return this.varStore;
    }

    public boolean usesAtomic() {
        for (Proctype proctype : this.procs) {
            if (!proctype.getAutomaton().hasAtomic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Proctype> iterator() {
        return this.procs.iterator();
    }

    public void setNever(Proctype proctype) throws ParseException {
        if (this.never != null) {
            throw new ParseException("Duplicate never claim");
        }
        this.never = proctype;
    }
}

