/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.Position;

public class PosAndCol
extends Position {
    public int column;

    public PosAndCol(int l, int i, int c) {
        this.item = i;
        this.line = l;
        this.column = c;
    }

    public static void sort(PosAndCol[] a) {
        int N = a.length;
        for (int k = N / 2; k > 0; --k) {
            PosAndCol.downHeap(a, k, N);
        }
        do {
            PosAndCol T = a[0];
            a[0] = a[N - 1];
            a[N - 1] = T;
            PosAndCol.downHeap(a, 1, --N);
        } while (N > 1);
    }

    private static void downHeap(PosAndCol[] a, int k, int N) {
        PosAndCol T = a[k - 1];
        while (k <= N / 2) {
            int j = k + k;
            if (j < N && PosAndCol.lessThan(a[j - 1], a[j])) {
                ++j;
            }
            if (!PosAndCol.lessThan(T, a[j - 1])) break;
            a[k - 1] = a[j - 1];
            k = j;
        }
        a[k - 1] = T;
    }

    private static boolean lessThan(PosAndCol pc1, PosAndCol pc2) {
        if (pc1.column < pc2.column) {
            return true;
        }
        if (pc1.column == pc2.column) {
            return pc1.line < pc2.line;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[line |-> " + this.line + ", item |-> " + this.item + ", col |-> " + this.column + "]";
    }
}

