/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.transformations.forUML;

import java.util.HashMap;
import java.util.Map;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.GuardStmt;
import org.cte.ABCD.model.statements.ReceiveStmt;
import org.cte.ABCD.model.statements.SelectStmt;
import org.cte.ABCD.model.statements.Transition;

public class GetReceiveBranchesInState {
    private static boolean isValid = true;

    public static Map<ReceiveStmt, GuardStmt> run(Transition transition) throws Exception {
        final HashMap<ReceiveStmt, GuardStmt> receive2Guard = new HashMap<ReceiveStmt, GuardStmt>();
        transition.accept(new ABCDVisitor.Stub(){
            private GuardStmt guardOnCurrentBranch = null;
            private ReceiveStmt receiveOnCurrentBranch = null;

            @Override
            public void visitReceiveStmt(ReceiveStmt stm) {
                if (this.receiveOnCurrentBranch == null) {
                    this.receiveOnCurrentBranch = stm;
                    return;
                }
                System.err.println("Invalid model, more than one receive per transition");
                isValid = false;
            }

            @Override
            public void visitGuardStmt(GuardStmt stm) {
                if (this.guardOnCurrentBranch == null) {
                    this.guardOnCurrentBranch = stm;
                    return;
                }
                System.err.println("Invalid model, more than one guard per transition");
                isValid = false;
            }

            @Override
            public void visitSelectStmt(SelectStmt stm) {
                for (Statement s : stm.getStatementsList()) {
                    s.accept(this);
                    if (this.receiveOnCurrentBranch != null) {
                        receive2Guard.put(this.receiveOnCurrentBranch, this.guardOnCurrentBranch);
                    }
                    this.receiveOnCurrentBranch = null;
                    this.guardOnCurrentBranch = null;
                }
            }

            @Override
            public void visitTransition(Transition node) {
                node.getBehavior().accept(this);
                if (this.receiveOnCurrentBranch != null) {
                    receive2Guard.put(this.receiveOnCurrentBranch, this.guardOnCurrentBranch);
                }
            }

            @Override
            public void visitBlock(Block node) {
                for (Statement s : node.getStatementsList()) {
                    s.accept(this);
                }
            }
        });
        if (!isValid) {
            throw new Exception("Invalid ABCD model");
        }
        return receive2Guard;
    }
}

