/*
 * Decompiled with CFR 0.152.
 */
package obp.cdl.parser;

import beaver.Parser;
import beaver.Scanner;
import beaver.Symbol;

public class CDLParsingReport
extends Parser.Events {
    public void scannerError(Scanner.Exception e) {
        StringBuilder message = new StringBuilder();
        message.append("Scanner Error: ");
        message.append(e.getMessage());
        message.append(" (");
        message.append("line ");
        message.append(e.line);
        message.append(" column ");
        message.append(e.column);
        message.append(").");
        throw new RuntimeException(message.toString());
    }

    public void syntaxError(Symbol token) {
        StringBuilder message = new StringBuilder();
        message.append("Syntax Error: unexpected token ");
        if (token.value != null) {
            message.append('\"');
            message.append(token.value);
            message.append('\"');
        } else {
            message.append('#');
            message.append(token.getId());
        }
        int lineStart = Symbol.getLine((int)token.getStart());
        int columnStart = Symbol.getColumn((int)token.getStart());
        int lineEnd = Symbol.getLine((int)token.getEnd());
        int columnEnd = Symbol.getColumn((int)token.getEnd());
        message.append(" (");
        if (lineStart == lineEnd) {
            message.append("line ");
            message.append(lineStart);
            if (columnStart == columnEnd) {
                message.append(" column ");
                message.append(columnStart);
            } else {
                message.append(" columns from ");
                message.append(columnStart);
                message.append(" to ");
                message.append(columnEnd);
            }
        } else {
            message.append("from line ");
            message.append(lineStart);
            message.append(", column ");
            message.append(columnStart);
            message.append(" to line ");
            message.append(lineEnd);
            message.append(", column ");
            message.append(columnEnd);
        }
        message.append(").");
        throw new RuntimeException(message.toString());
    }
}

