/*
 * Decompiled with CFR 0.152.
 */
package obp.aut;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import obp.aut.Edge;

public class Aut {
    protected int start;
    protected final List<Edge> edgeList = new ArrayList<Edge>();
    private final HashMap<Integer, Collection<Edge>> cachedEdges = new HashMap();
    protected String name;
    protected int stateNumber;

    public int getStart() {
        return this.start;
    }

    public void setStart(int newValue) {
        this.start = newValue;
    }

    public List<Edge> getEdgeList() {
        return Collections.unmodifiableList(this.edgeList);
    }

    public int getEdgeCount() {
        return this.edgeList.size();
    }

    public Edge getEdge(int index) {
        if (index < 0 || index >= this.getEdgeCount()) {
            return null;
        }
        return this.edgeList.get(index);
    }

    public void addEdge(Edge newValue) {
        this.addEdge(this.getEdgeCount(), newValue);
    }

    public void addEdge(int index, Edge newValue) {
        this.edgeList.add(index, newValue);
    }

    public void removeEdge(int index) {
        this.edgeList.remove(index);
    }

    public Collection<Edge> allFrom(int sourceId) {
        if (!this.cachedEdges.containsKey(sourceId)) {
            ArrayList<Edge> result = new ArrayList<Edge>();
            for (Edge edge : this.edgeList) {
                if (edge.getSource() != sourceId) continue;
                result.add(edge);
            }
            this.cachedEdges.put(sourceId, result);
        }
        return this.cachedEdges.get(sourceId);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public int getStateNumber() {
        return this.stateNumber;
    }

    public void setStateNumber(int newValue) {
        this.stateNumber = newValue;
    }

    public String toDot() {
        StringBuilder dot = new StringBuilder();
        dot.append("strict digraph ");
        dot.append(this.name);
        dot.append(" { \n\trankdir=TB;\n");
        for (Edge edge : this.edgeList) {
            dot.append("\t");
            dot.append(edge.source);
            dot.append(" -> ");
            dot.append(edge.target);
            dot.append(" [label=\"");
            String label = edge.label.replaceAll("\n", "\\n");
            dot.append(label);
            dot.append("\"];\n");
        }
        dot.append("}\n");
        return dot.toString();
    }
}

