/*
 * Decompiled with CFR 0.152.
 */
package plug.language.buchikripke.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import plug.core.ILanguageLoader;
import plug.core.RuntimeDescription;
import plug.language.buchi.runtime.BuchiRuntime;
import plug.language.buchikripke.runtime.KripkeBuchiDescription;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.LTL.parser.Parser;
import properties.LTL.transformations.LTL2Buchi;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;

public class KripkeBuchiLoader
implements ILanguageLoader<KripkeBuchiProductSemantics> {
    protected BuchiDeclaration getBuchiDeclaration(String ltlFormula) {
        DeclarationBlock propertiesBlock = Parser.parseBlock((String)ltlFormula);
        Expression property = ((ExpressionDeclaration)propertiesBlock.getDeclarations().iterator().next()).getExpression();
        LTL2Buchi convertor = new LTL2Buchi(new PrintWriter(System.out));
        BuchiDeclaration decl = convertor.convert(property);
        return decl;
    }

    public KripkeBuchiProductSemantics getRuntime(URI modelURI, Map<String, Object> options) throws Exception {
        KripkeBuchiDescription description = (KripkeBuchiDescription)new ObjectMapper().readValue(modelURI.toURL(), KripkeBuchiDescription.class);
        Path modelPath = Paths.get(description.getModel(), new String[0]);
        Path resolvedModelPath = modelPath.isAbsolute() ? modelPath : Paths.get(modelURI).getParent().resolve(modelPath);
        RuntimeDescription kripke = new RuntimeDescription(resolvedModelPath);
        StringBuilder ltl = new StringBuilder();
        description.getProperties().forEach((name, expression) -> {
            ltl.append((String)name);
            ltl.append(" = ");
            ltl.append((String)expression);
            ltl.append("\n");
        });
        BuchiDeclaration buchiAutomaton = this.getBuchiDeclaration(ltl.toString());
        BuchiRuntime buchiRuntime = new BuchiRuntime(buchiAutomaton);
        KripkeBuchiProductSemantics kbProductSemantics = new KripkeBuchiProductSemantics(kripke, buchiRuntime);
        return kbProductSemantics;
    }
}

