/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.geometry;

public class Transformation {
    public static float transformX(float[] tr, float x, float y) {
        return x * tr[0] + y * tr[2] + tr[4];
    }

    public static float transformY(float[] tr, float x, float y) {
        return x * tr[1] + y * tr[3] + tr[5];
    }

    public static float inverseTransformX(float[] tr, float x, float y) {
        float d = tr[0] * tr[3] - tr[1] * tr[2];
        return ((x - tr[4]) * tr[3] - (y - tr[5]) * tr[2]) / d;
    }

    public static float inverseTransformY(float[] tr, float x, float y) {
        float d = tr[0] * tr[3] - tr[1] * tr[2];
        return ((y - tr[5]) * tr[0] - (x - tr[4]) * tr[1]) / d;
    }

    public static void transform(float[] tr, float[] points) {
        int i = 0;
        for (int j = 1; j < points.length; j += 2) {
            float x = points[i];
            float y = points[j];
            points[i] = Transformation.transformX(tr, x, y);
            points[j] = Transformation.transformY(tr, x, y);
            i += 2;
        }
    }

    public static void inverseTransform(float[] tr, float[] points) {
        float d = tr[0] * tr[3] - tr[1] * tr[2];
        int i = 0;
        for (int j = 1; j < points.length; j += 2) {
            float x = points[i];
            float y = points[j];
            points[i] = ((x - tr[4]) * tr[3] - (y - tr[5]) * tr[2]) / d;
            points[j] = ((y - tr[5]) * tr[0] - (x - tr[4]) * tr[1]) / d;
            i += 2;
        }
    }

    public static float vectorTransformX(float[] tr, float x, float y) {
        return x * tr[0] + y * tr[2];
    }

    public static float vectorTransformY(float[] tr, float x, float y) {
        return x * tr[1] + y * tr[3];
    }

    public static float vectorInverseTransformX(float[] tr, float x, float y) {
        float d = tr[0] * tr[3] - tr[1] * tr[2];
        return (x * tr[3] - y * tr[2]) / d;
    }

    public static float vectorInverseTransformY(float[] tr, float x, float y) {
        float d = tr[0] * tr[3] - tr[1] * tr[2];
        return (y * tr[0] - x * tr[1]) / d;
    }

    public static float[] newIdentityTransformation() {
        return new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    }

    public static float[] newTransformation(float xScale, float yScale, float[] point1, float[] point2) {
        float xOffset = point2[0] - point1[0] * xScale;
        float yOffset = point2[1] - point1[1] * yScale;
        return new float[]{xScale, 0.0f, 0.0f, yScale, xOffset, yOffset};
    }

    public static float[] newTransformation(float[] rectangle1, float[] rectangle2) {
        float xScale = (rectangle2[2] - rectangle2[0]) / (rectangle1[2] - rectangle1[0]);
        float yScale = (rectangle2[3] - rectangle2[1]) / (rectangle1[3] - rectangle1[1]);
        float xOffset = rectangle2[0] - rectangle1[0] * xScale;
        float yOffset = rectangle2[1] - rectangle1[1] * yScale;
        return new float[]{xScale, 0.0f, 0.0f, yScale, xOffset, yOffset};
    }

    public static float[] newTranslateTransformation(float dx, float dy) {
        return new float[]{1.0f, 0.0f, 0.0f, 1.0f, dx, dy};
    }

    public static float[] newScaleTransformation(float sx, float sy) {
        return new float[]{sx, 0.0f, 0.0f, sy, 0.0f, 0.0f};
    }

    public static float[] newRotationTransformation(double angle) {
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        return new float[]{c, s, -s, c, 0.0f, 0.0f};
    }

    public static float[] getInverseTransformation(float[] tr) {
        float d = tr[0] * tr[3] - tr[1] * tr[2];
        return new float[]{tr[3] / d, -tr[1] / d, -tr[2] / d, tr[0] / d, (tr[2] * tr[5] - tr[3] * tr[4]) / d, (tr[1] * tr[4] - tr[0] * tr[5]) / d};
    }

    public static float[] getComposedTransformation(float[] tr2, float[] tr1) {
        return new float[]{tr2[0] * tr1[0] + tr2[2] * tr1[1], tr2[1] * tr1[0] + tr2[3] * tr1[1], tr2[0] * tr1[2] + tr2[2] * tr1[3], tr2[1] * tr1[2] + tr2[3] * tr1[3], tr2[0] * tr1[4] + tr2[2] * tr1[5] + tr2[4], tr2[1] * tr1[4] + tr2[3] * tr1[5] + tr2[5]};
    }

    public static boolean areEqual(float[] tr1, float[] tr2) {
        for (int i = 0; i < 6; ++i) {
            if (Transformation.fequals(tr1[i], tr2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentity(float[] tr) {
        return Transformation.fequals(tr[4], 0.0f) && Transformation.fequals(tr[5], 0.0f) && Transformation.isTranslation(tr);
    }

    public static boolean isTranslation(float[] tr) {
        return Transformation.fequals(tr[0], 1.0f) && Transformation.fequals(tr[1], 0.0f) && Transformation.fequals(tr[2], 0.0f) && Transformation.fequals(tr[3], 1.0f);
    }

    public static boolean fequals(float float1, float float2) {
        return Math.abs(float1 - float2) <= 1.0E-6f;
    }
}

