/*
 * Decompiled with CFR 0.152.
 */
package obp.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import obp.OBPConfiguration;
import obp.OBPController;
import obp.cdl.CDLDeclaration;
import obp.ui.Actions;
import obp.ui.OBPModel4GUI;
import obp.ui.Resources;
import obp.ui.cdl.CDLUnitController;
import obp.ui.explorer.ExplorerResultListController;
import obp.ui.fiacre.ProgramController;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.Basics;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.error.NumberValidator;
import org.xid.basics.error.Validator;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.JBoost;
import org.xid.basics.ui.PlatformUtil;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.action.ActionExecuter;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.dialog.FieldShellToolkit;
import org.xid.basics.ui.field.BorderField;
import org.xid.basics.ui.field.CheckboxField;
import org.xid.basics.ui.field.ChoiceField;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.ConsoleField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.MultiTabField;
import org.xid.basics.ui.field.TextField;

public class OBP {
    private String version;
    private String date;
    private final DateFormat format = SimpleDateFormat.getDateTimeInstance();
    private Display display;
    private Shell shell;
    private FieldShellToolkit toolkit;
    private Actions actions;
    private Resources resources;
    private BorderField shellField;
    private MultiTabField centerField;
    private ChoiceField<CDLDeclaration> cdlChoiceField;
    private TextField cdlFileField;
    private CheckboxField cdlPartitionField;
    private TextField cdlInitialSplitField;
    private TextField cdlSplitStepField;
    private TextField cdlInfoTextField;
    private CompositeField cdlFileComposite;
    private ListField<File> programFileField;
    private CompositeField filesCompositeField;
    private CheckboxField saveConfigurationFileField;
    private CDLUnitController cdlController;
    private ProgramController programController;
    private ExplorerResultListController explorerResultListController;
    private MultiTabField southField;
    private TextField resultsField;
    private CompositeField resultsCompositeField;
    private ConsoleField consoleField;
    private CompositeField consoleCompositeField;
    private boolean working = false;
    private boolean cdlWorking = false;
    boolean forABCD = false;
    private ActionExecuter executer = new ActionExecuter(){

        public void executeAction(Action action) {
            if (action.getVisibility() == 1) {
                action.run(ActionMonitor.empty);
                if (!OBP.this.shell.isDisposed()) {
                    OBP.this.display.asyncExec(OBP.this.refreshRunnable);
                }
            }
        }
    };
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            OBP.this.refreshFields();
            OBP.this.consoleField.scrollToTheEnd();
        }
    };
    private ErrorHandler errorHandler = new ErrorHandler(){

        public void handleError(int type, String message) {
            this.handleError((Diagnostic)new Diagnostic.Stub(type, message));
        }

        public void handleError(Diagnostic diagnostic) {
            switch (diagnostic.getLevel()) {
                case 0: {
                    OBP.this.info(diagnostic.getMessage());
                    break;
                }
                case 1: {
                    OBP.this.warning(diagnostic.getMessage());
                    break;
                }
                case 2: {
                    OBP.this.error(diagnostic.getMessage());
                }
            }
        }
    };
    private final NotificationListener listener = new NotificationListener(){

        public void notified(Notification notification) {
            if (notification.type == 1 && notification.getSource() instanceof Field) {
                OBP.this.updateModel((Field)notification.getSource());
            }
        }
    };
    private final OBPModel4GUI model = new OBPModel4GUI(this.errorHandler);
    private OBPConfiguration obpConfiguration;
    private OBPController obpController;

    public OBP(boolean forABCD) {
        this.forABCD = forABCD;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Resources getResources() {
        return this.resources;
    }

    public OBPModel4GUI getModel() {
        return this.model;
    }

    public OBPConfiguration getConfiguration() {
        return this.obpConfiguration;
    }

    private File getOBPConfigurationFile() {
        return new File(System.getProperty("user.home"), ".OBP.conf");
    }

    private JBoost createExplorerConfigurationBoost() {
        return new JBoost("ExplorerConf", 1);
    }

    private void saveConfiguration() {
        try {
            JBoost boost = this.createExplorerConfigurationBoost();
            boost.initializeWriting((OutputStream)new FileOutputStream(this.getOBPConfigurationFile()));
            boost.writeObject((BoostObject)this.obpConfiguration);
            boost.close();
        }
        catch (Exception e) {
            this.log("Can't save configuration to file '" + this.getOBPConfigurationFile().getAbsolutePath() + "'.");
        }
    }

    private void initVersion() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("version.properties"));
            this.version = properties.getProperty("version");
            this.date = properties.getProperty("date");
        }
        catch (Exception e) {
            this.warning(DiagnosticUtil.createMessage((Throwable)e));
            this.version = "unknown";
            this.date = "unknown";
        }
    }

    private void initController() {
        try {
            JBoost boost = this.createExplorerConfigurationBoost();
            boost.initializeReading((InputStream)new FileInputStream(this.getOBPConfigurationFile()));
            this.obpConfiguration = (OBPConfiguration)boost.readObject(OBPConfiguration.class);
            boost.close();
        }
        catch (Exception e) {
            this.obpConfiguration = new OBPConfiguration();
        }
        this.obpController = new OBPController(this.obpConfiguration.getExplorerConfiguration(), this.consoleField.createPrintWriter(2, 0), this.consoleField.createPrintWriter(4, 1));
        this.obpController.setErrorHandler(this.errorHandler);
    }

    public void open() {
        this.initVersion();
        this.display = new Display();
        this.resources = (Resources)Resources.getInstance(Resources.class);
        this.actions = new Actions(this);
        this.shell = FieldShellToolkit.createShell((Display)this.display, (String)"OBP");
        this.toolkit = new FieldShellToolkit(this.shell, this.getVersionString(), 1, this.createFields());
        this.toolkit.setBannerImage(this.resources.getImage("obp100x66.png"));
        this.toolkit.setActionExecuter(this.executer);
        this.toolkit.setMenuActions(this.actions.getMenuAction().getActions());
        this.toolkit.init();
        PlatformUtil.registerCocoaNameAboutAndPreference((String)"OBP", (Action)new Action.Stub(), (Action)this.actions.getPreferencesAction());
        this.initController();
        this.refreshFields();
        this.toolkit.validateAll();
        this.installActivateListener();
        this.shell.setSize(800, 650);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            try {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            catch (Throwable e) {
                this.error(DiagnosticUtil.createMessage((Throwable)e) + "\n");
            }
        }
        this.dispose();
        this.display.dispose();
        if (this.model != null && this.model.simu != null) {
            this.model.simu.dispose();
        }
        System.exit(0);
    }

    public void installActivateListener() {
        this.shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (OBP.this.model.reloadFilesIfNeeded(true)) {
                    OBP.this.refreshFields();
                }
            }
        });
    }

    private Field createFields() {
        this.centerField = new MultiTabField(null, 64);
        this.cdlFileField = new TextField("File", 1);
        this.cdlFileField.addAction(this.actions.getOpenCdlFileAction(this.cdlFileField));
        this.cdlChoiceField = new ChoiceField<CDLDeclaration>("CDL", 2){

            public String getText(CDLDeclaration element) {
                return element.getName();
            }
        };
        this.cdlChoiceField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name)) {
                    OBP.this.model.setCdl((CDLDeclaration)OBP.this.cdlChoiceField.getValue());
                    OBP.this.refreshFilesFields();
                }
            }
        });
        this.cdlPartitionField = new CheckboxField("Partition");
        this.cdlPartitionField.setValue(this.model.isAutoPartition());
        this.cdlPartitionField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name)) {
                    OBP.this.model.setAutoPartition(OBP.this.cdlPartitionField.getValue());
                    OBP.this.refreshFilesFields();
                }
            }
        });
        this.cdlInitialSplitField = new TextField("Initial Split");
        this.cdlInitialSplitField.setEnable(this.model.isAutoPartition());
        this.cdlInitialSplitField.setValidator((Validator)new NumberValidator(2, "Invalid split parameter", Basics.NOT_ZERO));
        this.cdlInitialSplitField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name) && OBP.this.cdlInitialSplitField.getIntValue() > 0) {
                    OBP.this.model.setInitialStep(OBP.this.cdlInitialSplitField.getIntValue());
                    OBP.this.refreshFilesFields();
                }
            }
        });
        this.cdlSplitStepField = new TextField("Split step");
        this.cdlSplitStepField.setEnable(this.model.isAutoPartition());
        this.cdlSplitStepField.setValidator((Validator)new NumberValidator(2, "Invalid split parameter", Basics.NOT_ZERO));
        this.cdlSplitStepField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name) && OBP.this.cdlSplitStepField.getIntValue() > 0) {
                    OBP.this.model.setSplitStep(OBP.this.cdlSplitStepField.getIntValue());
                    OBP.this.refreshFilesFields();
                }
            }
        });
        CompositeField cdlPartitionCompositeField = new CompositeField("Partition", 16, new Field[]{this.cdlPartitionField, this.cdlInitialSplitField, this.cdlSplitStepField});
        this.cdlInfoTextField = new TextField(null, 1);
        this.cdlInfoTextField.setNbLines(2);
        this.cdlInfoTextField.addAction((Action)new Action.Stub("Refresh"){

            public int getVisibility() {
                return OBP.this.cdlWorking ? 2 : 1;
            }

            public int run(ActionMonitor monitor) {
                OBP.this.cdlWorking = true;
                OBP.this.display.asyncExec(OBP.this.refreshRunnable);
                OBP.this.model.computeCdlInfo((ActionMonitor)new ActionMonitor.Stub(){

                    public void done() {
                        OBP.this.cdlWorking = false;
                        OBP.this.display.asyncExec(OBP.this.refreshRunnable);
                    }

                    public void canceled() {
                        OBP.this.cdlWorking = false;
                        OBP.this.display.asyncExec(OBP.this.refreshRunnable);
                    }
                });
                return 1;
            }
        });
        this.cdlInfoTextField.addAction((Action)new Action.Stub("Stop"){

            public int getVisibility() {
                return OBP.this.model.isComputingCdlInformation() ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                OBP.this.model.stopComputingCdlInformation();
                return 1;
            }
        });
        CompositeField cdlInfoCompositeField = new CompositeField("Informations", 16, new Field[]{this.cdlInfoTextField});
        BorderField cdlChoiceBorderField = new BorderField(0, this.cdlChoiceField);
        cdlChoiceBorderField.setEast((Field)this.cdlFileField, 70);
        CompositeField cdlChoiceCompositeField = new CompositeField("Choice", 16, new Field[]{cdlChoiceBorderField});
        BorderField cdlBorderField = new BorderField(0, (Field)cdlPartitionCompositeField);
        cdlBorderField.setNorth((Field)cdlChoiceCompositeField, 35);
        cdlBorderField.setEast((Field)cdlInfoCompositeField, 70);
        this.cdlFileComposite = new CompositeField("CDLs", 16, new Field[]{cdlBorderField});
        this.programFileField = new ListField<File>("Files", 3){

            public String getText(File element) {
                return element.getAbsolutePath();
            }
        };
        this.programFileField.addAction(this.actions.getAddProgramAction(this.programFileField));
        this.programFileField.addAction(this.actions.getRemoveProgramAction(this.programFileField));
        this.programFileField.addAction(this.actions.getUpProgramAction(this.programFileField));
        this.programFileField.addAction(this.actions.getDownProgramAction(this.programFileField));
        this.programFileField.addAction(this.actions.getClearProgramListAction(this.programFileField));
        CompositeField programFileComposite = new CompositeField("Program", 16, new Field[]{this.programFileField});
        this.saveConfigurationFileField = new CheckboxField("Fileout Resulting Configurations");
        this.saveConfigurationFileField.setValue(this.model.isSaveConfigurationFile());
        this.saveConfigurationFileField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                if (notification.type == 1 && "value".equals(notification.name)) {
                    OBP.this.model.setSaveConfigurationFile(OBP.this.saveConfigurationFileField.getValue());
                    OBP.this.refreshFilesFields();
                }
            }
        });
        this.filesCompositeField = new CompositeField("Files", new Field[]{this.cdlFileComposite, programFileComposite, this.saveConfigurationFileField});
        this.centerField.addTab((Field)this.filesCompositeField, null, false);
        this.cdlController = new CDLUnitController();
        CompositeField cdlControllerComposite = this.cdlController.createFields();
        cdlControllerComposite.addListener(this.cdlController.createListener(this.executer));
        CompositeField cdlCompositeField = new CompositeField("CDLs", new Field[]{cdlControllerComposite});
        this.centerField.addTab((Field)cdlCompositeField, null, false);
        this.programController = new ProgramController(this.errorHandler);
        CompositeField programControllerComposite = this.programController.createFields();
        programControllerComposite.addListener(this.programController.createListener(this.executer));
        CompositeField programCompositeField = new CompositeField("Program", new Field[]{programControllerComposite});
        this.centerField.addTab((Field)programCompositeField, null, false);
        this.explorerResultListController = new ExplorerResultListController(this.errorHandler);
        this.centerField.addTab((Controller)this.explorerResultListController, null, false);
        this.centerField.addAction(this.actions.getVerifyAction());
        this.centerField.addAction(this.actions.getSimulateAction());
        this.centerField.addAction(this.actions.getSeparatorAction());
        this.centerField.addAction(this.actions.getStopAction());
        this.southField = new MultiTabField(null, 64);
        this.resultsField = new TextField(null, 3);
        this.resultsField.setNbLines(3);
        this.resultsCompositeField = new CompositeField("Results", new Field[]{this.resultsField});
        this.southField.addTab((Field)this.resultsCompositeField, null, false);
        this.consoleField = new ConsoleField();
        this.consoleCompositeField = new CompositeField("Console", new Field[]{this.consoleField});
        this.southField.addTab((Field)this.consoleCompositeField, this.resources.getImage("eclipse/console_view.gif"), false);
        this.shellField = new BorderField(2, (Field)this.centerField);
        this.shellField.setSouth((Field)this.southField, 30);
        this.shellField.setActionExecuter(this.executer);
        this.shellField.addListener(this.listener);
        return this.shellField;
    }

    public void runSimulation() {
        if (!this.canVerify()) {
            return;
        }
        this.model.simulate(this.obpController, (ActionMonitor)new ActionMonitor.Stub());
    }

    public void refreshFields() {
        this.refreshFilesFields();
        this.refreshCdlFields();
        this.refresProgramFields();
        this.refreshConfigurations();
        this.refreshResults();
        this.toolkit.validateAll();
    }

    public void refreshFilesFields() {
        this.filesCompositeField.setEnable(!this.working);
        if (this.model.getCdlFile() != null) {
            this.cdlFileField.setValue(this.model.getCdlFile().getAbsolutePath());
        } else {
            this.cdlFileField.setValue("No CDL loaded.");
        }
        this.cdlChoiceField.setRange(this.model.getCdlList());
        this.cdlChoiceField.setValue((Object)this.model.getCdl());
        this.cdlPartitionField.setValue(this.model.isAutoPartition());
        this.cdlInitialSplitField.setEnable(this.model.isAutoPartition());
        this.cdlInitialSplitField.setIntValue(this.model.getInitialStep());
        this.cdlSplitStepField.setEnable(this.model.isAutoPartition());
        this.cdlSplitStepField.setIntValue(this.model.getSplitStep());
        this.cdlInfoTextField.setValue(this.model.getCdlInfoDescription());
        this.programFileField.setValue(this.model.getProgramFileList());
    }

    public void refreshCdlFields() {
        this.cdlController.setSubject(this.model.getCdlUnit());
        this.cdlController.refreshFields();
    }

    public void refresProgramFields() {
        this.programController.setSubject(this.model.getProgramSource());
        this.programController.refreshFields();
    }

    public void refreshResults() {
        String resultDescription = this.model.getResultDescription();
        this.resultsField.setValue(resultDescription == null ? "No results" : resultDescription);
    }

    public void refreshConfigurations() {
        this.explorerResultListController.refreshFields();
    }

    private void updateModel(Field field) {
        if (field == this.cdlPartitionField) {
            this.model.setAutoPartition(this.cdlPartitionField.getValue());
            this.cdlInitialSplitField.setEnable(this.model.isAutoPartition());
            this.cdlSplitStepField.setEnable(this.model.isAutoPartition());
        }
        if (field == this.cdlInitialSplitField) {
            this.model.setInitialStep(this.cdlInitialSplitField.getIntValue());
        }
        if (field == this.cdlSplitStepField) {
            this.model.setSplitStep(this.cdlSplitStepField.getIntValue());
        }
    }

    private void dispose() {
        this.explorerResultListController.close();
        Resources.releaseInstance(Resources.class);
        this.obpController.stop();
        this.saveConfiguration();
    }

    public String getVersionString() {
        return "OBP version " + this.version + " (" + this.date + ").\n";
    }

    public void log(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBP.this.consoleField.log(message);
            }
        });
    }

    public void info(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBP.this.consoleField.log(message, 2, 1);
                OBP.this.southField.setSelected((Field)OBP.this.consoleCompositeField);
            }
        });
    }

    public void warning(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBP.this.consoleField.log(message, 8, 2);
                OBP.this.southField.setSelected((Field)OBP.this.consoleCompositeField);
            }
        });
    }

    public void error(final String message) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBP.this.consoleField.log(message, 4, 1);
                OBP.this.southField.setSelected((Field)OBP.this.consoleCompositeField);
            }
        });
    }

    public void clearConsole() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                OBP.this.consoleField.clear();
            }
        });
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean isExplored() {
        return this.explorerResultListController.getSubject() != null;
    }

    public boolean canVerify() {
        return !this.working && this.model.canVerify();
    }

    public void verify() {
        if (!this.canVerify()) {
            return;
        }
        this.explorerResultListController.setSubject(null);
        this.working = true;
        this.log("[Explore, started at " + this.format.format(new Date()) + "]\n");
        this.model.verify(this.obpController, (ActionMonitor)new ActionMonitor.Stub(){

            public void done() {
                OBP.this.explorerResultListController.setSubject(OBP.this.model.getResults());
                OBP.this.log("[Explore, ended at " + OBP.this.format.format(new Date()) + "]\n");
                OBP.this.working = false;
                OBP.this.display.asyncExec(OBP.this.refreshRunnable);
            }

            public void canceled() {
                OBP.this.explorerResultListController.setSubject(OBP.this.model.getResults());
                OBP.this.log("[Explore, ended at " + OBP.this.format.format(new Date()) + "]\n");
                OBP.this.working = false;
                OBP.this.display.asyncExec(OBP.this.refreshRunnable);
            }
        });
    }

    public void stopCurrentAction() {
        if (!this.isWorking()) {
            return;
        }
        this.obpController.interrupt();
        this.working = false;
    }

    public void showProgramSource(boolean show) {
        this.programController.showProgramSource(show);
    }

    public boolean isUseDescription() {
        return this.programController.isUseDescription();
    }

    public void setUseDescription(boolean useDescription) {
        this.programController.setUseDescription(useDescription);
    }

    public boolean isShowPogramSource() {
        return this.programController.isShowPogramSource();
    }

    public static void main(String[] args) {
        boolean forABCD = true;
        for (int i = 0; i < args.length; ++i) {
            if (!"--abcd".equals(args[i])) continue;
            forABCD = true;
        }
        new OBP(forABCD).open();
    }
}

