/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import obp.obs.Observer;
import obp.simulation.component.JGraphXObserverViewer;
import obp.simulation.component.ObserverViewer;
import obp.simulation.resource.SimulationResources;

public class ObserverDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ObserverViewer viewer;
    private Observer obpObserver;
    private JButton close;

    public ObserverDialog(Frame frame, Observer obpObserver) {
        this.obpObserver = obpObserver;
        this.setTitle(this.obpObserver.getName());
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setIconImage(SimulationResources.observerIcon.getImage());
        this.setAlwaysOnTop(false);
        this.close = new JButton("Close");
        this.close.setActionCommand("close");
        this.close.addActionListener(this);
        this.viewer = new JGraphXObserverViewer(this.obpObserver);
        this.setLayout(new BorderLayout());
        this.add(this.viewer.buildComponent());
        this.add((Component)this.close, "South");
        this.pack();
    }

    public String getObserverName() {
        return this.obpObserver.getName();
    }

    public void setState(String state) {
        this.viewer.updateComponent(state);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().matches("close")) {
            this.setVisible(false);
        }
    }
}

