/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.util;

public class NameUtil {
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
    private static final String[] OBP_RESERVED_CAP = new String[]{"Behavior", "ProcessBehavior", "Configuration", "BehaviorConfiguration", "String", "Boolean", "Integer", "Long", "Float", "Double"};
    private static final String[] OBP_RESERVED_UNCAP = new String[]{"name", "id", "state"};

    public static String capName(String name) {
        char first = Character.toUpperCase(name.charAt(0));
        boolean correct = Character.isJavaIdentifierStart(first);
        name = (correct ? "" : "_") + first + name.substring(1);
        while (NameUtil.contains(name, OBP_RESERVED_CAP)) {
            name = name + "_";
        }
        return name;
    }

    public static String uncapName(String name) {
        char first = Character.toLowerCase(name.charAt(0));
        boolean correct = Character.isJavaIdentifierStart(first);
        name = (correct ? "" : "_") + first + name.substring(1);
        while (NameUtil.contains(name, JAVA_KEYWORDS)) {
            name = name + "_";
        }
        while (NameUtil.contains(name, OBP_RESERVED_UNCAP)) {
            name = name + "_";
        }
        return name;
    }

    public static String lowercaseName(String name) {
        if (!Character.isJavaIdentifierStart((name = name.toLowerCase()).charAt(0))) {
            name = "_" + name;
        }
        while (NameUtil.contains(name, JAVA_KEYWORDS)) {
            name = name + "_";
        }
        while (NameUtil.contains(name, OBP_RESERVED_UNCAP)) {
            name = name + "_";
        }
        return name;
    }

    private static boolean contains(String name, String[] array) {
        for (String string : array) {
            if (!string.equals(name)) continue;
            return true;
        }
        return false;
    }
}

