/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.fiacre;

import java.util.Arrays;
import java.util.List;
import obp.explorer.runtime.obs.ASynchronousCommunicationAction;
import obp.explorer.runtime.obs.AtomicAction;

public class FiacreQueueUtil {
    public static <T> T first(T[] queue) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (first of empty queue).");
        }
        return queue[queue.length - 1];
    }

    public static <T> T[] enqueue(short id, T[] queue, T value, List<AtomicAction> actions2) {
        actions2.add(new ASynchronousCommunicationAction(2, id, value));
        T[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        for (int i = newQueue.length - 2; i >= 0; --i) {
            newQueue[i + 1] = newQueue[i];
        }
        newQueue[0] = value;
        return newQueue;
    }

    public static <T> T[] enqueue(T[] queue, T value) {
        T[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        for (int i = newQueue.length - 2; i >= 0; --i) {
            newQueue[i + 1] = newQueue[i];
        }
        newQueue[0] = value;
        return newQueue;
    }

    public static <T> T[] append(T[] queue, T value) {
        T[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        newQueue[queue.length] = value;
        return newQueue;
    }

    public static <T> T[] dequeue(short id, T[] queue, List<AtomicAction> actions2) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (dequeue of empty queue).");
        }
        actions2.add(new ASynchronousCommunicationAction(1, id, queue[queue.length - 1]));
        return Arrays.copyOf(queue, queue.length - 1);
    }

    public static <T> T[] dequeue(T[] queue) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (dequeue of empty queue).");
        }
        return Arrays.copyOf(queue, queue.length - 1);
    }

    public static int first(int[] queue) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (first of empty queue).");
        }
        return queue[queue.length - 1];
    }

    public static int[] enqueue(short id, int[] queue, int value, List<AtomicAction> actions2) {
        actions2.add(new ASynchronousCommunicationAction(2, id, value));
        int[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        for (int i = newQueue.length - 2; i >= 0; --i) {
            newQueue[i + 1] = newQueue[i];
        }
        newQueue[0] = value;
        return newQueue;
    }

    public static int[] enqueue(int[] queue, int value) {
        int[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        for (int i = newQueue.length - 2; i >= 0; --i) {
            newQueue[i + 1] = newQueue[i];
        }
        newQueue[0] = value;
        return newQueue;
    }

    public static int[] append(int[] queue, int value) {
        int[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        newQueue[queue.length] = value;
        return newQueue;
    }

    public static int[] dequeue(short id, int[] queue, List<AtomicAction> actions2) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (dequeue of empty queue).");
        }
        actions2.add(new ASynchronousCommunicationAction(1, id, queue[queue.length - 1]));
        return Arrays.copyOf(queue, queue.length - 1);
    }

    public static int[] dequeue(int[] queue) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (dequeue of empty queue).");
        }
        return Arrays.copyOf(queue, queue.length - 1);
    }

    public static boolean first(boolean[] queue) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (first of empty queue).");
        }
        return queue[queue.length - 1];
    }

    public static boolean[] enqueue(short id, boolean[] queue, boolean value, List<AtomicAction> actions2) {
        actions2.add(new ASynchronousCommunicationAction(2, id, value));
        boolean[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        for (int i = newQueue.length - 2; i >= 0; --i) {
            newQueue[i + 1] = newQueue[i];
        }
        newQueue[0] = value;
        return newQueue;
    }

    public static boolean[] enqueue(boolean[] queue, boolean value) {
        boolean[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        for (int i = newQueue.length - 2; i >= 0; --i) {
            newQueue[i + 1] = newQueue[i];
        }
        newQueue[0] = value;
        return newQueue;
    }

    public static boolean[] append(boolean[] queue, boolean value) {
        boolean[] newQueue = Arrays.copyOf(queue, queue.length + 1);
        newQueue[queue.length] = value;
        return newQueue;
    }

    public static boolean[] dequeue(short id, boolean[] queue, List<AtomicAction> actions2) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (dequeue of empty queue).");
        }
        actions2.add(new ASynchronousCommunicationAction(1, id, queue[queue.length - 1]));
        return Arrays.copyOf(queue, queue.length - 1);
    }

    public static boolean[] dequeue(boolean[] queue) {
        if (queue.length == 0) {
            throw new IllegalStateException("Queue Error (dequeue of empty queue).");
        }
        return Arrays.copyOf(queue, queue.length - 1);
    }
}

