/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.model;

import java.util.Arrays;
import spinja.model.Storable;

public abstract class Channel
implements Storable {
    protected int[][] buffer;
    protected int first;
    protected int filled;
    private int[] masks;
    private boolean isRendezVous;

    public Channel(int[] nArray, int n) {
        if (n == 0) {
            this.isRendezVous = true;
            n = 1;
        } else {
            this.isRendezVous = false;
        }
        this.buffer = new int[n][];
        this.masks = nArray;
        this.filled = 0;
        this.first = 0;
    }

    public boolean canRead() {
        return this.filled > 0;
    }

    public boolean canSend() {
        return this.filled < this.buffer.length;
    }

    public boolean isEmpty() {
        return this.filled == 0;
    }

    public boolean isFull() {
        return this.filled == this.buffer.length;
    }

    @Override
    public int getSize() {
        return 0;
    }

    public boolean isRendezVous() {
        return this.isRendezVous;
    }

    public int length() {
        return this.filled;
    }

    public boolean isNotEmpty() {
        return this.filled > 0;
    }

    public boolean isNotFull() {
        return this.filled < this.buffer.length;
    }

    public int[] read() {
        int[] nArray = this.buffer[this.first];
        this.first = (this.first + 1) % this.buffer.length;
        --this.filled;
        return nArray;
    }

    public int[] readLast() {
        --this.filled;
        int[] nArray = this.buffer[(this.first + this.filled) % this.buffer.length];
        return nArray;
    }

    public int[] peek() {
        return this.buffer[this.first];
    }

    public int[] peekLast() {
        return this.buffer[(this.first + this.filled - 1) % this.buffer.length];
    }

    public void send(int ... nArray) {
        if (nArray.length != this.masks.length) {
            throw new IllegalArgumentException("Wrong nr of values put into this channel!");
        }
        if (!this.canSend()) {
            throw new IllegalStateException("Can not send into channel!");
        }
        for (int i = 0; i < this.masks.length; ++i) {
            int n = i;
            nArray[n] = nArray[n] & this.masks[i];
        }
        this.buffer[(this.first + this.filled) % this.buffer.length] = nArray;
        ++this.filled;
    }

    public void sendFirst(int ... nArray) {
        if (nArray.length != this.masks.length) {
            throw new IllegalArgumentException("Wrong nr of values put into this channel!");
        }
        if (!this.canSend()) {
            throw new IllegalStateException("Can not send into channel!");
        }
        for (int i = 0; i < this.masks.length; ++i) {
            int n = i;
            nArray[n] = nArray[n] & this.masks[i];
        }
        --this.first;
        if (this.first < 0) {
            this.first = this.buffer.length - 1;
        }
        ++this.filled;
        this.buffer[this.first] = nArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("filled: ").append(this.filled).append('\t');
        for (int i = 0; i < this.filled; ++i) {
            stringBuilder.append(Arrays.toString(this.buffer[i])).append(',');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }
}

