/*
 * Decompiled with CFR 0.152.
 */
package plug.folding.runtime;

import announce4j.Announcer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import plug.core.IProductAutomaton;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionController;
import plug.core.execution.IExecutionMonitor;
import plug.events.OpenConfigurationEvent;
import plug.folding.runtime.PreinitializedRuntime;
import plug.folding.runtime.PruningRuntime;

public class FoldingExecutionController<C, A>
implements IExecutionController<C, A> {
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    ITransitionRelation<C, A> baseRuntime;
    Function<ITransitionRelation<C, A>, IExecutionController<C, A>> controllerSupplier;
    IExecutionController<C, A> currentExecutionControler;
    Predicate<C> foldingPredicate;
    Set<C> foldingOutputs;

    public FoldingExecutionController(C configuration, ITransitionRelation<C, A> baseRuntime, Predicate<C> foldingPredicate, Function<ITransitionRelation<C, A>, IExecutionController<C, A>> controllerSupplier) {
        this.baseRuntime = baseRuntime;
        this.foldingPredicate = foldingPredicate;
        PreinitializedRuntime<C, A> initializedRuntime = new PreinitializedRuntime<C, A>(baseRuntime, Collections.singleton(configuration));
        PruningRuntime<C, A> prunningRuntime = new PruningRuntime<C, A>(initializedRuntime, foldingPredicate.negate());
        this.currentExecutionControler = controllerSupplier.apply(prunningRuntime);
        this.currentExecutionControler.getAnnouncer().when(OpenConfigurationEvent.class, this::addFoldingOutput);
        this.foldingOutputs = new HashSet<C>();
    }

    private void addFoldingOutput(Announcer ann, OpenConfigurationEvent<C> oce) {
        Object config = oce.getConfiguration();
        if (this.foldingPredicate.negate().test(config)) {
            this.foldingOutputs.add(config);
        }
    }

    @Override
    public void execute() {
        this.currentExecutionControler.execute();
    }

    @Override
    public Announcer getAnnouncer() {
        return this.currentExecutionControler.getAnnouncer();
    }

    @Override
    public IStateSpaceManager<C, A> getStateSpaceManager() {
        return this.currentExecutionControler.getStateSpaceManager();
    }

    @Override
    public ITransitionRelation getRuntime() {
        return this.currentExecutionControler.getRuntime();
    }

    public IProductAutomaton getProductAutomaton() {
        return null;
    }

    @Override
    public IExecutionMonitor.Simple getMonitor() {
        return this.monitor;
    }
}

