/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.symbols;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.symbols.SymbolClass;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SymbolTable {
    private final List<String> flatActiveObjectsName;
    private final Map<String, SymbolClass> symbolClasses;
    private final Map<String, String> flatMappingObjectsClasses;
    private final Map<String, SignalEvent> symbolEvents;

    public SymbolTable(Resource r) {
        List<String> _generateFlatActiveObjectsName = this.generateFlatActiveObjectsName(r);
        this.flatActiveObjectsName = _generateFlatActiveObjectsName;
        Map<String, SymbolClass> _generateSymbolClasses = this.generateSymbolClasses(r);
        this.symbolClasses = _generateSymbolClasses;
        Map<String, String> _generateFlatMappingWithObjects = this.generateFlatMappingWithObjects(r);
        this.flatMappingObjectsClasses = _generateFlatMappingWithObjects;
        Map<String, SignalEvent> _generateSymbolEvents = this.generateSymbolEvents(r);
        this.symbolEvents = _generateSymbolEvents;
    }

    private List<String> generateFlatActiveObjectsName(Resource r) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> objetsSymbols = new ArrayList<String>();
        List<ClassifierInstance> objects = UmlNavigation.getActiveObjectsList(r);
        Consumer<ClassifierInstance> _function = it -> {
            boolean _equals;
            String name = it.getName();
            int _lower = it.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                objetsSymbols.add(name);
            } else {
                int _lower_1 = it.getLower();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower_1, true);
                Consumer<Integer> _function_1 = it_1 -> objetsSymbols.add(name + "_" + it_1);
                _doubleDotLessThan.forEach(_function_1);
            }
        };
        objects.forEach(_function);
        _xblockexpression = objetsSymbols;
        return _xblockexpression;
    }

    private Map<String, SymbolClass> generateSymbolClasses(Resource r) {
        HashMap<String, SymbolClass> _xblockexpression = null;
        HashMap<String, SymbolClass> symbolClasses = new HashMap<String, SymbolClass>();
        TreeIterator _allContents = r.getAllContents();
        Iterator<Class> _filterExact = emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)_allContents, Class.class);
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            boolean _equals = _name.equals("SUS");
            return !_equals;
        };
        Iterator _filter = IteratorExtensions.filter(_filterExact, (Functions.Function1)_function);
        Procedures.Procedure1 _function_1 = it -> {
            String _name = it.getName();
            SymbolClass _symbolClass = new SymbolClass((Class)it, r);
            symbolClasses.put(_name, _symbolClass);
        };
        IteratorExtensions.forEach((Iterator)_filter, (Procedures.Procedure1)_function_1);
        _xblockexpression = symbolClasses;
        return _xblockexpression;
    }

    private Map<String, String> generateFlatMappingWithObjects(Resource r) {
        HashMap<String, String> _xblockexpression = null;
        HashMap<String, String> objetsSymbols = new HashMap<String, String>();
        List<ClassifierInstance> objects = UmlNavigation.collectClassifierInstance(r);
        Consumer<ClassifierInstance> _function = it -> {
            boolean _equals;
            String name = it.getName();
            Classifier _classifier = it.getClassifier();
            String typeName = _classifier.getName();
            int _lower = it.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                objetsSymbols.put(name, typeName);
            } else {
                int _lower_1 = it.getLower();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower_1, true);
                Consumer<Integer> _function_1 = it_1 -> objetsSymbols.put(name + "_" + it_1, typeName);
                _doubleDotLessThan.forEach(_function_1);
            }
        };
        objects.forEach(_function);
        _xblockexpression = objetsSymbols;
        return _xblockexpression;
    }

    private Map<String, SignalEvent> generateSymbolEvents(Resource r) {
        HashMap<String, SignalEvent> _xblockexpression = null;
        HashMap<String, SignalEvent> symbolEvents = new HashMap<String, SignalEvent>();
        TreeIterator _allContents = r.getAllContents();
        UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, SignalEvent.class);
        Procedures.Procedure1 _function = it -> {
            Signal _signal = it.getSignal();
            String _name = _signal.getName();
            symbolEvents.put(_name, (SignalEvent)it);
        };
        IteratorExtensions.forEach((Iterator)_filter, (Procedures.Procedure1)_function);
        _xblockexpression = symbolEvents;
        return _xblockexpression;
    }

    public List<String> getFlatActiveObjectsName() {
        return this.flatActiveObjectsName;
    }

    public Map<String, SymbolClass> getSymbolClasses() {
        return this.symbolClasses;
    }

    public Map<String, String> getFlatMapping() {
        return this.flatMappingObjectsClasses;
    }

    public Map<String, SignalEvent> getSymbolEvents() {
        return this.symbolEvents;
    }
}

