/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.metamodel;

import com.google.common.collect.Iterables;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class OffsetsTableStrategy
implements IStrategy {
    private final MetamodelTable table;
    private final Set<Map.Entry<EClassifier, Metaclass>> sortedClasses;
    private final Set<Map.Entry<EClassifier, Metaclass>> classesMI;
    private final List<String> attributesNamesMI;

    public OffsetsTableStrategy(MetamodelTable table) {
        Set _set;
        this.table = table;
        Map<EClassifier, Metaclass> _metaclasses = this.table.getMetaclasses();
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet = _metaclasses.entrySet();
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable _filter = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            Metaclass _value = (Metaclass)it.getValue();
            return _value.isHasMultipleInheritances();
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        this.classesMI = _set = IterableExtensions.toSet((Iterable)_filter_1);
        Set<Map.Entry<EClassifier, Metaclass>> _sortClasses = this.sortClasses();
        this.sortedClasses = _sortClasses;
        List<String> _computeDescriptorIndex = this.computeDescriptorIndex();
        this.attributesNamesMI = _computeDescriptorIndex;
    }

    private Set<Map.Entry<EClassifier, Metaclass>> sortClasses() {
        LinkedHashSet<Map.Entry<EClassifier, Metaclass>> _xblockexpression = null;
        LinkedHashSet<Map.Entry<EClassifier, Metaclass>> collection = new LinkedHashSet<Map.Entry<EClassifier, Metaclass>>();
        Map<EClassifier, Metaclass> _metaclasses = this.table.getMetaclasses();
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet = _metaclasses.entrySet();
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable _filter = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            Metaclass _value = (Metaclass)it.getValue();
            boolean _isHasMultipleInheritances = _value.isHasMultipleInheritances();
            return !_isHasMultipleInheritances;
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        Set classesSI = IterableExtensions.toSet((Iterable)_filter_1);
        collection.addAll(this.classesMI);
        collection.addAll(classesSI);
        _xblockexpression = collection;
        return _xblockexpression;
    }

    private List<String> computeDescriptorIndex() {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> attributesList = new ArrayList<String>();
        Consumer<Map.Entry> _function = it -> {
            Metaclass _value = (Metaclass)it.getValue();
            List<String> _allAttributesNames = this.table.getAllAttributesNames(_value);
            attributesList.addAll(_allAttributesNames);
        };
        this.classesMI.forEach(_function);
        _xblockexpression = attributesList;
        return _xblockexpression;
    }

    @Override
    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Definition of types needed to handle multiple inheritance.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"typedef enum DescriptorType DescriptorType;");
        _builder.newLine();
        _builder.append((Object)"typedef enum DescriptorIndex DescriptorIndex;");
        _builder.newLine();
        _builder.newLine();
        String _enumClassesToC = this.enumClassesToC();
        _builder.append((Object)_enumClassesToC, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _enumAttributesToC = this.enumAttributesToC();
        _builder.append((Object)_enumAttributesToC, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _descriptorsTableHeaderToC = this.descriptorsTableHeaderToC();
        _builder.append((Object)_descriptorsTableHeaderToC, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _macroAccessToC = this.macroAccessToC();
        _builder.append((Object)_macroAccessToC, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    @Override
    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        String _descriptorsTableToC = this.descriptorsTableToC();
        _builder.append((Object)_descriptorsTableToC, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String descriptorsTableHeaderToC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The number of classes that have multiple inheritance.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"#define NB_MI_CLASSES\t(");
        int _length = ((Object[])Conversions.unwrapArray(this.classesMI, Object.class)).length;
        _builder.append((Object)_length, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The global offsets table for all classes that have multiple inheritance.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"extern uint8_t * offsets_table[NB_MI_CLASSES];");
        _builder.newLine();
        return _builder.toString();
    }

    private String descriptorsTableToC() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            EClassifier _key = (EClassifier)it.getKey();
            Metaclass _value = (Metaclass)it.getValue();
            String _descriptorsTableToC = this.descriptorsTableToC((EClass)_key, _value);
            _builder_1.append((Object)_descriptorsTableToC, "");
            _builder_1.newLineIfNotEmpty();
            return _builder_1.toString();
        };
        Iterable _map = IterableExtensions.map(this.classesMI, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The global offsets table for all classes that have multiple inheritance.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"uint8_t * offsets_table[NB_MI_CLASSES] = {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"offsets_");
            EClassifier _key = (EClassifier)it.getKey();
            String _typeName = UmlSerializerExtensions.typeName((EObject)_key);
            _builder_1.append((Object)_typeName, "");
            return _builder_1.toString();
        };
        Iterable _map_1 = IterableExtensions.map(this.classesMI, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)",\n");
        _builder.append((Object)_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }

    private String descriptorsTableToC(EClass eClass, Metaclass metaclass) {
        String _xblockexpression = null;
        List<String> allAttributes = this.table.getAllAttributesNames(metaclass);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Macro to used if there is a hole.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* A white space is present in the descriptor table if the considered class has not this attribute.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"#define NO_DESC_TYPE   (0)");
        _builder.newLine();
        StringConcatenation _xifexpression = null;
        boolean _isHasMultipleInheritances = metaclass.isHasMultipleInheritances();
        if (_isHasMultipleInheritances) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"/**");
            _builder_1.newLine();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"* The table of descriptor offsets for the class ");
            String _name = eClass.getName();
            _builder_1.append((Object)_name, " ");
            _builder_1.append((Object)".");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"*/");
            _builder_1.newLine();
            _builder_1.append((Object)"uint8_t offsets_");
            String _typeName = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder_1.append((Object)_typeName, "");
            _builder_1.append((Object)"[NB_DESC_INDEX] = {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"\t");
            Functions.Function1 _function = it -> {
                String _xifexpression_1 = null;
                boolean _contains = allAttributes.contains(it);
                if (_contains) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append((Object)"offsetof(");
                    String _typeName_1 = UmlSerializerExtensions.typeName((EObject)eClass);
                    _builder_2.append((Object)_typeName_1, "");
                    _builder_2.append((Object)", ");
                    _builder_2.append(it, "");
                    _builder_2.append((Object)")");
                    _xifexpression_1 = _builder_2.toString();
                } else {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append((Object)"NO_DESC_TYPE");
                    _xifexpression_1 = _builder_3.toString();
                }
                return _xifexpression_1;
            };
            List _map = ListExtensions.map(this.attributesNamesMI, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
            _builder_1.append((Object)_join, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"};");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    @Override
    public String addFieldsTypes(Metaclass metaclass) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"DescriptorType c_type;");
        return _builder.toString();
    }

    @Override
    public String addFieldsInitializers(EObject e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)".c_type = DESC_TYPE_");
        String _typeName = UmlSerializerExtensions.typeName(e);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)",");
        return _builder.toString();
    }

    @Override
    public String addFieldsInitializers(EClass e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)".c_type = DESC_TYPE_");
        String _typeName = UmlSerializerExtensions.typeName((EObject)e);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)",");
        return _builder.toString();
    }

    private String enumClassesToC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Definition of the enum DescriptorType.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* A descriptor type is generated for each class.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"enum DescriptorType {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"DESC_TYPE_");
            EClassifier _key = (EClassifier)it.getKey();
            String _typeName = UmlSerializerExtensions.typeName((EObject)_key);
            _builder_1.append((Object)_typeName, "");
            _builder_1.append((Object)",");
            return _builder_1.toString();
        };
        Iterable _map = IterableExtensions.map(this.sortedClasses, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"NB_DESC_TYPE");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }

    private String enumAttributesToC() {
        String _xblockexpression = null;
        LinkedHashSet unusedAttributes = new LinkedHashSet();
        Functions.Function1 _function = it -> {
            Metaclass _value = (Metaclass)it.getValue();
            return this.table.getAllAttributesNames(_value);
        };
        Iterable _map = IterableExtensions.map(this.sortedClasses, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        Iterables.addAll(unusedAttributes, (Iterable)_flatten);
        unusedAttributes.removeAll(this.attributesNamesMI);
        LinkedList<String> collection = new LinkedList<String>();
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"DESC_INDEX_");
            _builder.append(it, "");
            return _builder.toString();
        };
        List _map_1 = ListExtensions.map(this.attributesNamesMI, (Functions.Function1)_function_1);
        collection.addAll(_map_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"NB_DESC_INDEX");
        collection.add(_builder.toString());
        Functions.Function1 _function_2 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"DESC_INDEX_");
            _builder_1.append(it, "");
            return _builder_1.toString();
        };
        Iterable _map_2 = IterableExtensions.map(unusedAttributes, (Functions.Function1)_function_2);
        Iterables.addAll(collection, (Iterable)_map_2);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"/**");
        _builder_1.newLine();
        _builder_1.append((Object)" ");
        _builder_1.append((Object)"* Definition of the enum DescriptorIndex.");
        _builder_1.newLine();
        _builder_1.append((Object)" ");
        _builder_1.append((Object)"* A descriptor index is generated for all attributes of classes that have multiple inheritance.");
        _builder_1.newLine();
        _builder_1.append((Object)" ");
        _builder_1.append((Object)"* All DESC_INDEX after NB_DESC_INDEX are unused for multiple inheritance access but useful for compilation");
        _builder_1.newLine();
        _builder_1.append((Object)" ");
        _builder_1.append((Object)"* because the access is compute at runtime.");
        _builder_1.newLine();
        _builder_1.append((Object)" ");
        _builder_1.append((Object)"*/");
        _builder_1.newLine();
        _builder_1.append((Object)"enum DescriptorIndex {");
        _builder_1.newLine();
        _builder_1.append((Object)"\t");
        Functions.Function1 _function_3 = it -> {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(it, "");
            return _builder_2.toString();
        };
        List _map_3 = ListExtensions.map(collection, (Functions.Function1)_function_3);
        String _join = IterableExtensions.join((Iterable)_map_3, (CharSequence)",\n");
        _builder_1.append((Object)_join, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append((Object)"};");
        _builder_1.newLine();
        _xblockexpression = _builder_1.toString();
        return _xblockexpression;
    }

    private CharSequence macroAccessToC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The C macro used to access elements of the UML model per address (var must be a pointer).");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This macro provides:");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* - a direct access in case of single inheritance");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* - an access through the descriptor table (vtable) in case of multiple inheritance.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"#define GETP(var, field) (((var)->c_type < NB_MI_CLASSES) ? \\");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"(*(__typeof__(&((var)->field))) ((void*)((var)) + offsets_table[(var)->c_type][DESC_INDEX_##field])) : ((var)->field))");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The C macro used to access elements of the UML model per value (var must be a value).");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This macro provides:");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* - a direct access in case of single inheritance");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* - an access through the descriptor table (vtable) in case of multiple inheritance.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"#define GETV(var, field) (((var).c_type < NB_MI_CLASSES) ? \\");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"(*(__typeof__(&((var).field))) ((void*)(&(var)) + offsets_table[(var).c_type][DESC_INDEX_##field])) : ((var).field))");
        _builder.newLine();
        return _builder;
    }
}

