/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SignalEvents {
    private final List<SignalEvent> signalEvents;
    private final Map<Signal, SignalEvent> mappingWithSignals;

    public SignalEvents(Resource r) {
        List<SignalEvent> _signalEvents = UmlNavigation.getSignalEvents(r);
        this.signalEvents = _signalEvents;
        LinkedHashMap<Signal, SignalEvent> _linkedHashMap = new LinkedHashMap<Signal, SignalEvent>();
        this.mappingWithSignals = _linkedHashMap;
        Consumer<SignalEvent> _function = it -> {
            Signal _signal = it.getSignal();
            this.mappingWithSignals.put(_signal, (SignalEvent)it);
        };
        this.signalEvents.forEach(_function);
    }

    private String fieldTypeToC(SignalEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"UML_SignalEvent * ");
        Signal _signal = e.getSignal();
        String _name = _signal.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String fieldToC(SignalEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)".");
        Signal _signal = e.getSignal();
        String _name = _signal.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" = &");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName, "");
        return _builder.toString();
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Typedef for signal events.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"typedef struct SignalEvents SignalEvents;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The SignalEvents type used to gather all signal events.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"struct SignalEvents {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Set<Map.Entry<Signal, SignalEvent>> _entrySet = this.mappingWithSignals.entrySet();
        Functions.Function1 _function = it -> {
            SignalEvent _value = (SignalEvent)it.getValue();
            return this.fieldTypeToC(_value);
        };
        Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"extern SignalEvents globalSignalEvents;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Struct initializer for signal events.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"SignalEvents globalSignalEvents = {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Set<Map.Entry<Signal, SignalEvent>> _entrySet = this.mappingWithSignals.entrySet();
        Functions.Function1 _function = it -> {
            SignalEvent _value = (SignalEvent)it.getValue();
            return this.fieldToC(_value);
        };
        Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }
}

