/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.identifiers;

import emi.serializer.identifiers.SignalEventsID;
import emi.serializer.identifiers.StatesID;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.GlobalClassifierInstance;
import emi.serializer.utils.UmlNavigation;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class IdentifiersSerializer {
    private final StatesID statesId;
    private final SignalEventsID signalEventsId;
    private final List<ClassifierInstance> globalClassifierInstances;

    public IdentifiersSerializer(Resource r) {
        List _list;
        SignalEventsID _signalEventsID;
        StatesID _statesID;
        this.statesId = _statesID = new StatesID(r);
        this.signalEventsId = _signalEventsID = new SignalEventsID(r);
        List<ClassifierInstance> _collectClassifierInstance = UmlNavigation.collectClassifierInstance(r);
        Functions.Function1 _function = it -> it instanceof GlobalClassifierInstance;
        Iterable _filter = IterableExtensions.filter(_collectClassifierInstance, (Functions.Function1)_function);
        this.globalClassifierInstances = _list = IterableExtensions.toList((Iterable)_filter);
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#ifndef MODELS_IDENTIFIERS_H");
        _builder.newLine();
        _builder.append((Object)"#define MODELS_IDENTIFIERS_H");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @file identifiers.h");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Define identifiers for states and signal events of the UML model.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Do not modify manually.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"types_calibration.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/active_object.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/passive_object.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// Serialize root access to composite structure classes");
        _builder.newLine();
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            String _name = _classifier.getName();
            boolean _equals = "OBS".equals(_name);
            return !_equals;
        };
        Iterable _filter = IterableExtensions.filter(this.globalClassifierInstances, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> ((GlobalClassifierInstance)it).serializeRootAccess();
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> {
            Classifier _classifier = it.getClassifier();
            String _name = _classifier.getName();
            return "OBS".equals(_name);
        };
        Iterable _filter_1 = IterableExtensions.filter(this.globalClassifierInstances, (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = it -> ((GlobalClassifierInstance)it).serializeRootAccess();
        Iterable _map_1 = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function_3);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.newLine();
        String _serialize = this.statesId.serialize();
        _builder.append((Object)_serialize, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serialize_1 = this.signalEventsId.serialize();
        _builder.append((Object)_serialize_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#endif /* MODELS_IDENTIFIERS_H */");
        _builder.newLine();
        return _builder.toString();
    }
}

