/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.translator;

import emi.analysis.server.translator.Translator;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaECTreeGeneratorPahole
implements Translator.IMetaECTreeGenerator {
    private static final String PAHOLE_FILE = "interpreter.pahole";
    private File paholeFile;
    private String paholeString;

    public MetaECTreeGeneratorPahole(String searchDir) throws IOException {
        String paholeFileName = searchDir + "/" + PAHOLE_FILE;
        this.paholeFile = new File(paholeFileName);
        if (!this.paholeFile.exists() || !this.paholeFile.isFile()) {
            throw new IOException("Pahole (Meta EC Tree Generator): " + paholeFileName + " is not a valid file");
        }
        this.collectPaholeInformations();
        if (this.matchStructure("Store") == null) {
            throw new IOException("Pahole (Meta EC Tree Generator): " + paholeFileName + " is not a valid pahole file");
        }
    }

    private void collectPaholeInformations() throws IOException {
        byte[] buffer = new byte[(int)this.paholeFile.length()];
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.paholeFile)));){
            stream.readFully(buffer);
        }
        this.paholeString = new String(buffer);
        if (this.paholeString.length() == 0) {
            throw new IOException("Pahole (Meta EC Tree Generator): " + this.paholeFile.getName() + " is an empty file");
        }
    }

    @Override
    public void generateMetaECTree(Translator.MetaECTreeItem treeRoot) throws IOException {
        List<Translator.MetaECTreeItem> items = this.collectItems(treeRoot.getType(), treeRoot.getOffset());
        for (Translator.MetaECTreeItem item : items) {
            String typeName = item.getType();
            if (item.getNbElements() == 1) {
                if (!(Translator.isPrimitiveType(typeName) || Translator.isUMLType(typeName) || Translator.isUnion(typeName))) {
                    this.generateMetaECTree(item);
                }
            } else {
                this.generateMetaECTreeFromItemArray(item);
            }
            treeRoot.getChildren().add(item);
        }
    }

    private void generateMetaECTreeFromItemArray(Translator.MetaECTreeItem itemArray) throws IOException {
        ArrayList<Translator.MetaECTreeItem> children = new ArrayList<Translator.MetaECTreeItem>();
        int sizeElement = itemArray.getSize() / itemArray.getNbElements();
        int offset = itemArray.getOffset();
        for (int i = 0; i < itemArray.getNbElements(); ++i) {
            Translator.MetaECTreeItem item = new Translator.MetaECTreeItem(itemArray.getType(), Translator.createArrayItemName(itemArray.getName(), i), 1, offset + i * sizeElement, sizeElement, null);
            children.add(item);
            if (Translator.isPrimitiveType(itemArray.getType()) || Translator.isUMLType(itemArray.getType()) || Translator.isUnion(itemArray.getType())) continue;
            this.generateMetaECTree(item);
        }
        itemArray.getChildren().addAll(children);
    }

    private List<Translator.MetaECTreeItem> collectItems(String nodeTypeName, int globalOffset) throws IOException {
        ArrayList<Translator.MetaECTreeItem> result = new ArrayList<Translator.MetaECTreeItem>();
        String paholeStructString = this.matchStructure(nodeTypeName);
        int structSize = this.matchStructureSize(nodeTypeName, paholeStructString);
        result.addAll(this.matchStructureFields(paholeStructString, globalOffset, structSize));
        result.addAll(this.matchUnion(paholeStructString, globalOffset));
        return result;
    }

    private String matchStructure(String structName) throws IOException {
        Matcher matcher = Pattern.compile("struct " + structName + " \\{(?:.|\n[^}])*\n\\};\n").matcher(this.paholeString);
        if (!matcher.find()) {
            throw new IOException("Pahole (Meta EC Tree Generator): " + this.paholeFile.getName() + " does not provide the needed " + structName + " structure");
        }
        return matcher.group(0);
    }

    private int matchStructureSize(String structName, String paholeStructString) throws IOException {
        String pattern = "[/][*] size: (([\\p{Digit}]+)), cachelines: ([\\p{Digit}]+), members: ([\\p{Digit}]+) [*][/]";
        Matcher matcher = Pattern.compile("[/][*] size: (([\\p{Digit}]+)), cachelines: ([\\p{Digit}]+), members: ([\\p{Digit}]+) [*][/]").matcher(paholeStructString);
        if (!matcher.find()) {
            throw new IOException("Pahole (Meta EC Tree Generator): " + this.paholeFile.getName() + " does not provide the needed " + structName + " structure size");
        }
        return Integer.parseInt(matcher.group(1));
    }

    private List<Translator.MetaECTreeItem> matchStructureFields(String paholeStructString, int globalOffset, int structSize) throws IOException {
        ArrayList<Translator.MetaECTreeItem> result = new ArrayList<Translator.MetaECTreeItem>();
        String typeNamePattern = "([\\p{Alpha}][\\p{Alnum}_]*(?:[ ][\\p{Alnum}_]+)?(?:[\\p{Space}][*])*)";
        String namePattern = "([\\p{Alpha}][\\p{Alnum}_]*)(?:\\[([\\p{Digit}]+)\\])?";
        String offsetPattern = "([\\p{Digit}]+)";
        String sizePattern = "([\\p{Digit}]+)";
        String paddingPattern = "(?:\n\n\t[/][*] XXX (?:([\\p{Digit}]+)) bytes hole, try to pack [*][/])?";
        boolean typeNameIndex = true;
        int nameIndex = 2;
        int arraySizeIndex = 3;
        int offsetIndex = 4;
        int sizeIndex = 5;
        int paddingIndex = 6;
        Matcher matcher = Pattern.compile("\t([\\p{Alpha}][\\p{Alnum}_]*(?:[ ][\\p{Alnum}_]+)?(?:[\\p{Space}][*])*)[\\p{Space}]+([\\p{Alpha}][\\p{Alnum}_]*)(?:\\[([\\p{Digit}]+)\\])?;[\\p{Space}]+[/][*][\\p{Space}]+([\\p{Digit}]+)[\\p{Space}]+([\\p{Digit}]+)[\\p{Space}]+[*][/](?:\n\n\t[/][*] XXX (?:([\\p{Digit}]+)) bytes hole, try to pack [*][/])?").matcher(paholeStructString);
        while (matcher.find()) {
            String typeName = matcher.group(1);
            String name = matcher.group(2);
            int relativeOffset = Integer.parseInt(matcher.group(4));
            int offset = globalOffset + relativeOffset;
            int size = Integer.parseInt(matcher.group(5));
            String padding = matcher.group(6);
            int nbElements = this.computeNbElements(matcher.group(3));
            Translator.MetaECTreeItem item = new Translator.MetaECTreeItem(typeName, name, nbElements, offset, size, null);
            this.fixPaholeClangBug(item, structSize, padding, relativeOffset);
            result.add(item);
        }
        return result;
    }

    private int computeNbElements(String arraySize) {
        if (arraySize != null) {
            return Integer.parseInt(arraySize);
        }
        return 1;
    }

    private void fixPaholeClangBug(Translator.MetaECTreeItem item, int structSize, String padding, int relativeOffset) throws IOException {
        if (item.getNbElements() == 0) {
            if (item.getSize() == 0) {
                if (padding != null) {
                    item.setSize(Integer.parseInt(padding));
                } else {
                    item.setSize(structSize - relativeOffset);
                }
            }
            if (item.getSize() > 0) {
                String psString = this.matchStructure(item.getType());
                int sSize = this.matchStructureSize(item.getName(), psString);
                item.setNbElements(item.getSize() / sSize);
            }
        }
    }

    private List<Translator.MetaECTreeItem> matchUnion(String paholeStructString, int globalOffset) throws IOException {
        ArrayList<Translator.MetaECTreeItem> result = new ArrayList<Translator.MetaECTreeItem>();
        String typeNamePattern = "([\\p{Alpha}][\\p{Alnum}_]*(?:[ ][\\p{Alnum}_]+)?(?:[\\p{Space}][*])*)";
        String namePattern = "([\\p{Alpha}][\\p{Alnum}_]*)(?:\\[([\\p{Digit}]+)\\])?";
        String offsetPattern = "([\\p{Digit}]+)";
        String sizePattern = "([\\p{Digit}]+)";
        boolean unionOffsetIndex = true;
        int unionSizeIndex = 2;
        Matcher matcherUnion = Pattern.compile("union \\{(?:.|\n\t[^}])*\n\t};[\\p{Space}]+[/][*][\\p{Space}]+([\\p{Digit}]+)[\\p{Space}]+([\\p{Digit}]+)[\\p{Space}]+[*][/]").matcher(paholeStructString);
        if (matcherUnion.find()) {
            ArrayList<Translator.MetaECTreeItem> children = new ArrayList<Translator.MetaECTreeItem>();
            String union = matcherUnion.group(0);
            int unionOffset = globalOffset + Integer.parseInt(matcherUnion.group(1));
            int unionSize = Integer.parseInt(matcherUnion.group(2));
            boolean typeNameIndex = true;
            int nameIndex = 2;
            int arraySizeIndex = 3;
            int sizeIndex = 4;
            Matcher matcher = Pattern.compile("\t\t([\\p{Alpha}][\\p{Alnum}_]*(?:[ ][\\p{Alnum}_]+)?(?:[\\p{Space}][*])*)[\\p{Space}]+([\\p{Alpha}][\\p{Alnum}_]*)(?:\\[([\\p{Digit}]+)\\])?;[\\p{Space}]+[/][*][\\p{Space}]+([\\p{Digit}]+)[\\p{Space}]+[*][/]").matcher(union);
            while (matcher.find()) {
                String typeName = matcher.group(1);
                String name = matcher.group(2);
                int size = Integer.parseInt(matcher.group(4));
                int nbElements = this.computeNbElements(matcher.group(3));
                Translator.MetaECTreeItem item = new Translator.MetaECTreeItem(typeName, name, nbElements, unionOffset, size, null);
                children.add(item);
                this.generateMetaECTree(item);
            }
            Translator.MetaECTreeItem unionItem = new Translator.MetaECTreeItem("union", "union", 1, unionOffset, unionSize, children);
            result.add(unionItem);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.paholeString = null;
    }
}

