/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.IStateSpaceManager;
import plug.core.execution.IExecutionViewContext;
import plug.core.fx.ConfigurationTreeView;
import plug.core.fx.FiredTransitionListView;
import plug.statespace.IGraphAccess;
import plug.utils.graph.IGraph;
import plug.utils.graph.algorithms.DijkstraShortestPath;

public class TracePane
extends SplitPane {
    protected final IExecutionViewContext context;
    protected final FiredTransitionListView firedTransitionListView;
    protected final ConfigurationTreeView previousConfigurationView;
    protected final ConfigurationTreeView nextConfigurationView;
    protected final ObjectProperty<ObservableList<IFiredTransition<IConfiguration, Object>>> trace = new SimpleObjectProperty((Object)FXCollections.observableArrayList());

    public TracePane(IExecutionViewContext context) {
        this.context = context;
        this.firedTransitionListView = new FiredTransitionListView(context);
        this.firedTransitionListView.itemsProperty().bind(this.trace);
        this.firedTransitionListView.showActionDescriptionProperty().set(true);
        this.firedTransitionListView.setHideSourceConfigurations(true);
        this.firedTransitionListView.setHideTargetConfigurations(true);
        this.previousConfigurationView = new ConfigurationTreeView(context);
        VBox previous = new VBox(new Node[]{new Label("Previous"), this.previousConfigurationView});
        VBox.setVgrow((Node)this.previousConfigurationView, (Priority)Priority.ALWAYS);
        this.nextConfigurationView = new ConfigurationTreeView(context);
        VBox next = new VBox(new Node[]{new Label("Next"), this.nextConfigurationView});
        VBox.setVgrow((Node)this.nextConfigurationView, (Priority)Priority.ALWAYS);
        this.firedTransitionListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            IConfiguration source = newValue != null ? (IConfiguration)newValue.getSource() : null;
            IConfiguration target = newValue != null ? (IConfiguration)newValue.getTarget(0) : null;
            this.previousConfigurationView.setOther(target);
            this.previousConfigurationView.setConfiguration(source);
            this.nextConfigurationView.setOther(source);
            this.nextConfigurationView.setConfiguration(target);
        });
        this.getItems().add((Object)previous);
        this.getItems().add((Object)this.firedTransitionListView);
        this.getItems().add((Object)next);
        this.setDividerPosition(0, 0.25);
        this.setDividerPosition(1, 0.75);
    }

    public ObjectProperty<ObservableList<IFiredTransition<IConfiguration, Object>>> traceProperty() {
        return this.trace;
    }

    public ObservableList<IFiredTransition<IConfiguration, Object>> getTrace() {
        return (ObservableList)this.trace.get();
    }

    public void setTrace(ObservableList<IFiredTransition<IConfiguration, Object>> newTrace) {
        this.trace.set(newTrace);
    }

    public void setTraceFromConfigurations(List<IConfiguration> configurations) {
        ObservableList transitions = (ObservableList)this.trace.get();
        transitions.clear();
        if (configurations != null) {
            for (int i = 0; i < configurations.size() - 1; ++i) {
                transitions.add((Object)this.context.getRuntime().firedTransitionForSourceToTarget((Object)configurations.get(i), (Object)configurations.get(i + 1)));
            }
        }
    }

    public void setTraceForSpecifiedTarget(IConfiguration configuration) {
        ((ObservableList)this.trace.get()).clear();
        if (configuration != null) {
            DijkstraShortestPath shortestPath = new DijkstraShortestPath();
            IStateSpaceManager spaceManager = this.context.getController().getStateSpaceManager();
            IConfiguration initial = (IConfiguration)spaceManager.initialConfigurations().iterator().next();
            IGraphAccess graph = spaceManager.getGraphView();
            List path = shortestPath.getShortestPath((IGraph)graph, (Object)initial, (Object)configuration);
            block0: for (int i = 0; i < path.size() - 1; ++i) {
                for (IFiredTransition transition : graph.getOutgoingEdges(path.get(i))) {
                    if (!transition.getTargets().contains(path.get(i + 1))) continue;
                    ((ObservableList)this.trace.get()).add((Object)transition);
                    continue block0;
                }
            }
        }
    }
}

