/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.interpreter;

import emi.analysis.client.com.TCPClient;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.server.EMIServer;
import emi.analysis.server.com.Forwarder;
import emi.analysis.server.log.Log;
import java.io.IOException;

public final class ProxyInterpreter
extends TCPClient {
    private EMIServer server;
    private Dispatcher dispatcher;

    public ProxyInterpreter(String address, int port) throws IOException {
        try {
            this.connect(address, port);
            this.dispatcher = new Dispatcher(this);
            this.dispatcher.start();
        }
        catch (IOException e) {
            throw new IOException("Proxy interpreter exception: " + e.getMessage());
        }
    }

    public void recordServer(EMIServer server) {
        this.server = server;
    }

    public void removeServer(EMIServer server) {
        this.server = null;
    }

    @Override
    public void close() {
        try {
            this.dispatcher.stopRunning();
            super.close();
        }
        catch (IOException e) {
            Log.e("Proxy interpreter exception: " + e.getMessage());
        }
    }

    private static class Dispatcher
    extends Thread {
        private boolean isRunning;
        private ProxyInterpreter interpreter;

        Dispatcher(ProxyInterpreter interpreter) {
            this.interpreter = interpreter;
            this.isRunning = false;
        }

        @Override
        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    EMIProtocol.Header header = EMIProtocol.readHeader(this.interpreter.getConnection());
                    if (this.interpreter.server != null) {
                        if (this.interpreter.server.hasLogServices()) {
                            Log.d("Interpreter forwarding: kind = " + header.kind + ", size = " + header.size);
                        }
                        Forwarder.forward(this.interpreter.getConnection(), this.interpreter.server.getClientConnection(), header);
                        continue;
                    }
                    throw new IOException("no forwarding (no server available)");
                }
                catch (IOException e) {
                    Log.i("Interpreter dispatch stop: " + e.getMessage());
                    this.isRunning = false;
                    if (this.interpreter.server == null) continue;
                    this.interpreter.server.onInterpreterDisconnect();
                }
            }
        }

        private void stopRunning() {
            this.isRunning = false;
        }
    }
}

