/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.atom;

import emi.analysis.com.IConnection;
import emi.analysis.model.EMIAtom;
import emi.analysis.model.EMIModel;
import emi.analysis.server.atom.AtomBank;
import emi.analysis.server.atom.AtomManagementException;
import emi.serializer.actionlanguage.AtomSerializer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public final class AtomManager {
    public static final String DEFAULT_MAKE_TOOL = "make";
    private static final String DEFAULT_COMPILER = "";
    private static final String COMPILATION_LOG_DIR = "atoms/log/";
    private boolean log;
    private AtomBank atomBank;
    private AtomSerializer atomSerializer;
    private String atomsSerializationDir;
    private String atomsCompilationLogDir;
    private String emiHome;
    private String target;
    private String compiler;
    private String makeTool = "make";

    public boolean hasLog() {
        return this.log;
    }

    public AtomManager(IConnection interpreterConnection, String emiHome, String emiModel, String target, String compiler, String makeTool, boolean log) throws IOException {
        this.emiHome = emiHome;
        this.log = log;
        this.atomBank = new AtomBank(interpreterConnection, log);
        this.atomSerializer = new AtomSerializer();
        this.init(emiModel, target, compiler, makeTool);
    }

    private void init(String emiModel, String target, String compiler, String makeTool) throws IOException {
        this.target = target != null ? target : "host";
        this.compiler = compiler != null ? compiler : DEFAULT_COMPILER;
        this.makeTool = makeTool != null ? makeTool : DEFAULT_MAKE_TOOL;
        this.atomsSerializationDir = emiModel + "/" + "atoms/";
        this.checkAtomsSerializationDir(emiModel);
        this.atomsCompilationLogDir = emiModel + "/" + COMPILATION_LOG_DIR;
        this.checkAtomsCompilationLogDir(emiModel);
        this.atomBank.init(emiModel, this.target, this.atomsSerializationDir);
        try {
            this.atomSerializer.init(emiModel, EMIModel.deduceModelName(emiModel), this.target);
        }
        catch (IOException e) {
            throw new IOException("Atom Manager: " + e.getMessage());
        }
    }

    private void checkAtomsSerializationDir(String emiModel) throws IOException {
        File atomsSerializationDirFile = new File(this.atomsSerializationDir);
        if (!atomsSerializationDirFile.exists() || !atomsSerializationDirFile.isDirectory()) {
            throw new IOException("Atom manager: " + emiModel + " is not a valid EMI model (" + this.atomsSerializationDir + " does not exist)");
        }
        File serializedAtomsGenFile = new File(this.atomsSerializationDir + "gen/");
        if (!(serializedAtomsGenFile.exists() && serializedAtomsGenFile.isDirectory() || serializedAtomsGenFile.mkdir())) {
            throw new IOException("Atom manager: " + emiModel + " is not a valid EMI model (" + serializedAtomsGenFile.getAbsolutePath() + " directory can not be created)");
        }
    }

    private void checkAtomsCompilationLogDir(String emiModel) throws IOException {
        File atomsCompilationLogDirFile = new File(this.atomsCompilationLogDir);
        if (!(atomsCompilationLogDirFile.exists() && atomsCompilationLogDirFile.isDirectory() || atomsCompilationLogDirFile.mkdir())) {
            throw new IOException("Atom manager: " + emiModel + " is not a valid EMI model (" + this.atomsCompilationLogDir + " directory can not be created)");
        }
    }

    public void evaluate(ArrayList<EMIAtom> atoms) throws AtomManagementException {
        if (atoms.size() > this.atomBank.getInterpreterAtomsBankMax()) {
            throw new AtomManagementException("too many atoms to evaluate (limit: " + this.atomBank.getInterpreterAtomsBankMax() + ")");
        }
        try {
            this.atomBank.prepareEvaluation();
            for (EMIAtom atom : atoms) {
                if (this.atomBank.registerEvaluation(atom)) continue;
                this.serialize(atom);
                this.compile(atom);
                this.atomBank.registerFirstEvaluation(atom);
            }
            this.atomBank.evaluate();
        }
        catch (IOException e) {
            throw new AtomManagementException("evaluation exception (" + e.getMessage() + ")");
        }
    }

    private void serialize(EMIAtom atom) {
        this.atomSerializer.serialize(atom.getStringCode(), atom.getIdHexa());
    }

    private void compile(EMIAtom atom) throws AtomManagementException {
        String[] args = new String[]{this.makeTool, "--directory=" + this.atomsSerializationDir, "all", "EMI_HOME=" + this.emiHome, "ATOM=atom_" + atom.getIdHexa(), "TARGET=" + this.target, "COMPILER=" + this.compiler};
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            File log = new File(this.atomsCompilationLogDir + "atom_" + atom.getIdHexa());
            if (log.exists()) {
                new RandomAccessFile(log, "rw").setLength(0L);
            }
            processBuilder.redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.appendTo(log));
            if (processBuilder.start().waitFor() != 0) {
                String message = "compilation error on atom " + atom.getIdHexa() + " (see: " + this.atomsCompilationLogDir + "atom_" + atom.getIdHexa() + ")";
                throw new AtomManagementException(message);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new AtomManagementException(e.getMessage());
        }
    }

    public int getAtomsBankMax() {
        return this.atomBank.getInterpreterAtomsBankMax();
    }

    public int getAtomsSizeMax() {
        return this.atomBank.getInterpreterAtomsSizeMax();
    }
}

