/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.client.com;

import emi.analysis.com.IConnection;
import emi.analysis.com.TCPConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class TCPClient {
    private static final int CONNECTION_TIMEOUT = 3000;
    private String address;
    private int port;
    private IConnection connection;

    public IConnection getConnection() {
        return this.connection;
    }

    public void connect(String address, int port) throws IOException {
        this.address = address;
        this.port = port;
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.address, this.port), 3000);
            socket.setTcpNoDelay(true);
            this.connection = new TCPConnection(socket);
        }
        catch (IOException e) {
            throw new IOException("Can't connect by TCP to the server @" + this.address + ":" + this.port + ", " + e.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            throw new IOException("Can't close the TCP connection (" + e.getMessage() + ")");
        }
    }
}

