/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import com.google.common.base.Objects;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Transitions {
    private final List<Class> activeClasses;
    private final List<ClassifierInstance> activeObjectsOBS;
    private final List<ClassifierInstance> activeObjectsSUS;

    public Transitions(Resource r) {
        List<Class> _activeClasses = UmlNavigation.getActiveClasses(r);
        this.activeClasses = _activeClasses;
        List<ClassifierInstance> _activeObjectsListOfComposite = UmlNavigation.getActiveObjectsListOfComposite(r, "OBS");
        this.activeObjectsOBS = _activeObjectsListOfComposite;
        List<ClassifierInstance> _activeObjectsListOfComposite_1 = UmlNavigation.getActiveObjectsListOfComposite(r, "SUS");
        this.activeObjectsSUS = _activeObjectsListOfComposite_1;
    }

    public static boolean canPropagateEvaluation(Vertex v) {
        return !(v instanceof State) && (!(v instanceof Pseudostate) || !Objects.equal((Object)((Pseudostate)v).getKind(), (Object)PseudostateKind.CHOICE_LITERAL));
    }

    public static int getMaxTransitionLength(StateMachine sm) {
        Integer _xblockexpression = null;
        ArrayList list = new ArrayList();
        List<Vertex> _allVertices = UmlNavigation.getAllVertices(sm);
        Functions.Function1 _function = it -> {
            boolean _canPropagateEvaluation = Transitions.canPropagateEvaluation(it);
            return !_canPropagateEvaluation;
        };
        Iterable _filter = IterableExtensions.filter(_allVertices, (Functions.Function1)_function);
        Consumer<Vertex> _function_1 = it -> {
            EList _outgoings = it.getOutgoings();
            Consumer<Transition> _function_2 = it_1 -> {
                List<List<Transition>> _transitions = Transitions.getTransitions(it_1);
                Functions.Function1 _function_3 = it_2 -> ((Object[])Conversions.unwrapArray((Object)it_2, Object.class)).length;
                List _map = ListExtensions.map(_transitions, (Functions.Function1)_function_3);
                Integer _max = (Integer)IterableExtensions.max((Iterable)_map);
                list.add(_max);
            };
            _outgoings.forEach(_function_2);
        };
        _filter.forEach(_function_1);
        _xblockexpression = (Integer)IterableExtensions.max(list);
        return _xblockexpression;
    }

    public static int getMaxFireablesTransition(StateMachine sm) {
        Integer _xblockexpression = null;
        ArrayList list = new ArrayList();
        List<Vertex> _allVertices = UmlNavigation.getAllVertices(sm);
        Functions.Function1 _function = it -> {
            boolean _canPropagateEvaluation = Transitions.canPropagateEvaluation(it);
            return !_canPropagateEvaluation;
        };
        Iterable _filter = IterableExtensions.filter(_allVertices, (Functions.Function1)_function);
        Consumer<Vertex> _function_1 = it -> {
            ArrayList transitions = new ArrayList();
            EList _outgoings = it.getOutgoings();
            Consumer<Transition> _function_2 = it_1 -> {
                List<List<Transition>> _transitions = Transitions.getTransitions(it_1);
                transitions.addAll(_transitions);
            };
            _outgoings.forEach(_function_2);
            int _length = ((Object[])Conversions.unwrapArray(transitions, Object.class)).length;
            list.add(_length);
        };
        _filter.forEach(_function_1);
        _xblockexpression = (Integer)IterableExtensions.max(list);
        return _xblockexpression;
    }

    public static List<List<Transition>> getTransitions(Transition t) {
        boolean _not;
        ArrayList<List<Transition>> _xblockexpression = null;
        ArrayList<List<Transition>> list = new ArrayList<List<Transition>>();
        Vertex _target = t.getTarget();
        boolean _canPropagateEvaluation = Transitions.canPropagateEvaluation(_target);
        boolean bl = _not = !_canPropagateEvaluation;
        if (_not) {
            list.add(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Transition[]{t})));
        } else {
            Vertex _target_1 = t.getTarget();
            EList _outgoings = _target_1.getOutgoings();
            Consumer<Transition> _function = it -> {
                List<List<Transition>> _transitions = Transitions.getTransitions(it);
                Consumer<List> _function_1 = it_1 -> {
                    ArrayList<Transition> compoundTransition = new ArrayList<Transition>();
                    compoundTransition.add(t);
                    compoundTransition.addAll((Collection<Transition>)it_1);
                    list.add(compoundTransition);
                };
                _transitions.forEach(_function_1);
            };
            _outgoings.forEach(_function);
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public String serializeFireables(ClassifierInstance object) {
        boolean _equals;
        String _xblockexpression = null;
        Classifier _classifier = object.getClassifier();
        StateMachine sm = UmlNavigation.getStateMachine((Class)_classifier);
        int maxFireables = Transitions.getMaxFireablesTransition(sm);
        int fireableLength = Transitions.getMaxTransitionLength(sm);
        String _xifexpression = null;
        int _lower = object.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"static NbOutgoings_t fireables_");
            String _name = object.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"[");
            _builder.append((Object)maxFireables, "");
            _builder.append((Object)"][");
            _builder.append((Object)fireableLength, "");
            _builder.append((Object)"] = {{0}};");
            _xifexpression = _builder.toString();
        } else {
            int _lower_1 = object.getLower();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower_1, true);
            Functions.Function1 _function = it -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"static NbOutgoings_t fireables_");
                String _name_1 = object.getName();
                _builder_1.append((Object)_name_1, "");
                _builder_1.append((Object)"_");
                _builder_1.append(it, "");
                _builder_1.append((Object)"[");
                _builder_1.append((Object)maxFireables, "");
                _builder_1.append((Object)"][");
                _builder_1.append((Object)fireableLength, "");
                _builder_1.append((Object)"] = {{0}};");
                return _builder_1.toString();
            };
            Iterable _map = IterableExtensions.map((Iterable)_doubleDotLessThan, (Functions.Function1)_function);
            _xifexpression = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String serializeHeadersTypedef() {
        String _xblockexpression = null;
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            StateMachine _stateMachine = UmlNavigation.getStateMachine((Class)_classifier);
            int _maxFireablesTransition = Transitions.getMaxFireablesTransition(_stateMachine);
            int _lower = it.getLower();
            return _maxFireablesTransition * _lower;
        };
        List _map = ListExtensions.map(this.activeObjectsSUS, (Functions.Function1)_function);
        Functions.Function2 _function_1 = (p1, p2) -> p1 + p2;
        Integer nbFireableSystem = (Integer)IterableExtensions.reduce((Iterable)_map, (Functions.Function2)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The number of fireable transitions of the system.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"#define MAX_FIREABLE_SYSTEM  (");
        _builder.append((Object)nbFireableSystem, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serializeHeaders() {
        return "";
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Objects to store fireable transtions.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.serializeFireables((ClassifierInstance)it);
        List _map = ListExtensions.map(this.activeObjectsSUS, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.serializeFireables((ClassifierInstance)it);
        List _map_1 = ListExtensions.map(this.activeObjectsOBS, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        return _builder.toString();
    }
}

