/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.symbols;

import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class SymbolClass {
    private final String name;
    private final List<Property> peers;
    private final List<String> primitiveAttributes;
    private final List<Vertex> vertices;
    private final List<Transition> transitions;

    public SymbolClass(Class e, Resource r) {
        List _list_1;
        List _list;
        String _name;
        this.name = _name = e.getName();
        PropertiesRO peers = new PropertiesRO(r);
        Set<Property> _allPeers = peers.getAllPeers(e);
        this.peers = _list = IterableExtensions.toList(_allPeers);
        List<Property> _attributesNotPeers = UmlNavigation.getAttributesNotPeers((Classifier)e);
        Functions.Function1 _function = it -> it.getName();
        List _map = ListExtensions.map(_attributesNotPeers, (Functions.Function1)_function);
        this.primitiveAttributes = _list_1 = IterableExtensions.toList((Iterable)_map);
        StateMachine sm = UmlNavigation.getStateMachine(e);
        List<Vertex> _searchVertices = this.searchVertices(sm);
        this.vertices = _searchVertices;
        List<Transition> _searchTransitions = this.searchTransitions(sm);
        this.transitions = _searchTransitions;
    }

    public List<Vertex> searchVertices(StateMachine sm) {
        EList _regions;
        Region region;
        ArrayList<Vertex> _xblockexpression = null;
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        if (sm != null && (region = (Region)IterableExtensions.head((Iterable)(_regions = sm.getRegions()))) != null) {
            EList _subvertices = region.getSubvertices();
            vertices.addAll((Collection<Vertex>)_subvertices);
        }
        _xblockexpression = vertices;
        return _xblockexpression;
    }

    public List<Transition> searchTransitions(StateMachine sm) {
        EList _regions;
        Region region;
        ArrayList<Transition> _xblockexpression = null;
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        if (sm != null && (region = (Region)IterableExtensions.head((Iterable)(_regions = sm.getRegions()))) != null) {
            EList _transitions = region.getTransitions();
            transitions.addAll((Collection<Transition>)_transitions);
        }
        _xblockexpression = transitions;
        return _xblockexpression;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.peers == null ? 0 : this.peers.hashCode());
        result = 31 * result + (this.primitiveAttributes == null ? 0 : this.primitiveAttributes.hashCode());
        result = 31 * result + (this.vertices == null ? 0 : this.vertices.hashCode());
        result = 31 * result + (this.transitions == null ? 0 : this.transitions.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolClass other = (SymbolClass)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.peers == null ? other.peers != null : !this.peers.equals(other.peers)) {
            return false;
        }
        if (this.primitiveAttributes == null ? other.primitiveAttributes != null : !this.primitiveAttributes.equals(other.primitiveAttributes)) {
            return false;
        }
        if (this.vertices == null ? other.vertices != null : !this.vertices.equals(other.vertices)) {
            return false;
        }
        return !(this.transitions == null ? other.transitions != null : !this.transitions.equals(other.transitions));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.name);
        b.add("peers", this.peers);
        b.add("primitiveAttributes", this.primitiveAttributes);
        b.add("vertices", this.vertices);
        b.add("transitions", this.transitions);
        return b.toString();
    }

    @Pure
    public String getName() {
        return this.name;
    }

    @Pure
    public List<Property> getPeers() {
        return this.peers;
    }

    @Pure
    public List<String> getPrimitiveAttributes() {
        return this.primitiveAttributes;
    }

    @Pure
    public List<Vertex> getVertices() {
        return this.vertices;
    }

    @Pure
    public List<Transition> getTransitions() {
        return this.transitions;
    }
}

