/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.translator;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Pattern;

public final class EndiannessDetection {
    private static final String ENDIANNESS_FILE = "interpreter.endianness";

    private EndiannessDetection() {
    }

    public static Endianness detectEndianness(String searchDir) throws IOException {
        Endianness endianness;
        String endiannessFileName = searchDir + "/" + ENDIANNESS_FILE;
        File endiannessFile = new File(endiannessFileName);
        if (!endiannessFile.exists() || !endiannessFile.isFile()) {
            throw new IOException("Translator: " + endiannessFile + " is not a valid file");
        }
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(endiannessFile)));
        byte[] buffer = new byte[(int)endiannessFile.length()];
        try {
            stream.readFully(buffer);
        }
        catch (IOException e) {
            throw new IOException("Translator: " + e.getMessage());
        }
        finally {
            stream.close();
        }
        String endiannessString = new String(buffer);
        if (endiannessString.length() == 0) {
            throw new IOException("Translator: " + endiannessFile + " is an empty file");
        }
        if (Pattern.compile("little endian").matcher(endiannessString).find()) {
            endianness = Endianness.LITTLE_ENDIAN;
        } else if (Pattern.compile("big endian").matcher(endiannessString).find()) {
            endianness = Endianness.BIG_ENDIAN;
        } else {
            throw new IOException("Translator: " + endiannessFile + " does not provide a support endianness");
        }
        return endianness;
    }

    public static enum Endianness {
        BIG_ENDIAN("big endian"),
        LITTLE_ENDIAN("little endian");

        private String value;

        private Endianness(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

