/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server;

import emi.analysis.com.IConnection;
import emi.analysis.model.EMIConfiguration;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.protocol.EMIProtocolConfiguration;
import emi.analysis.protocol.EMIProtocolTranslation;
import emi.analysis.server.EMIServer;
import emi.analysis.server.log.Log;
import emi.analysis.server.translator.Translator;
import emi.analysis.server.translator.TranslatorException;
import java.io.IOException;

public class ServiceTranslateConfiguration
extends EMIServer.AService {
    private Translator translator;

    public ServiceTranslateConfiguration(Translator translator, boolean log) {
        super(log);
        this.translator = translator;
        if (this.translator != null) {
            Log.i("Service: translation of configurations");
        }
    }

    @Override
    public void execute(EMIProtocol.Header header, IConnection connection) throws IOException {
        EMIConfiguration configuration = EMIProtocolConfiguration.deserialize(connection.read(header.size));
        try {
            if (this.translator == null) {
                throw new TranslatorException("not available");
            }
            if (this.log || this.translator.hasLog()) {
                Log.d("Service: translate configuration (" + configuration.hashCode() + ")");
            }
            String translation = this.translator.translate(configuration);
            EMIProtocol.writeHeader(connection, new EMIProtocol.Header(101, translation.length()));
            connection.write(EMIProtocolTranslation.serialize(translation));
        }
        catch (TranslatorException e) {
            Log.e("Translation service: " + e.getMessage());
            EMIProtocol.writeHeader(connection, new EMIProtocol.Header(1));
        }
    }
}

