/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.model;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class EMIConfiguration {
    private ByteBuffer data;

    public EMIConfiguration() {
        this.data = null;
    }

    public EMIConfiguration(ByteBuffer data) {
        this.data = data;
    }

    public EMIConfiguration(byte[] data) {
        this.data = ByteBuffer.wrap(data);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getSize() {
        return this.data.capacity();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EMIConfiguration) {
            return ((EMIConfiguration)obj).getData().equals(this.data);
        }
        return false;
    }

    public EMIConfiguration createCopy() {
        return new EMIConfiguration((byte[])this.data.array().clone());
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public String toString() {
        return Arrays.toString(this.data.array());
    }

    public int countDiffBytes(EMIConfiguration configuration) {
        int count = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getData().get(i) == configuration.getData().get(i)) continue;
            ++count;
        }
        return count;
    }
}

