/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.translator;

import emi.analysis.model.EMIConfiguration;
import emi.analysis.server.translator.Translator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class TranslationBuilderJson
implements Translator.ITranslationBuilder {
    public static final String NO_TRANSITION_ID = "__NO_TRANSITION_ID__";
    public static final String INITIAL_TRANSITION_ID = "__INITIAL_TRANSITION_ID__";
    public static final String IMPLICIT_TRANSITION_ID = "__IMPLICIT_TRANSITION_ID__";
    private EMIConfiguration configuration;

    @Override
    public String translate(EMIConfiguration configuration, Translator.MetaECTreeItem treeRoot) {
        this.configuration = configuration;
        JsonObjectBuilder builder = this.generateConfigurationJson(treeRoot);
        return builder.build().toString();
    }

    private JsonObjectBuilder generateConfigurationJson(Translator.MetaECTreeItem item) {
        JsonObjectBuilder itemBuilder = Json.createObjectBuilder();
        itemBuilder.add("type", item.getType());
        itemBuilder.add("name", item.getName());
        if (item.isLeaf()) {
            itemBuilder.add("value", item.computeValue(this.configuration));
        } else {
            JsonArrayBuilder childrenBuilder = Json.createArrayBuilder();
            for (Translator.MetaECTreeItem child : item.getChildren()) {
                childrenBuilder.add(this.generateConfigurationJson(child));
            }
            itemBuilder.add("children", childrenBuilder);
        }
        return itemBuilder;
    }

    @Override
    public String translate(List<Translator.MetaEFT> transitions) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Translator.MetaEFT transition : transitions) {
            builder.add((JsonValue)this.translate(transition));
        }
        return builder.build().toString();
    }

    /*
     * WARNING - void declaration
     */
    private JsonObject translate(Translator.MetaEFT transition) {
        void var5_9;
        JsonObjectBuilder builder = Json.createObjectBuilder();
        JsonArrayBuilder transitionsBuilder = Json.createArrayBuilder();
        for (String string : transition.getTransitions()) {
            if (string != null) {
                transitionsBuilder.add(string);
                continue;
            }
            transitionsBuilder.add("");
        }
        JsonArrayBuilder verticesBuilder = Json.createArrayBuilder();
        for (String vertexName : transition.getVertices()) {
            if (vertexName != null) {
                verticesBuilder.add(vertexName);
                continue;
            }
            verticesBuilder.add("");
        }
        String string = "";
        if (transition.getActiveObject() != null) {
            String string2 = transition.getActiveObject();
        }
        String transitionIdKindJson = "";
        if (transition.getTransitionIdKind() != null) {
            transitionIdKindJson = transition.getTransitionIdKind().getStringValue();
        }
        String sourceJson = "";
        if (transition.getSource() != null) {
            sourceJson = transition.getSource();
        }
        String targetJson = "";
        if (transition.getTarget() != null) {
            targetJson = transition.getTarget();
        }
        builder.add("activeObject", (String)var5_9);
        builder.add("transitionIdKind", transitionIdKindJson);
        builder.add("transitions", transitionsBuilder);
        builder.add("vertices", verticesBuilder);
        builder.add("source", sourceJson);
        builder.add("target", targetJson);
        return builder.build();
    }
}

