/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.common.net.InetAddresses;
import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.standalone.client.EMISynchronousStandaloneClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import plug.core.ILanguageLoader;
import plug.language.emi.runtime.EMIRuntime;
import plug.language.emi.runtime.PropertyKind;
import plug.language.emi.runtime.PropertyManager;

public class EMILoader
implements ILanguageLoader<EMIRuntime> {
    private String lastChecksum = null;
    private EMISynchronousClient client = null;
    private EMIRuntime runtime = null;

    public EMIRuntime getRuntime(URI modelURI, Map<String, Object> options) {
        System.out.println("Get runtime");
        File file = new File(modelURI);
        String checksum = this.getChecksum(file);
        if (this.runtime != null && this.lastChecksum != null && this.lastChecksum.equals(checksum)) {
            System.out.println("Return same runtime");
            return this.runtime;
        }
        if (this.runtime != null) {
            System.out.println("Close runtime");
            this.runtime.close();
            this.runtime = null;
        }
        System.out.println("Load new runtime");
        PropertyManager propManager = new PropertyManager(file);
        String modelURIPath = modelURI.getPath();
        String configPath = new File(modelURIPath).getParent();
        try {
            String mode;
            switch (mode = propManager.getProperty(PropertyKind.MODE)) {
                case "remote": {
                    this.initRuntimeInRemoteMode(propManager);
                    break;
                }
                case "standalone": {
                    this.initRuntimeInStandaloneMode(propManager, configPath);
                    break;
                }
                default: {
                    throw new EMIException("Unknown mode (only \"remote\" or \"standalone\" are available)");
                }
            }
            this.lastChecksum = this.getChecksum(file);
        }
        catch (EMIException | IOException e) {
            e.printStackTrace();
        }
        propManager.close();
        return this.runtime;
    }

    private void initRuntimeInRemoteMode(PropertyManager propManager) throws EMIException {
        String address = propManager.getProperty(PropertyKind.ADDRESS);
        if (address == null) {
            address = "127.0.0.1";
        }
        String portString = propManager.getProperty(PropertyKind.PORT);
        int port = 0;
        port = portString == null ? 12346 : Integer.parseInt(portString);
        if (!"localhost".contentEquals(address) && !InetAddresses.isInetAddress((String)address)) {
            System.err.println("EMI: address=" + address + " is not an IP address");
            throw new EMIException("Invalid IP address");
        }
        this.client = new EMISynchronousClient(address, port);
        this.runtime = new EMIRuntime(this.client);
    }

    private void initRuntimeInStandaloneMode(PropertyManager propManager, String configPath) throws EMIException, IOException {
        boolean withAtomEvaluation;
        String address = propManager.getProperty(PropertyKind.ADDRESS);
        if (address == null) {
            address = "127.0.0.1";
        }
        String portString = propManager.getProperty(PropertyKind.PORT);
        int port = 0;
        port = portString == null ? 12345 : Integer.parseInt(portString);
        String emiModelString = propManager.getProperty(PropertyKind.EMI_MODEL);
        Path emiModelPath = Paths.get(emiModelString, new String[0]);
        String emiModel = null;
        if (emiModelPath.isAbsolute()) {
            emiModel = emiModelString;
        } else {
            System.out.println("configPath=" + configPath);
            emiModel = Paths.get(configPath, emiModelString).toFile().getCanonicalPath();
        }
        System.out.println("emiModel=" + emiModel);
        String emiHome = propManager.getProperty(PropertyKind.EMI_HOME);
        String target = propManager.getProperty(PropertyKind.TARGET);
        String compiler = propManager.getProperty(PropertyKind.COMPILER);
        String makeTool = propManager.getProperty(PropertyKind.MAKE_TOOL);
        String dwarfTool = propManager.getProperty(PropertyKind.DWARF_TOOL);
        String withTranslationStr = propManager.getProperty(PropertyKind.WITH_TRANSLATION);
        boolean withTranslation = !"false".equals(withTranslationStr) && !"0".equals(withTranslationStr);
        String withAtomEvaluationStr = propManager.getProperty(PropertyKind.WITH_ATOM_EVALUATION);
        boolean bl = withAtomEvaluation = !"false".equals(withAtomEvaluationStr) && !"0".equals(withAtomEvaluationStr);
        if (!"localhost".contentEquals(address) && !InetAddresses.isInetAddress((String)address)) {
            System.err.println("EMI: address=" + address + " is not an IP address");
            throw new EMIException("Invalid IP address");
        }
        this.client = withTranslation && withAtomEvaluation ? new EMISynchronousStandaloneClient(address, port, emiModel, emiHome, target, compiler, makeTool, dwarfTool) : (withTranslation ? new EMISynchronousStandaloneClient(address, port, emiModel, target, dwarfTool) : (withAtomEvaluation ? new EMISynchronousStandaloneClient(address, port, emiModel, emiHome, target, compiler, makeTool) : new EMISynchronousStandaloneClient(address, port)));
        this.runtime = new EMIRuntime(this.client);
    }

    private String getChecksum(File file) {
        String checksum = null;
        try {
            HashCode hc = Files.asByteSource((File)file).hash(Hashing.sha256());
            checksum = hc.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return checksum;
    }
}

