/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.PartClassifierInstance;
import emi.serializer.utils.UmlNavigation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PropertiesRO {
    private final List<ClassifierInstance> objects;
    private final List<ClassifierInstance> objectsSUS;
    private final List<ClassifierInstance> objectsOBS;
    private final Set<Class> classes;
    private final Set<Class> superclasses;
    private final List<Association> associations;
    private final List<Connector> connectors;

    public PropertiesRO(Resource r) {
        Set _set;
        List _list_1;
        List _list;
        List<ClassifierInstance> _collectClassifierInstance = UmlNavigation.collectClassifierInstance(r);
        this.objects = _collectClassifierInstance;
        List<ClassifierInstance> _collectClassifierInstanceWithCompositeClass = UmlNavigation.collectClassifierInstanceWithCompositeClass(r, "SUS");
        this.objectsSUS = _collectClassifierInstanceWithCompositeClass;
        List<ClassifierInstance> _collectClassifierInstanceWithCompositeClass_1 = UmlNavigation.collectClassifierInstanceWithCompositeClass(r, "OBS");
        this.objectsOBS = _collectClassifierInstanceWithCompositeClass_1;
        TreeIterator _allContents = r.getAllContents();
        UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Association.class);
        this.associations = _list = IteratorExtensions.toList((Iterator)_filter);
        TreeIterator _allContents_1 = r.getAllContents();
        UnmodifiableIterator _filter_1 = Iterators.filter((Iterator)_allContents_1, Connector.class);
        this.connectors = _list_1 = IteratorExtensions.toList((Iterator)_filter_1);
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            return _classifier.allParents();
        };
        List _map = ListExtensions.map(this.objects, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        Iterable _filter_2 = Iterables.filter((Iterable)_flatten, Class.class);
        this.superclasses = _set = IterableExtensions.toSet((Iterable)_filter_2);
        HashSet<Class> _hashSet = new HashSet<Class>();
        this.classes = _hashSet;
        this.classes.addAll(this.superclasses);
        List<Class> _classes = UmlNavigation.getClasses(r);
        this.classes.addAll(_classes);
        IterableExtensions.toSet(this.classes);
    }

    public static String getPeersTypeName(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_peers");
        return _builder.toString();
    }

    private Set<Property> getPeers(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> peers = new HashSet<Property>();
        Functions.Function1 _function = it -> {
            EList _memberEnds = it.getMemberEnds();
            Functions.Function1 _function_1 = it_1 -> {
                Type _type = it_1.getType();
                return (Class)_type;
            };
            List _map = ListExtensions.map((List)_memberEnds, (Functions.Function1)_function_1);
            List _list = IterableExtensions.toList((Iterable)_map);
            return _list.contains(e);
        };
        Iterable _filter = IterableExtensions.filter(this.associations, (Functions.Function1)_function);
        List associations = IterableExtensions.toList((Iterable)_filter);
        Functions.Function1 _function_1 = it -> it.getMemberEnds();
        List _map = ListExtensions.map((List)associations, (Functions.Function1)_function_1);
        List allMemberEnd = IterableExtensions.toList((Iterable)_map);
        Iterable _flatten = Iterables.concat((Iterable)allMemberEnd);
        Functions.Function1 _function_2 = it -> {
            Type _type = it.getType();
            boolean _equals = ((Class)_type).equals(e);
            return !_equals;
        };
        Iterable endPeers = IterableExtensions.filter((Iterable)_flatten, (Functions.Function1)_function_2);
        EList _ownedPorts = e.getOwnedPorts();
        Functions.Function1 _function_3 = it -> it.isBehavior();
        Iterable behavioralPorts = IterableExtensions.filter((Iterable)_ownedPorts, (Functions.Function1)_function_3);
        Iterables.addAll(peers, (Iterable)endPeers);
        Iterables.addAll(peers, (Iterable)behavioralPorts);
        _xblockexpression = peers;
        return _xblockexpression;
    }

    public Set<Property> getAllPeers(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> peers = new HashSet<Property>();
        Set<Property> _peers = this.getPeers(e);
        peers.addAll(_peers);
        EList _allParents = e.allParents();
        Consumer<Classifier> _function = it -> {
            Set<Property> _peers_1 = this.getPeers((Class)it);
            peers.addAll(_peers_1);
        };
        _allParents.forEach(_function);
        _xblockexpression = peers;
        return _xblockexpression;
    }

    private Property getPeerPart(Property memberEnd, Property part) {
        Functions.Function1 _function;
        Property _xblockexpression = null;
        Property peerPart = null;
        Type _type = part.getType();
        EList _ownedPorts = ((Class)_type).getOwnedPorts();
        Iterable _filter = IterableExtensions.filter((Iterable)_ownedPorts, (Functions.Function1)(_function = it -> it.isBehavior()));
        List ports = IterableExtensions.toList((Iterable)_filter);
        boolean _contains = ports.contains(memberEnd);
        if (_contains) {
            peerPart = memberEnd;
        } else {
            Functions.Function1 _function_3;
            Functions.Function1 _function_2;
            Iterable _filter_2;
            Iterable _map;
            List _list;
            Iterable _flatten;
            ConnectorEnd end;
            boolean _not;
            Association association = memberEnd.getAssociation();
            Functions.Function1 _function_1 = it -> {
                Association _type_1 = it.getType();
                return Objects.equal((Object)_type_1, (Object)association);
            };
            Iterable _filter_1 = IterableExtensions.filter(this.connectors, (Functions.Function1)_function_1);
            List connectors = IterableExtensions.toList((Iterable)_filter_1);
            boolean _isEmpty = connectors.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not && (end = (ConnectorEnd)IterableExtensions.head((Iterable)(_flatten = Iterables.concat((Iterable)(_list = IterableExtensions.toList((Iterable)(_map = IterableExtensions.map((Iterable)(_filter_2 = IterableExtensions.filter((Iterable)connectors, (Functions.Function1)(_function_2 = it -> {
                Functions.Function1 _function_3;
                EList _ends = it.getEnds();
                Iterable _filter_2 = IterableExtensions.filter((Iterable)_ends, (Functions.Function1)(_function_3 = it_1 -> {
                    ConnectableElement _role = it_1.getRole();
                    String _name = _role.getName();
                    String _name_1 = part.getName();
                    return _name.contentEquals(_name_1);
                }));
                boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)_filter_2);
                return !_isEmpty_1;
            }))), (Functions.Function1)(_function_3 = it -> {
                EList _ends = it.getEnds();
                Functions.Function1 _function_4 = it_1 -> {
                    String _name_1;
                    ConnectableElement _role = it_1.getRole();
                    String _name = _role.getName();
                    boolean _contentEquals = _name.contentEquals(_name_1 = part.getName());
                    return !_contentEquals;
                };
                return IterableExtensions.filter((Iterable)_ends, (Functions.Function1)_function_4);
            }))))))))) != null) {
                ConnectableElement _role = end.getRole();
                peerPart = (Property)_role;
            }
        }
        _xblockexpression = peerPart;
        return _xblockexpression;
    }

    private ClassifierInstance matchPeerObject(Property part, List<ClassifierInstance> partsObjects) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            String _name_1 = part.getName();
            return Objects.equal((Object)_name, (Object)_name_1);
        };
        Iterable _filter = IterableExtensions.filter(partsObjects, (Functions.Function1)_function);
        return (ClassifierInstance)IterableExtensions.head((Iterable)_filter);
    }

    private Set<Property> getCompositeParts(Class e) {
        EList _ownedAttributes = e.getOwnedAttributes();
        Functions.Function1 _function = it -> it.isComposite();
        Iterable _filter = IterableExtensions.filter((Iterable)_ownedAttributes, (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)_filter);
    }

    private Set<Property> getAllCompositeParts(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> compositeParts = new HashSet<Property>();
        Set<Property> _compositeParts = this.getCompositeParts(e);
        compositeParts.addAll(_compositeParts);
        EList _allParents = e.allParents();
        Consumer<Classifier> _function = it -> {
            Set<Property> _compositeParts_1 = this.getCompositeParts((Class)it);
            compositeParts.addAll(_compositeParts_1);
        };
        _allParents.forEach(_function);
        _xblockexpression = compositeParts;
        return _xblockexpression;
    }

    public HashSet<Property> getReadOnlyAttributes(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> attributes = new HashSet<Property>();
        Set<Property> _peers = this.getPeers(e);
        attributes.addAll(_peers);
        Set<Property> _compositeParts = this.getCompositeParts(e);
        attributes.addAll(_compositeParts);
        _xblockexpression = attributes;
        return _xblockexpression;
    }

    public HashSet<Property> getAllReadOnlyAttributes(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> attributes = new HashSet<Property>();
        Set<Property> _allPeers = this.getAllPeers(e);
        attributes.addAll(_allPeers);
        Set<Property> _allCompositeParts = this.getAllCompositeParts(e);
        attributes.addAll(_allCompositeParts);
        _xblockexpression = attributes;
        return _xblockexpression;
    }

    public int getNbReadOnlyAttributes(Class e) {
        boolean _notEquals;
        Integer _xblockexpression = null;
        HashSet<Property> attributes = this.getAllReadOnlyAttributes(e);
        Integer _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(attributes, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            Functions.Function1 _function = it -> it.getLower();
            Iterable _map = IterableExtensions.map(attributes, (Functions.Function1)_function);
            Functions.Function2 _function_1 = (p1, p2) -> p1 + p2;
            _xifexpression = (Integer)IterableExtensions.reduce((Iterable)_map, (Functions.Function2)_function_1);
        } else {
            _xifexpression = 0;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String typedefToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef struct ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_properties_ro ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_properties_ro;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String getAbstractTypeName(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"ABSTRACT_");
        String _name = e.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_PROPERTIES_RO");
        return _builder.toString();
    }

    private String typeToC(Class e) {
        String _xblockexpression = null;
        HashSet<Property> attributes = this.getReadOnlyAttributes(e);
        EList superClasses = e.getSuperClasses();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The ");
        String _name = e.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)"_properties_ro type used to link instances of the ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)" class with their properties.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"struct ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"_properties_ro {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _abstractTypeName = this.getAbstractTypeName((Class)it);
            _builder_1.append((Object)_abstractTypeName, "");
            return _builder_1.toString();
        };
        List _map = ListExtensions.map((List)superClasses, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function_1 = it -> this.subfieldTypeToC((Property)it);
        Iterable _map_1 = IterableExtensions.map(attributes, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
        _builder.append((Object)_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String abstractPeersToC(Class e) {
        boolean _notEquals;
        String _xblockexpression = null;
        HashSet<Property> attributes = this.getReadOnlyAttributes(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#define ");
        String _abstractTypeName = this.getAbstractTypeName(e);
        _builder.append((Object)_abstractTypeName, "");
        _builder.append((Object)" ");
        StringConcatenation _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(attributes, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"\\");
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> this.subfieldTypeToC((Property)it);
        Iterable _map = IterableExtensions.map(attributes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)" \\\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldTypeToC(Property e) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        int _lower = e.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            Type _type = e.getType();
            String _name = _type.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)"_Object * ");
            String _name_1 = e.getName();
            _builder_1.append((Object)_name_1, "");
            _builder_1.append((Object)";");
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            Type _type_1 = e.getType();
            String _name_2 = _type_1.getName();
            _builder_2.append((Object)_name_2, "");
            _builder_2.append((Object)"_Object * ");
            String _name_3 = e.getName();
            _builder_2.append((Object)_name_3, "");
            _builder_2.append((Object)"[");
            int _lower_1 = e.getLower();
            _builder_2.append((Object)_lower_1, "");
            _builder_2.append((Object)"];");
            _xifexpression = _builder_2;
        }
        _builder.append((Object)_xifexpression, "");
        return _builder.toString();
    }

    private String fieldTypeToC(ClassifierInstance e) {
        StringConcatenation _builder = new StringConcatenation();
        Classifier _classifier = e.getClassifier();
        String _name = _classifier.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_properties_ro ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String fieldToC(ClassifierInstance e) {
        String _xblockexpression = null;
        Classifier _classifier = e.getClassifier();
        Class type = (Class)_classifier;
        HashSet<Property> attributes = this.getAllReadOnlyAttributes(type);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)".");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" = {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> {
            String _xifexpression = null;
            boolean _isComposite = it.isComposite();
            if (_isComposite) {
                String _xblockexpression_1 = null;
                String partName = it.getName();
                Functions.Function1 _function_1 = it_1 -> {
                    String _name_1 = it_1.getName();
                    return Objects.equal((Object)_name_1, (Object)partName);
                };
                Iterable _filter = IterableExtensions.filter(this.objects, (Functions.Function1)_function_1);
                ClassifierInstance _head = (ClassifierInstance)IterableExtensions.head((Iterable)_filter);
                _xifexpression = _xblockexpression_1 = this.subfieldToC((Property)it, _head);
            } else {
                String _xifexpression_1 = null;
                if (e instanceof PartClassifierInstance) {
                    String _xblockexpression_2 = null;
                    Property _part = ((PartClassifierInstance)e).getPart();
                    Property peerPart = this.getPeerPart((Property)it, _part);
                    String _xifexpression_2 = null;
                    if (peerPart != null) {
                        ClassifierInstance _matchPeerObject = this.matchPeerObject(peerPart, this.objects);
                        _xifexpression_2 = this.subfieldToC((Property)it, _matchPeerObject);
                    } else {
                        _xifexpression_2 = this.subfieldToC((Property)it, null);
                    }
                    _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        };
        Iterable _map = IterableExtensions.map(attributes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldToC(Property p, ClassifierInstance e) {
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        if (e == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)".");
            String _name = p.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)" = NULL");
            _xifexpression = _builder_1;
        } else {
            boolean _equals;
            StringConcatenation _xblockexpression = null;
            Classifier _classifier = e.getClassifier();
            String objectType = this.getObjectTypePrefix((Class)_classifier);
            StringConcatenation _xifexpression_1 = null;
            int _lower = p.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)".");
                String _name_1 = p.getName();
                _builder_2.append((Object)_name_1, "");
                _builder_2.append((Object)" = (");
                Type _type = p.getType();
                String _name_2 = _type.getName();
                _builder_2.append((Object)_name_2, "");
                _builder_2.append((Object)"_Object *) &");
                _builder_2.append((Object)objectType, "");
                _builder_2.append((Object)"_");
                String _actualName = e.getActualName();
                _builder_2.append((Object)_actualName, "");
                _xifexpression_1 = _builder_2;
            } else {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append((Object)".");
                String _name_3 = p.getName();
                _builder_3.append((Object)_name_3, "");
                _builder_3.append((Object)" = {");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append((Object)"\t");
                int _lower_1 = p.getLower();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower_1, true);
                Functions.Function1 _function = it -> {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append((Object)"(");
                    Type _type_1 = p.getType();
                    String _name_4 = _type_1.getName();
                    _builder_4.append((Object)_name_4, "");
                    _builder_4.append((Object)"_Object *) &");
                    _builder_4.append((Object)objectType, "");
                    _builder_4.append((Object)"_");
                    String _actualName_1 = e.getActualName();
                    _builder_4.append((Object)_actualName_1, "");
                    _builder_4.append((Object)"_");
                    _builder_4.append(it, "");
                    return _builder_4.toString();
                };
                Iterable _map = IterableExtensions.map((Iterable)_doubleDotLessThan, (Functions.Function1)_function);
                String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
                _builder_3.append((Object)_join, "\t");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append((Object)"}");
                _xifexpression_1 = _builder_3;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        _builder.append((Object)_xifexpression, "");
        return _builder.toString();
    }

    private String getObjectTypePrefix(Class e) {
        String _xifexpression = null;
        boolean _isActive = e.isActive();
        _xifexpression = _isActive ? "ao" : "po";
        return _xifexpression;
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Typedef of read-only properties types for classes.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.typedefToC((Class)it);
        Iterable _map = IterableExtensions.map(this.classes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef struct PropertiesRO PropertiesRO;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Declaration of read-only properties types for superclasses.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.abstractPeersToC((Class)it);
        Iterable _map = IterableExtensions.map(this.superclasses, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Declaration of read-only properties types for classes.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.typeToC((Class)it);
        Iterable _map_1 = IterableExtensions.map(this.classes, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1);
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The global read-only properties type used to make links between objects.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"struct PropertiesRO {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function_2 = it -> this.fieldTypeToC((ClassifierInstance)it);
        List _map_2 = ListExtensions.map(this.objectsSUS, (Functions.Function1)_function_2);
        String _join_2 = IterableExtensions.join((Iterable)_map_2);
        _builder.append((Object)_join_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function_3 = it -> this.fieldTypeToC((ClassifierInstance)it);
        List _map_3 = ListExtensions.map(this.objectsOBS, (Functions.Function1)_function_3);
        String _join_3 = IterableExtensions.join((Iterable)_map_3);
        _builder.append((Object)_join_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"extern PropertiesRO properties_ro;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Struct initializer for read-only properties.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"PropertiesRO properties_ro = {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> this.fieldToC((ClassifierInstance)it);
        List _map = ListExtensions.map(this.objectsSUS, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
        _builder.append((Object)_join, "\t");
        _builder.append((Object)",");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function_1 = it -> this.fieldToC((ClassifierInstance)it);
        List _map_1 = ListExtensions.map(this.objectsOBS, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)",\n");
        _builder.append((Object)_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }
}

