/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.model;

import emi.serializer.actionlanguage.ActionLanguages;
import emi.serializer.memoryobjects.ActiveObjects;
import emi.serializer.memoryobjects.ClassInfo;
import emi.serializer.memoryobjects.EventPools;
import emi.serializer.memoryobjects.EventsParameters;
import emi.serializer.memoryobjects.Interpreter;
import emi.serializer.memoryobjects.Operations;
import emi.serializer.memoryobjects.PassiveObjects;
import emi.serializer.memoryobjects.Ports;
import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.memoryobjects.SignalEvents;
import emi.serializer.memoryobjects.Store;
import emi.serializer.memoryobjects.Transitions;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.serialization.uml.AUmlSerializer;
import emi.serializer.serialization.uml.UmlModelSerializer;
import emi.serializer.utils.UmlNavigation;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ModelSerializer {
    public static final String INTERPRETER_DIR = "emi-uml-c/";
    private final UmlModelSerializer umlModel;
    private final AUmlSerializer umlSerializer;
    private final ActionLanguages actionLanguages;
    private final EventsParameters eventsParameters;
    private final Store store;
    private final PropertiesRO peers;
    private final ClassInfo classInfo;
    private final SignalEvents signalEvents;
    private final ActiveObjects activeObjects;
    private final PassiveObjects passiveObjects;
    private final EventPools eventPools;
    private final Operations operations;
    private final Ports ports;
    private final Transitions transitions;
    private final Interpreter interpreter;
    private final int nbObservers;

    public ModelSerializer(Resource r, MetamodelTable table, IStrategy strategy) {
        int _size;
        Interpreter _interpreter;
        Transitions _transitions;
        Ports _ports;
        Operations _operations;
        EventPools _eventPools;
        EventsParameters _eventsParameters;
        PassiveObjects _passiveObjects;
        ActiveObjects _activeObjects;
        SignalEvents _signalEvents;
        ClassInfo _classInfo;
        PropertiesRO _propertiesRO;
        Store _store;
        ActionLanguages _actionLanguages;
        AUmlSerializer _aUmlSerializer;
        UmlModelSerializer _umlModelSerializer;
        this.umlModel = _umlModelSerializer = new UmlModelSerializer(r);
        this.umlSerializer = _aUmlSerializer = new AUmlSerializer(r, table, strategy);
        this.actionLanguages = _actionLanguages = new ActionLanguages(r);
        this.store = _store = new Store(r);
        this.peers = _propertiesRO = new PropertiesRO(r);
        this.classInfo = _classInfo = new ClassInfo(r);
        this.signalEvents = _signalEvents = new SignalEvents(r);
        this.activeObjects = _activeObjects = new ActiveObjects(r);
        this.passiveObjects = _passiveObjects = new PassiveObjects(r);
        this.eventsParameters = _eventsParameters = new EventsParameters(r);
        this.eventPools = _eventPools = new EventPools(r);
        this.operations = _operations = new Operations(r);
        this.ports = _ports = new Ports(r);
        this.transitions = _transitions = new Transitions(r);
        this.interpreter = _interpreter = new Interpreter(r);
        List<ClassifierInstance> _activeObjectsListOfComposite = UmlNavigation.getActiveObjectsListOfComposite(r, "OBS");
        this.nbObservers = _size = _activeObjectsListOfComposite.size();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#ifndef MODEL_H");
        _builder.newLine();
        _builder.append((Object)"#define MODEL_H");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @file model.h");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Define the UML model to interpret.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Do not modify manually.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"types_calibration.h\"");
        _builder.newLine();
        _builder.append((Object)"//#include \"interpreter/interpreter.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/active_object.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/passive_object.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Number of observers in the model (observers that are active objects).");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"#define NB_OBSERVERS (");
        _builder.append((Object)this.nbObservers, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef = this.eventsParameters.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_1 = this.store.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_2 = this.signalEvents.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_2, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_3 = this.eventPools.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_3, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_4 = this.peers.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_4, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_5 = this.transitions.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_5, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_6 = this.classInfo.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_6, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_7 = this.activeObjects.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_7, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_8 = this.passiveObjects.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_8, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_9 = this.operations.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_9, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_10 = this.ports.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_10, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_11 = this.interpreter.serializeHeadersTypedef();
        _builder.append((Object)_serializeHeadersTypedef_11, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        String _serializeHeaders = this.umlModel.serializeHeaders();
        _builder.append((Object)_serializeHeaders, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_1 = this.eventsParameters.serializeHeaders();
        _builder.append((Object)_serializeHeaders_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_2 = this.store.serializeHeaders();
        _builder.append((Object)_serializeHeaders_2, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_3 = this.signalEvents.serializeHeaders();
        _builder.append((Object)_serializeHeaders_3, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_4 = this.eventPools.serializeHeaders();
        _builder.append((Object)_serializeHeaders_4, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_5 = this.operations.serializeHeaders();
        _builder.append((Object)_serializeHeaders_5, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_6 = this.transitions.serializeHeaders();
        _builder.append((Object)_serializeHeaders_6, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_7 = this.classInfo.serializeHeaders();
        _builder.append((Object)_serializeHeaders_7, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_8 = this.activeObjects.serializeHeaders();
        _builder.append((Object)_serializeHeaders_8, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_9 = this.passiveObjects.serializeHeaders();
        _builder.append((Object)_serializeHeaders_9, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_10 = this.peers.serializeHeaders();
        _builder.append((Object)_serializeHeaders_10, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_11 = this.ports.serializeHeaders();
        _builder.append((Object)_serializeHeaders_11, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#endif /* MODEL_H */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @file model.c");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Define the UML model to interpret.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Do not modify manually.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include <stdlib.h>");
        _builder.newLine();
        _builder.append((Object)"#include <stdio.h>");
        _builder.newLine();
        _builder.append((Object)"#include <stddef.h>");
        _builder.newLine();
        _builder.append((Object)"#include <string.h>");
        _builder.newLine();
        _builder.append((Object)"#include \"model.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"identifiers.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"metamodel/uml.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/action_language/action_language.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/guard_evaluator/guard_evaluator.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/effect_interpreter/effect_interpreter.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/event_pool/event_pool.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"interpreter/store.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"utilities/types.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"trace/trace.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"target/bsp/uml_api.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"target/bsp/utils.h\"");
        _builder.newLine();
        _builder.newLine();
        String _serializeDeclarations = this.umlSerializer.serializeDeclarations();
        _builder.append((Object)_serializeDeclarations, "");
        _builder.newLineIfNotEmpty();
        String _serializeDeclarations_1 = this.actionLanguages.serializeDeclarations();
        _builder.append((Object)_serializeDeclarations_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize = this.umlModel.serialize();
        _builder.append((Object)_serialize, "");
        _builder.newLineIfNotEmpty();
        String _serialize_1 = this.umlSerializer.serialize();
        _builder.append((Object)_serialize_1, "");
        _builder.newLineIfNotEmpty();
        String _serialize_2 = this.actionLanguages.serialize();
        _builder.append((Object)_serialize_2, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_3 = this.eventsParameters.serialize();
        _builder.append((Object)_serialize_3, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_4 = this.store.serialize();
        _builder.append((Object)_serialize_4, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_5 = this.signalEvents.serialize();
        _builder.append((Object)_serialize_5, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_6 = this.eventPools.serialize();
        _builder.append((Object)_serialize_6, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_7 = this.operations.serialize();
        _builder.append((Object)_serialize_7, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_8 = this.transitions.serialize();
        _builder.append((Object)_serialize_8, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_9 = this.classInfo.serialize();
        _builder.append((Object)_serialize_9, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_10 = this.activeObjects.serialize();
        _builder.append((Object)_serialize_10, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_11 = this.passiveObjects.serialize();
        _builder.append((Object)_serialize_11, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_12 = this.peers.serialize();
        _builder.append((Object)_serialize_12, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_13 = this.ports.serialize();
        _builder.append((Object)_serialize_13, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\n\n\n", "");
        _builder.newLineIfNotEmpty();
        String _serialize_14 = this.interpreter.serialize();
        _builder.append((Object)_serialize_14, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

