/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.client;

import emi.analysis.client.com.TCPClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIAtom;
import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransitionComposite;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.protocol.EMIProtocolAtoms;
import emi.analysis.protocol.EMIProtocolConfiguration;
import emi.analysis.protocol.EMIProtocolConfigurationDiff;
import emi.analysis.protocol.EMIProtocolFireableTransitionComposite;
import java.io.IOException;

public abstract class AEMIClient
extends TCPClient {
    private Boolean diffMode = false;
    private EMIConfiguration referenceConfiguration;

    protected AEMIClient(String address, int port) throws EMIException {
        try {
            this.connect(address, port);
        }
        catch (IOException e) {
            throw new EMIException("EMI client exception: " + e.getMessage());
        }
    }

    public Boolean isDiffMode() {
        return this.diffMode;
    }

    public void stopDiffMode() {
        this.diffMode = false;
        this.referenceConfiguration = null;
    }

    public void setConfiguration(EMIConfiguration configuration) throws EMIException {
        if (configuration == null) {
            throw new EMIException("EMI client set configuration exception: configuration is null");
        }
        try {
            if (this.isDiffMode().booleanValue()) {
                byte[] data = EMIProtocolConfigurationDiff.createConfigurationDiff(configuration, this.referenceConfiguration);
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(7, data.length));
                this.getConnection().write(data);
                this.referenceConfiguration = configuration;
            } else {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(6, configuration.getSize()));
                this.getConnection().write(EMIProtocolConfiguration.serialize(configuration));
            }
        }
        catch (IOException e) {
            throw new EMIException("EMI client set configuration exception: " + e.getMessage());
        }
    }

    public void fireTransition(EMIFireableTransitionComposite transition) throws EMIException {
        if (transition == null) {
            throw new EMIException("EMI client fire transition exception: transition is null");
        }
        try {
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(9, EMIProtocolFireableTransitionComposite.getSize(transition)));
            this.getConnection().write(EMIProtocolFireableTransitionComposite.serialize(transition));
        }
        catch (IOException e) {
            throw new EMIException("EMI client fire transition exception: " + e.getMessage());
        }
    }

    protected void sendRequestGetFireableTransition(EMIConfiguration configuration) throws IOException {
        if (this.isDiffMode().booleanValue()) {
            byte[] data = EMIProtocolConfigurationDiff.createConfigurationDiff(configuration, this.referenceConfiguration);
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(11, data.length));
            this.getConnection().write(data);
            this.referenceConfiguration = configuration;
        } else {
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(10, configuration.getSize()));
            this.getConnection().write(EMIProtocolConfiguration.serialize(configuration));
        }
    }

    protected void sendRequestFireTransition(EMIFireableTransitionComposite transition, EMIConfiguration configuration) throws IOException {
        if (this.isDiffMode().booleanValue()) {
            byte[] data = EMIProtocolConfigurationDiff.createConfigurationDiff(configuration, this.referenceConfiguration);
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(13, 4 + data.length + EMIProtocolFireableTransitionComposite.getSize(transition)));
            this.getConnection().write(EMIProtocolConfiguration.serializeLength(data.length));
            this.getConnection().write(data);
            this.getConnection().write(EMIProtocolFireableTransitionComposite.serialize(transition));
            this.referenceConfiguration = configuration;
        } else {
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(12, 4 + configuration.getSize() + EMIProtocolFireableTransitionComposite.getSize(transition)));
            this.getConnection().write(EMIProtocolConfiguration.serializeLength(configuration.getSize()));
            this.getConnection().write(EMIProtocolConfiguration.serialize(configuration));
            this.getConnection().write(EMIProtocolFireableTransitionComposite.serialize(transition));
        }
    }

    protected void sendRequestEvaluateAtoms(EMIAtom[] atoms) throws IOException {
        int size = 4;
        for (int i = 0; i < atoms.length; ++i) {
            size += 21;
            size += atoms[i].length();
        }
        EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(15, size));
        this.getConnection().write(EMIProtocolAtoms.serialize(atoms, size));
    }

    protected void sendRequestTranslate(EMIConfiguration configuration) throws IOException {
        EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(101, configuration.getSize()));
        this.getConnection().write(EMIProtocolConfiguration.serialize(configuration));
    }

    protected void sendRequestTranslate(EMIFireableTransitionComposite transition) throws IOException {
        EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(102, EMIProtocolFireableTransitionComposite.getSize(transition)));
        this.getConnection().write(EMIProtocolFireableTransitionComposite.serialize(transition));
    }

    protected EMIConfiguration readResponseStartDiffMode(EMIProtocol.Header header) throws IOException {
        EMIConfiguration configuration;
        if (header.size > 0) {
            configuration = EMIProtocolConfiguration.deserialize(this.getConnection().read(header.size));
            this.referenceConfiguration = configuration.createCopy();
            this.diffMode = true;
        } else {
            this.diffMode = false;
            this.referenceConfiguration = null;
            configuration = null;
        }
        return configuration;
    }

    protected EMIConfiguration readResponseGetConfigurationDiff(EMIProtocol.Header header) throws IOException {
        EMIConfiguration configuration = EMIProtocolConfigurationDiff.createConfiguration(this.getConnection().read(header.size), this.referenceConfiguration);
        this.referenceConfiguration = configuration.createCopy();
        return configuration;
    }
}

