/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.standalone.client;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIAtom;
import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransitionComposite;
import emi.analysis.model.EMIModel;
import emi.analysis.server.atom.AtomManagementException;
import emi.analysis.server.atom.AtomManager;
import emi.analysis.server.translator.Translator;
import emi.analysis.server.translator.TranslatorException;
import emi.analysis.server.translator.TranslatorFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class EMISynchronousStandaloneClient
extends EMISynchronousClient {
    private AtomManager atomManager;
    private Translator translator;

    public EMISynchronousStandaloneClient(String address, int port) throws EMIException {
        super(address, port);
    }

    public EMISynchronousStandaloneClient(String address, int port, String emiModel, String emiHome, String target, String compiler, String makeTool) throws EMIException {
        super(address, port);
        try {
            String emiHomeUsed = EMIModel.checkEMIHome(emiHome != null ? emiHome : System.getenv("EMI_HOME"));
            String emiModelUsed = EMIModel.checkEMIModel(emiModel);
            this.atomManager = new AtomManager(this.getConnection(), emiHomeUsed, emiModelUsed, target, compiler, makeTool, false);
        }
        catch (IOException e) {
            throw new EMIException(e.getMessage());
        }
    }

    public EMISynchronousStandaloneClient(String address, int port, String emiModel, String target, String dwarfTool) throws EMIException {
        super(address, port);
        try {
            String emiModelUsed = EMIModel.checkEMIModel(emiModel);
            this.translator = TranslatorFactory.buildTranslator(emiModelUsed, target, dwarfTool, false);
        }
        catch (IOException e) {
            throw new EMIException(e.getMessage());
        }
    }

    public EMISynchronousStandaloneClient(String address, int port, String emiModel, String emiHome, String target, String compiler, String makeTool, String dwarfTool) throws EMIException {
        super(address, port);
        try {
            String emiHomeUsed = EMIModel.checkEMIHome(emiHome != null ? emiHome : System.getenv("EMI_HOME"));
            String emiModelUsed = EMIModel.checkEMIModel(emiModel);
            this.atomManager = new AtomManager(this.getConnection(), emiHomeUsed, emiModelUsed, target, compiler, makeTool, false);
            this.translator = TranslatorFactory.buildTranslator(emiModelUsed, target, dwarfTool, false);
        }
        catch (IOException e) {
            throw new EMIException(e.getMessage());
        }
    }

    @Override
    public boolean[] evaluateAtoms(EMIAtom[] atoms) throws EMIException {
        if (atoms == null) {
            throw new EMIException("EMI synchronous standalone client evaluate atoms exception: atoms are null");
        }
        if (this.atomManager == null) {
            throw new EMIException("Atom evaluation: not available");
        }
        ArrayList<EMIAtom> atomsArray = new ArrayList<EMIAtom>(Arrays.asList(atoms));
        try {
            this.atomManager.evaluate(atomsArray);
        }
        catch (AtomManagementException e) {
            throw new EMIException("Atom evaluation: " + e.getMessage());
        }
        try {
            return this.readEvaluationOfAtoms();
        }
        catch (IOException e) {
            throw new EMIException("Atom evaluation: " + e.getMessage());
        }
    }

    @Override
    public String getTranslation(EMIConfiguration configuration) throws EMIException {
        if (configuration == null) {
            throw new EMIException("EMI synchronous standalone client get translation: configuration is null");
        }
        if (this.translator == null) {
            throw new EMIException("Translation: not available");
        }
        try {
            return this.translator.translate(configuration);
        }
        catch (TranslatorException e) {
            throw new EMIException("Translation: " + e.getMessage());
        }
    }

    @Override
    public String getTranslation(EMIFireableTransitionComposite transition) throws EMIException {
        if (transition == null) {
            throw new EMIException("EMI synchronous standalone client get translation: fireable transition is null");
        }
        if (this.translator == null) {
            throw new EMIException("Translation: not available");
        }
        try {
            return this.translator.translate(transition);
        }
        catch (TranslatorException e) {
            throw new EMIException("Translation: " + e.getMessage());
        }
    }
}

