/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.translator;

import emi.analysis.server.translator.Translator;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaECTreeGeneratorDwarfdump
implements Translator.IMetaECTreeGenerator {
    private static final String DWARFDUMP_FILE = "interpreter.dwarfdump";
    private static final int DW_INDEX_ADDRESS = 1;
    private static final int DW_INDEX_TAG_TYPE = 2;
    private static final int DW_INDEX_NAME = 3;
    private static final int DW_INDEX_SIZE = 4;
    private static final int DW_INDEX_TYPE = 5;
    private static final int DW_INDEX_NB_ELEMENTS = 6;
    private static final int DW_INDEX_LEVEL = 7;
    private static final int DW_NB_INDEX = 8;
    private static final int RADIX_HEXA = 16;
    private File dwarfdumpFile;
    private String dwarfdumpString;

    public MetaECTreeGeneratorDwarfdump(String searchDir) throws IOException {
        String dwarfdumpFileName = searchDir + "/" + DWARFDUMP_FILE;
        this.dwarfdumpFile = new File(dwarfdumpFileName);
        if (!this.dwarfdumpFile.exists() || !this.dwarfdumpFile.isFile()) {
            throw new IOException("Dwarfdump (Meta EC Tree Generator): " + dwarfdumpFileName + " is not a valid file");
        }
        this.collectDwarfdumpInformations();
        if (this.matchObjectByName("Store", "DW_TAG_structure_type")[0] == null) {
            throw new IOException("Dwarfdump (Meta EC Tree Generator): " + dwarfdumpFileName + " is not a valid dwarfdump file");
        }
    }

    private void collectDwarfdumpInformations() throws IOException {
        byte[] buffer = new byte[(int)this.dwarfdumpFile.length()];
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.dwarfdumpFile)));){
            stream.readFully(buffer);
        }
        this.dwarfdumpString = new String(buffer);
        if (this.dwarfdumpString.length() == 0) {
            throw new IOException("Dwarfdump (Meta EC Tree Generator): " + this.dwarfdumpFile.getName() + " is an empty file");
        }
    }

    @Override
    public void generateMetaECTree(Translator.MetaECTreeItem treeRoot) throws IOException {
        List<Translator.MetaECTreeItem> items = this.collectItems(treeRoot.getType(), treeRoot.getOffset(), null);
        for (Translator.MetaECTreeItem item : items) {
            String typeName = item.getType();
            if (item.getNbElements() == 1) {
                if (!(Translator.isPrimitiveType(typeName) || Translator.isUMLType(typeName) || Translator.isUnion(typeName))) {
                    this.generateMetaECTree(item);
                }
            } else {
                this.generateMetaECTreeFromItemArray(item);
            }
            treeRoot.getChildren().add(item);
        }
    }

    private void generateMetaECTreeFromItemArray(Translator.MetaECTreeItem itemArray) throws IOException {
        ArrayList<Translator.MetaECTreeItem> children = new ArrayList<Translator.MetaECTreeItem>();
        int sizeElement = itemArray.getSize() / itemArray.getNbElements();
        int offset = itemArray.getOffset();
        for (int i = 0; i < itemArray.getNbElements(); ++i) {
            Translator.MetaECTreeItem item = new Translator.MetaECTreeItem(itemArray.getType(), Translator.createArrayItemName(itemArray.getName(), i), 1, offset + i * sizeElement, sizeElement, null);
            children.add(item);
            if (Translator.isPrimitiveType(itemArray.getType()) || Translator.isUMLType(itemArray.getType()) || Translator.isUnion(itemArray.getType())) continue;
            this.generateMetaECTree(item);
        }
        itemArray.getChildren().addAll(children);
    }

    private List<Translator.MetaECTreeItem> collectItems(String nodeTypeName, int globalOffset, String nodeTypeAddress) throws IOException {
        ArrayList<Translator.MetaECTreeItem> result = new ArrayList<Translator.MetaECTreeItem>();
        String[] groups = nodeTypeAddress != null ? this.matchObjectByAddress(nodeTypeAddress) : this.matchObjectByName(nodeTypeName, "DW_TAG_structure_type");
        String dwarfdumpItemString = groups[0];
        int level = 1;
        if (groups[7] != null) {
            level = Integer.parseInt(groups[7]);
        }
        int itemSize = Integer.parseInt(this.matchIntegerAttribute("DW_AT_byte_size", true, false, dwarfdumpItemString), 16);
        result.addAll(this.matchMembers(dwarfdumpItemString, globalOffset, itemSize, level + 1));
        return result;
    }

    private List<Translator.MetaECTreeItem> matchMembers(String dwarfdumpStructString, int globalOffset, int structSize, int level) throws IOException {
        ArrayList<Translator.MetaECTreeItem> result = new ArrayList<Translator.MetaECTreeItem>();
        Matcher matcher = Pattern.compile("<\\s*" + level + "><0x\\p{XDigit}+>\\s*DW_TAG_member\n(.*?)(?=(<\\s*\\d+><)|$)", 32).matcher(dwarfdumpStructString);
        while (matcher.find()) {
            String member = matcher.group(0);
            String name = this.matchStringAttribute("DW_AT_name", member);
            String type = this.matchIntegerAttribute("DW_AT_type", true, true, member);
            String sOffset = this.matchIntegerAttribute("DW_AT_data_member_location", false, false, member);
            int relativeOffset = 0;
            if (sOffset != null) {
                relativeOffset = Integer.parseInt(sOffset);
            }
            int offset = globalOffset + relativeOffset;
            String[] typeGroups = this.searchType(type);
            String address = typeGroups[1];
            String typeName = typeGroups[5];
            int nbElements = this.computeNbElements(typeGroups[6]);
            int sizeOneElement = Integer.parseInt(typeGroups[4], 16);
            int size = sizeOneElement * nbElements;
            ArrayList<Translator.MetaECTreeItem> children = null;
            if (name == null) {
                name = typeGroups[3];
            }
            if (typeName == null) {
                typeName = typeGroups[3];
            }
            if ("union".equals(typeName)) {
                children = new ArrayList<Translator.MetaECTreeItem>();
                children.addAll(this.collectItems(null, offset, address));
                for (Translator.MetaECTreeItem child : children) {
                    this.generateMetaECTree(child);
                }
            }
            Translator.MetaECTreeItem item = new Translator.MetaECTreeItem(typeName, name, nbElements, offset, size, children);
            result.add(item);
        }
        return result;
    }

    private int computeNbElements(String arraySize) {
        if (arraySize != null) {
            return Integer.parseInt(arraySize, 16);
        }
        return 1;
    }

    private String[] matchObjectByName(String name, String tagType) throws IOException {
        String beginPattern = "^\\s+";
        Matcher matcher = Pattern.compile("^<\\s*(\\d+)><0x\\p{XDigit}+>\\s*" + tagType + "\n(" + "^\\s+" + "DW_AT_name\\s*" + name + "\n(?:" + "^\\s+" + ".*?\n)*)(?=^<\\s*(\\d+)><)", 40).matcher(this.dwarfdumpString);
        if (!matcher.find()) {
            throw new IOException("Dwarfdump (Meta EC Tree Generator): " + this.dwarfdumpFile.getName() + " does not provide the needed object \"" + name + "\" of type " + tagType);
        }
        String level = matcher.group(1);
        String dwarfdumpAttributesString = matcher.group(2);
        matcher = Pattern.compile("^<\\s*" + level + "><0x(\\p{XDigit}+)>\\s*" + tagType + "\n(" + "^\\s+" + "DW_AT_name\\s*" + name + "\n(?:" + "^\\s+" + "[^<]*?\n)*).*?(?=<\\s*" + level + ">)", 40).matcher(this.dwarfdumpString);
        if (!matcher.find()) {
            throw new IOException("Dwarfdump (Meta EC Tree Generator): " + this.dwarfdumpFile.getName() + " does not provide the needed object \"" + name + "\" of type " + tagType);
        }
        String dwarfdumpObjectString = matcher.group(0);
        String[] groups = new String[8];
        groups[0] = dwarfdumpObjectString;
        groups[1] = matcher.group(1);
        groups[2] = tagType;
        groups[3] = name;
        groups[4] = this.matchIntegerAttribute("DW_AT_byte_size", true, false, dwarfdumpAttributesString);
        groups[5] = this.matchIntegerAttribute("DW_AT_type", true, true, dwarfdumpAttributesString);
        groups[7] = level;
        return groups;
    }

    private String[] matchObjectByAddress(String address) throws IOException {
        Matcher matcher = Pattern.compile("^<\\s*(\\d+)><0x" + address + ">\\s*\\w*\n(.*?)(?=^<)", 40).matcher(this.dwarfdumpString);
        if (!matcher.find()) {
            throw new IOException("Dwarfdump (Meta EC Tree Generator): " + this.dwarfdumpFile.getName() + " does not provide the needed object at address " + address);
        }
        String level = matcher.group(1);
        String dwarfdumpAttributesString = matcher.group(2);
        matcher = Pattern.compile("^<\\s*" + level + "><0x" + address + ">\\s*(\\w*)\n.*?(?=<\\s*" + level + ">)", 40).matcher(this.dwarfdumpString);
        if (!matcher.find()) {
            throw new IOException("Dwarfdump (Meta EC Tree Generator): " + this.dwarfdumpFile.getName() + " does not provide the needed object at address " + address);
        }
        String dwarfdumpObjectString = matcher.group(0);
        String[] groups = new String[8];
        groups[0] = dwarfdumpObjectString;
        groups[1] = address;
        groups[2] = matcher.group(1);
        groups[3] = this.matchStringAttribute("DW_AT_name", dwarfdumpAttributesString);
        groups[4] = this.matchIntegerAttribute("DW_AT_byte_size", true, false, dwarfdumpAttributesString);
        groups[5] = this.matchIntegerAttribute("DW_AT_type", true, true, dwarfdumpAttributesString);
        groups[7] = level;
        return groups;
    }

    private String matchIntegerAttribute(String fieldName, boolean isHexa, boolean withBrackets, String dwarfdumpObjectString) {
        String result = null;
        String pattern = isHexa ? (withBrackets ? fieldName + "\\s*<0x(\\p{XDigit}+)>\\s*" : fieldName + "\\s*0x(\\p{XDigit}+)\\s*") : fieldName + "\\s*(\\d+)\\s*";
        Matcher matcher = Pattern.compile(pattern, 40).matcher(dwarfdumpObjectString);
        if (matcher.find()) {
            result = matcher.group(1);
        }
        return result;
    }

    private String matchStringAttribute(String fieldName, String dwarfdumpObjectString) {
        String pattern = fieldName + "\\s*(\\w*)\n";
        Matcher matcher = Pattern.compile(pattern, 40).matcher(dwarfdumpObjectString);
        String result = null;
        if (matcher.find()) {
            result = matcher.group(1);
        }
        return result;
    }

    private String matchNbElements(String dwarfdumpObjectString) throws IOException {
        String nbElements = null;
        String upperBound = this.matchIntegerAttribute("DW_AT_upper_bound", false, false, dwarfdumpObjectString);
        String count = this.matchIntegerAttribute("DW_AT_count", true, false, dwarfdumpObjectString);
        if (upperBound != null) {
            nbElements = Integer.toString(Integer.parseInt(upperBound, 16) + 1);
        } else if (count != null) {
            nbElements = count;
        } else {
            throw new IOException("Dwarfdump (Meta EC Tree Generator): size of array at address cannot be found");
        }
        return nbElements;
    }

    private String[] searchType(String typeAddress) throws IOException {
        String currentAddress = typeAddress;
        String typeName = null;
        String nbElements = "1";
        String typeSizeOneElement = null;
        String name = null;
        String address = null;
        block14: while (currentAddress != null) {
            String[] objGroups = this.matchObjectByAddress(currentAddress);
            switch (objGroups[2]) {
                case "DW_TAG_typedef": {
                    if (typeName == null) {
                        typeName = objGroups[3];
                    }
                    currentAddress = objGroups[5];
                    continue block14;
                }
                case "DW_TAG_structure_type": {
                    name = "structure";
                    typeName = objGroups[3];
                    typeSizeOneElement = objGroups[4];
                    address = objGroups[1];
                    currentAddress = null;
                    continue block14;
                }
                case "DW_TAG_union_type": {
                    name = "union";
                    typeName = objGroups[3];
                    typeSizeOneElement = objGroups[4];
                    address = objGroups[1];
                    currentAddress = null;
                    continue block14;
                }
                case "DW_TAG_array_type": {
                    nbElements = this.matchNbElements(objGroups[0]);
                    currentAddress = objGroups[5];
                    continue block14;
                }
                case "DW_TAG_base_type": {
                    typeSizeOneElement = objGroups[4];
                    currentAddress = null;
                    continue block14;
                }
            }
            throw new IOException("Dwarfdump (Meta EC Tree Generator): DW_TAG named \"" + objGroups[2] + " \" is inknown");
        }
        String[] groups = new String[8];
        groups[1] = address;
        groups[3] = name;
        groups[5] = typeName;
        groups[6] = nbElements;
        groups[4] = typeSizeOneElement;
        return groups;
    }

    @Override
    public void close() throws IOException {
        this.dwarfdumpString = null;
    }
}

