/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.observers;

import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransitionComposite;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Exceptions;
import plug.language.emi.observers.EMIObserver;
import plug.language.emi.runtime.EMIRuntime;

public class EMIObserverServer
implements EMIObserver {
    private final EMIRuntime runtime;
    private final CopyOnWriteArrayList<Socket> clients = new CopyOnWriteArrayList();

    public EMIObserverServer(EMIRuntime runtime) {
        this.runtime = runtime;
        Runnable _function = () -> {
            try {
                ServerSocket server = new ServerSocket(12347);
                boolean started = false;
                while (true) {
                    Socket _accept = server.accept();
                    this.clients.add(_accept);
                    if (started) continue;
                    runtime.addEMIObserver(this);
                    started = true;
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        Thread thread = new Thread(_function);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void configurationChanged(EMIConfiguration configuration) {
        Consumer<Socket> _function = it -> {
            boolean _isClosed = it.isClosed();
            if (_isClosed) {
                this.clients.remove(it);
            } else {
                try {
                    OutputStream _outputStream = it.getOutputStream();
                    DataOutputStream out = new DataOutputStream(_outputStream);
                    out.write(1);
                    ByteBuffer _data = configuration.getData();
                    int _limit = _data.limit();
                    out.writeInt(_limit);
                    WritableByteChannel _newChannel = Channels.newChannel(out);
                    ByteBuffer _data_1 = configuration.getData();
                    _newChannel.write(_data_1);
                    out.flush();
                    InputStream _inputStream = it.getInputStream();
                    _inputStream.read();
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception exception = (Exception)_t;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        this.clients.forEach(_function);
    }

    @Override
    public void fireablesChanged(List<EMIFireableTransitionComposite> fireableTransitions) {
    }

    @Override
    public void firedChanged(EMIFireableTransitionComposite firedTransition) {
    }
}

