/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer;

import emi.serializer.identifiers.IdentifiersSerializer;
import emi.serializer.metamodel.MetamodelSerializer;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.metamodel.OffsetsTableStrategy;
import emi.serializer.model.ModelLoader;
import emi.serializer.model.ModelSerializer;
import emi.serializer.types.Types;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Main {
    public static void main(String[] args) {
        try {
            boolean _not_2;
            boolean _not_1;
            boolean _equals_1;
            boolean _not;
            String inFile;
            File umlModelFile;
            if (args.length < 1 || args.length > 2) {
                System.err.println("error: This program expects as parameters the model to serialize and the output directory (optional parameter)");
                System.exit(1);
            }
            if (!(umlModelFile = new File(inFile = args[0])).exists() || !umlModelFile.isFile()) {
                System.err.println("error: " + inFile + " is not a file");
                System.exit(1);
            }
            String model = inFile.replaceAll(".*/", "");
            String modelName = model.replaceAll("\\..*", "");
            String modelExtension = model.replaceAll(".*\\.", "");
            boolean _equals = modelExtension.equals("uml");
            boolean bl = _not = !_equals;
            if (_not) {
                System.err.println("error: The input model is not a UML model. Extension is ." + modelExtension + " but expected .uml");
                System.exit(1);
            }
            File emiModelDir = null;
            int _length = args.length;
            boolean bl2 = _equals_1 = _length == 2;
            if (_equals_1) {
                File _file;
                String inOutputDir = args[1];
                File inOutputDirFile = new File(inOutputDir);
                if (!inOutputDirFile.exists() || !inOutputDirFile.isDirectory()) {
                    System.err.println("error: " + inOutputDir + " is not a directory");
                    System.exit(1);
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)inOutputDir, "");
                _builder.append((Object)"/");
                _builder.append((Object)modelName, "");
                _builder.append((Object)".emi");
                emiModelDir = _file = new File(_builder.toString());
            }
            if (emiModelDir == null) {
                File _file_1;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)modelName, "");
                _builder_1.append((Object)".emi");
                emiModelDir = _file_1 = new File(_builder_1.toString());
            }
            emiModelDir.mkdir();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)emiModelDir, "");
            _builder_2.append((Object)"/");
            _builder_2.append((Object)"atoms/", "");
            File emiModelAtomsDir = new File(_builder_2.toString());
            emiModelAtomsDir.mkdir();
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)emiModelDir, "");
            _builder_3.append((Object)"/src");
            File emiModelSrcDir = new File(_builder_3.toString());
            emiModelSrcDir.mkdir();
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append((Object)emiModelDir, "");
            _builder_4.append((Object)"/uml");
            File emiModelUmlDir = new File(_builder_4.toString());
            emiModelUmlDir.mkdir();
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append((Object)emiModelDir, "");
            _builder_5.append((Object)"/plug-config");
            File emiModelConfigDir = new File(_builder_5.toString());
            emiModelConfigDir.mkdir();
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append((Object)emiModelSrcDir, "");
            _builder_6.append((Object)"/model.c");
            String outFileModelC = _builder_6.toString();
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append((Object)emiModelSrcDir, "");
            _builder_7.append((Object)"/model.h");
            String outFileModelH = _builder_7.toString();
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append((Object)emiModelSrcDir, "");
            _builder_8.append((Object)"/types_calibration.h");
            String outFileTypes = _builder_8.toString();
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append((Object)emiModelSrcDir, "");
            _builder_9.append((Object)"/metamodel.h");
            String outFileMetamodelH = _builder_9.toString();
            StringConcatenation _builder_10 = new StringConcatenation();
            _builder_10.append((Object)emiModelSrcDir, "");
            _builder_10.append((Object)"/metamodel.c");
            String outFileMetamodelC = _builder_10.toString();
            StringConcatenation _builder_11 = new StringConcatenation();
            _builder_11.append((Object)emiModelSrcDir, "");
            _builder_11.append((Object)"/identifiers.h");
            String outFileIdentifiers = _builder_11.toString();
            ModelLoader modelLoader = new ModelLoader();
            Resource r = modelLoader.load(inFile);
            MetamodelTable metamodelTable = new MetamodelTable();
            metamodelTable.generate();
            OffsetsTableStrategy strategy = new OffsetsTableStrategy(metamodelTable);
            ModelSerializer modelSerializer = new ModelSerializer(r, metamodelTable, strategy);
            MetamodelSerializer metamodelSerializer = new MetamodelSerializer(r, metamodelTable, strategy);
            Types typesSerializer = new Types(r);
            IdentifiersSerializer identifiersSerializer = new IdentifiersSerializer(r);
            String sMetamodelC = metamodelSerializer.serialize();
            String sMetamodelH = metamodelSerializer.serializeHeaders();
            String sModelC = modelSerializer.serialize();
            String sModelH = modelSerializer.serializeHeaders();
            String sTypes = typesSerializer.serialize();
            String sIdentifiers = identifiersSerializer.serialize();
            Main.writeInFile(outFileMetamodelH, sMetamodelH);
            Main.writeInFile(outFileMetamodelC, sMetamodelC);
            Main.writeInFile(outFileModelC, sModelC);
            Main.writeInFile(outFileModelH, sModelH);
            Main.writeInFile(outFileTypes, sTypes);
            Main.writeInFile(outFileIdentifiers, sIdentifiers);
            Class<?> _class = Main.class.getClass();
            InputStream makefileEmi = _class.getResourceAsStream("/makefiles/Makefile");
            StringConcatenation _builder_12 = new StringConcatenation();
            String _canonicalPath = emiModelDir.getCanonicalPath();
            _builder_12.append((Object)_canonicalPath, "");
            _builder_12.append((Object)"/Makefile");
            File emiModelDirMakefile = new File(_builder_12.toString());
            Path _path = emiModelDirMakefile.toPath();
            Files.copy(makefileEmi, _path, StandardCopyOption.REPLACE_EXISTING);
            Class<?> _class_1 = Main.class.getClass();
            InputStream makefileConfig = _class_1.getResourceAsStream("/makefiles/Makefile.config");
            StringConcatenation _builder_13 = new StringConcatenation();
            String _canonicalPath_1 = emiModelDir.getCanonicalPath();
            _builder_13.append((Object)_canonicalPath_1, "");
            _builder_13.append((Object)"/Makefile.config");
            File emiModelDirMakefileConfig = new File(_builder_13.toString());
            boolean _exists = emiModelDirMakefileConfig.exists();
            boolean bl3 = _not_1 = !_exists;
            if (_not_1) {
                Path _path_1 = emiModelDirMakefileConfig.toPath();
                Files.copy(makefileConfig, _path_1, StandardCopyOption.REPLACE_EXISTING);
            }
            Class<?> _class_2 = Main.class.getClass();
            InputStream makefileSrc = _class_2.getResourceAsStream("/makefiles/src/Makefile");
            StringConcatenation _builder_14 = new StringConcatenation();
            String _canonicalPath_2 = emiModelSrcDir.getCanonicalPath();
            _builder_14.append((Object)_canonicalPath_2, "");
            _builder_14.append((Object)"/Makefile");
            File emiModelSrcDirMakefile = new File(_builder_14.toString());
            Path _path_2 = emiModelSrcDirMakefile.toPath();
            Files.copy(makefileSrc, _path_2, StandardCopyOption.REPLACE_EXISTING);
            Class<?> _class_3 = Main.class.getClass();
            InputStream makefileAtoms = _class_3.getResourceAsStream("/makefiles/atoms/Makefile");
            StringConcatenation _builder_15 = new StringConcatenation();
            String _canonicalPath_3 = emiModelAtomsDir.getCanonicalPath();
            _builder_15.append((Object)_canonicalPath_3, "");
            _builder_15.append((Object)"/Makefile");
            File emiModelAtomsDirMakefile = new File(_builder_15.toString());
            Path _path_3 = emiModelAtomsDirMakefile.toPath();
            Files.copy(makefileAtoms, _path_3, StandardCopyOption.REPLACE_EXISTING);
            StringConcatenation _builder_16 = new StringConcatenation();
            String _canonicalPath_4 = emiModelUmlDir.getCanonicalPath();
            _builder_16.append((Object)_canonicalPath_4, "");
            _builder_16.append((Object)"/");
            _builder_16.append((Object)modelName, "");
            _builder_16.append((Object)".uml");
            File emiModelUmlDirModel = new File(_builder_16.toString());
            Path _path_4 = umlModelFile.toPath();
            Path _path_5 = emiModelUmlDirModel.toPath();
            Files.copy(_path_4, _path_5, StandardCopyOption.REPLACE_EXISTING);
            Class<?> _class_4 = Main.class.getClass();
            InputStream plugConfig = _class_4.getResourceAsStream("/config/config.emi");
            StringConcatenation _builder_17 = new StringConcatenation();
            String _canonicalPath_5 = emiModelConfigDir.getCanonicalPath();
            _builder_17.append((Object)_canonicalPath_5, "");
            _builder_17.append((Object)"/config.emi");
            File emiModelConfigDirPlug = new File(_builder_17.toString());
            boolean _exists_1 = emiModelConfigDirPlug.exists();
            boolean bl4 = _not_2 = !_exists_1;
            if (_not_2) {
                Path _path_6 = emiModelConfigDirPlug.toPath();
                Files.copy(plugConfig, _path_6, StandardCopyOption.REPLACE_EXISTING);
                String emiHome = System.getenv("EMI_HOME");
                if (emiHome != null) {
                    Main.updateProperty(emiModelConfigDirPlug, "emiHome", emiHome);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void writeInFile(String filename, String s) {
        try {
            FileOutputStream _fileOutputStream = new FileOutputStream(filename);
            PrintStream file = new PrintStream(_fileOutputStream);
            file.print(s);
            file.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void updateProperty(File file, String key, String value) {
        try {
            String _canonicalPath = file.getCanonicalPath();
            Path _get = Paths.get(_canonicalPath, new String[0]);
            byte[] _readAllBytes = Files.readAllBytes(_get);
            String content = new String(_readAllBytes);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)key, "");
            _builder.append((Object)"=");
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)key, "");
            _builder_1.append((Object)"=");
            _builder_1.append((Object)value, "");
            String newContent = content.replaceFirst(_builder.toString(), _builder_1.toString());
            FileWriter output = new FileWriter(file);
            output.write(newContent);
            output.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

