@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  obp2_emi startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and OBP2_EMI_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-Dapple.laf.useScreenMenuBar=true"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\obp2_emi-0.0.7.jar;%APP_HOME%\lib\plug-runtime-via-tcp-0.0.7.jar;%APP_HOME%\lib\emi-analysis-0.9.4.jar;%APP_HOME%\lib\emi-serializer-c-0.9.4.jar;%APP_HOME%\lib\plug-core-ui-0.0.7.jar;%APP_HOME%\lib\plug-runtime-buchikripke-0.0.7.jar;%APP_HOME%\lib\plug-runtime-buchi-0.0.7.jar;%APP_HOME%\lib\javax.json-1.1.4.jar;%APP_HOME%\lib\plug-core-0.0.7.jar;%APP_HOME%\lib\org.eclipse.xtend.lib-2.10.0.jar;%APP_HOME%\lib\org.eclipse.emf.mapping.ecore2xml-2.11.0.jar;%APP_HOME%\lib\LTL-0.0.7.jar;%APP_HOME%\lib\BuchiAutomata-0.0.7.jar;%APP_HOME%\lib\LPropositionalLogic-0.0.7.jar;%APP_HOME%\lib\org.eclipse.emf.ecore.xmi-2.15.0.jar;%APP_HOME%\lib\org.eclipse.emf.ecore-2.15.0.jar;%APP_HOME%\lib\org.eclipse.emf.common-2.15.0.jar;%APP_HOME%\lib\org.eclipse.uml2.common-2.0.1.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.uml2.types-2.0.0.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.uml2.uml-5.0.2.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.uml2.uml.profile.standard-1.0.0.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.uml2.uml.resources-5.0.2.v20150202-0947.jar;%APP_HOME%\lib\org.eclipse.xtend.lib.macro-2.10.0.jar;%APP_HOME%\lib\org.eclipse.xtext.xbase.lib-2.10.0.jar;%APP_HOME%\lib\guava-27.0.1-jre.jar;%APP_HOME%\lib\args4j-2.33.jar;%APP_HOME%\lib\jackson-databind-2.7.2.jar;%APP_HOME%\lib\announce4j-master.jar;%APP_HOME%\lib\plug-utils-fx-0.0.7.jar;%APP_HOME%\lib\ikonli-javafx-2.1.1.jar;%APP_HOME%\lib\ikonli-material-pack-2.1.1.jar;%APP_HOME%\lib\ikonli-typicons-pack-2.1.1.jar;%APP_HOME%\lib\richtextfx-0.9.0.jar;%APP_HOME%\lib\flowless-0.6.1.jar;%APP_HOME%\lib\controlsfx-8.40.14.jar;%APP_HOME%\lib\plug-utils-0.0.7.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\checker-qual-2.5.2.jar;%APP_HOME%\lib\error_prone_annotations-2.2.0.jar;%APP_HOME%\lib\j2objc-annotations-1.1.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.17.jar;%APP_HOME%\lib\LTL3BA-0.0.7.jar;%APP_HOME%\lib\antlr4-4.5.3.jar;%APP_HOME%\lib\jackson-annotations-2.7.0.jar;%APP_HOME%\lib\jackson-core-2.7.2.jar;%APP_HOME%\lib\ikonli-core-2.1.1.jar;%APP_HOME%\lib\undofx-2.0.0.jar;%APP_HOME%\lib\reactfx-2.0-M5.jar;%APP_HOME%\lib\wellbehavedfx-0.3.3.jar

@rem Execute obp2_emi
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %OBP2_EMI_OPTS%  -classpath "%CLASSPATH%" plug.ui2.PlugUI %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable OBP2_EMI_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%OBP2_EMI_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
