/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import plug.core.ILanguagePlugin;
import plug.core.fx.IAppContext;
import plug.core.registry.LanguageModuleRegistry;
import plug.ui2.execution_units.ExecutionListView;
import plug.ui2.model_view.ModelEditor;
import plug.utils.file.FileWatcher;

public class VerificationMainView
extends VBox {
    ObjectProperty<Path> modelPath = new SimpleObjectProperty();
    ObjectProperty<Path> propertiesPath = new SimpleObjectProperty();
    BooleanProperty modelChanged = new SimpleBooleanProperty(false);
    BooleanProperty propertiesChanged = new SimpleBooleanProperty(false);
    FileWatcher watcher;

    public VerificationMainView(IAppContext appContext) {
        this.watcher = appContext.getFileWatcher();
        this.modelPath.addListener(this::modelChangedCallback);
        this.propertiesPath.addListener(this::propertiesChangedCallback);
        ModelEditor modelUnderVerificationView = new ModelEditor("Model", this.modelPath, this.modelChanged, this.modelExtensionFilters());
        ModelEditor propertiesView = new ModelEditor("Properties", this.propertiesPath, this.propertiesChanged, Collections.singleton(new FileChooser.ExtensionFilter("GPSL", new String[]{"*.gpsl"})));
        ExecutionListView executionListView = new ExecutionListView(this.modelPath, this.propertiesPath, this.modelChanged, this.propertiesChanged, appContext);
        SplitPane bottomPane = new SplitPane();
        bottomPane.setOrientation(Orientation.HORIZONTAL);
        bottomPane.getItems().addAll((Object[])new Node[]{executionListView, propertiesView});
        SplitPane mainView = new SplitPane(new Node[]{modelUnderVerificationView, bottomPane});
        mainView.setOrientation(Orientation.VERTICAL);
        this.getChildren().addAll((Object[])new Node[]{mainView});
    }

    public void modelChangedCallback(ObservableValue<? extends Path> obj, Path oldP, Path newP) {
        this.watcher.removePathListener(oldP);
        this.watcher.addOnContentChange(newP, c -> Platform.runLater(() -> this.modelChanged.set(!this.modelChanged.get())));
    }

    public void propertiesChangedCallback(ObservableValue<? extends Path> obj, Path oldP, Path newP) {
        this.watcher.removePathListener(oldP);
        this.watcher.addOnContentChange(newP, c -> Platform.runLater(() -> this.propertiesChanged.set(!this.propertiesChanged.get())));
    }

    public Collection<FileChooser.ExtensionFilter> modelExtensionFilters() {
        ArrayList<FileChooser.ExtensionFilter> extensionFilters = new ArrayList<FileChooser.ExtensionFilter>();
        for (ILanguagePlugin languageModule : LanguageModuleRegistry.getInstance().getModules()) {
            if (languageModule.getName().equals("Buchi")) continue;
            List extensions = Stream.of(languageModule.getExtensions()).map(e -> "*" + e).collect(Collectors.toList());
            extensionFilters.add(new FileChooser.ExtensionFilter(languageModule.getName(), extensions));
        }
        return extensionFilters;
    }
}

