/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.interpreter;

import java.util.HashMap;
import java.util.Map;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;
import properties.PropositionalLogic.interpreter.atom.AlwaysFalseAtomEvaluator;

public class AtomEvaluatorDispatcher {
    Map<String, CompiledAtom> atomCache = new HashMap<String, CompiledAtom>();
    Map<String, IAtomEvaluator> evaluatorMap = new HashMap<String, IAtomEvaluator>();
    IAtomEvaluator defaultEvaluator = new AlwaysFalseAtomEvaluator();

    public void addEvaluator(String language, IAtomEvaluator evaluator) {
        this.evaluatorMap.put(language, evaluator);
    }

    public void setDefaultEvaluator(IAtomEvaluator evaluator) {
        this.defaultEvaluator = evaluator;
    }

    public boolean evaluate(Atom atom) {
        String key = this.cacheKey(atom);
        CompiledAtom compiledAtom = this.atomCache.get(key);
        if (compiledAtom == null) {
            compiledAtom = this.compile(atom);
            this.atomCache.put(key, compiledAtom);
        }
        return compiledAtom.evaluator.evaluate(compiledAtom.atomModel);
    }

    private CompiledAtom compile(Atom atom) {
        IAtomEvaluator concreteEvaluator = this.evaluatorMap.get(atom.getLanguage());
        if (concreteEvaluator == null) {
            concreteEvaluator = this.defaultEvaluator;
        }
        CompiledAtom cA = new CompiledAtom();
        cA.atomModel = concreteEvaluator.parse(atom.getCode());
        cA.evaluator = concreteEvaluator;
        return cA;
    }

    private String cacheKey(Atom atom) {
        return atom.getLanguage() + "|" + atom.getCode();
    }

    private class CompiledAtom {
        public IAtomEvaluator evaluator;
        public Object atomModel;

        private CompiledAtom() {
        }
    }
}

