/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.types;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import emi.serializer.memoryobjects.Peers;
import emi.serializer.model.PartClassifierInstance;
import emi.serializer.utils.UmlNavigation;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.BodyOwner;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Types {
    private final int NB_EXECUTION_STEPS = 65535;
    private final int NB_FIREABLES_SUM = 65535;
    private final int NB_FIREABLES = 65535;
    private final int EVENT_POOL_SIZE = 32;
    private final int EVENT_SET_SIZE = 32;
    private final int BITS_FIELD_SIZE = 65535;
    private final int NB_INPUTS_PM = 255;
    private final int NB_OUTPUTS_PM = 255;
    private final int NB_ATOMS = 10;
    private final int ATOM_SIZE = 2048;
    private final int NB_COMMANDS = 255;
    private final int COMMAND_SIZE = 65535;
    private final int CURRENT_STATE_SIZE = 4;
    private final int EVENT_SIZE = 4;
    private final int ATTRIBUTE_SIZE = 4;
    private final int NB_FIFO_LAYERS = 3;
    private final int NB_FIFO_ELEMENTS = 3;
    private final Resource emfModel;

    public Types(Resource r) {
        this.emfModel = r;
    }

    private String getIntType(int max, boolean signed) {
        String _xblockexpression = null;
        String string = null;
        string = signed ? (max <= 127 ? "int8_t  " : (max <= Short.MAX_VALUE ? "int16_t " : "int32_t ")) : (max <= 255 ? "uint8_t " : (max <= 65535 ? "uint16_t" : "uint32_t"));
        _xblockexpression = string;
        return _xblockexpression;
    }

    private int sum(Iterable<Integer> iterable) {
        int _xblockexpression = 0;
        int sum = 0;
        List list = IterableExtensions.toList(iterable);
        for (int i = 0; i < list.size(); ++i) {
            int _sum = sum;
            Integer _get = (Integer)list.get(i);
            sum = _sum + _get;
        }
        _xblockexpression = sum;
        return _xblockexpression;
    }

    private int sum(Iterator<Integer> iterator) {
        int _xblockexpression = 0;
        int sum = 0;
        while (iterator.hasNext()) {
            int _sum = sum;
            Integer _next = iterator.next();
            sum = _sum + _next;
        }
        _xblockexpression = sum;
        return _xblockexpression;
    }

    private String serializeMetamodelTypes() {
        boolean _notEquals;
        boolean _not;
        String _xblockexpression = null;
        Functions.Function1 _function = it -> it.getOwnedAttributes().size();
        Integer nbOwnedAttributes = (Integer)IteratorExtensions.max((Iterator)IteratorExtensions.map(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)this.emfModel.getAllContents(), Class.class), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> it instanceof OpaqueBehavior || it instanceof OpaqueExpression;
        List opaques = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)this.emfModel.getAllContents(), (Functions.Function1)_function_1));
        int nbMaxLanguages = 0;
        int nbMaxBodies = 0;
        boolean _isEmpty = opaques.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function_2 = it -> ((Object[])Conversions.unwrapArray((Object)((BodyOwner)it).getLanguages(), Object.class)).length;
            nbMaxLanguages = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)opaques, (Functions.Function1)_function_2));
            Functions.Function1 _function_3 = it -> ((Object[])Conversions.unwrapArray((Object)((BodyOwner)it).getBodies(), Object.class)).length;
            nbMaxBodies = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)opaques, (Functions.Function1)_function_3));
        }
        Functions.Function1 _function_4 = it -> ((Object[])Conversions.unwrapArray(UmlNavigation.getAttributesNotPeers((Classifier)it), Object.class)).length;
        Integer nbPrimitiveAttributes = (Integer)IteratorExtensions.max((Iterator)IteratorExtensions.map(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)this.emfModel.getAllContents(), Class.class), (Functions.Function1)_function_4));
        Functions.Function1 _function_5 = it -> it.getRegions().size();
        Integer nbMaxRegions = (Integer)IteratorExtensions.max((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this.emfModel.getAllContents(), StateMachine.class), (Functions.Function1)_function_5));
        Functions.Function1 _function_6 = it -> it.getRegions();
        List regions = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this.emfModel.getAllContents(), StateMachine.class), (Functions.Function1)_function_6));
        Functions.Function1 _function_7 = it -> {
            Functions.Function1 _function_8 = it_1 -> it_1.getSubvertices().size();
            return this.sum(ListExtensions.map((List)it, (Functions.Function1)_function_8));
        };
        Integer nbMaxStates = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)regions, (Functions.Function1)_function_7));
        Functions.Function1 _function_8 = it -> {
            Functions.Function1 _function_9 = it_1 -> it_1.getTransitions().size();
            return this.sum(ListExtensions.map((List)it, (Functions.Function1)_function_9));
        };
        Integer nbMaxTransitions = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)regions, (Functions.Function1)_function_8));
        Functions.Function1 _function_9 = it -> it.getTriggers().size();
        Integer nbMaxTriggers = (Integer)IteratorExtensions.max((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this.emfModel.getAllContents(), Transition.class), (Functions.Function1)_function_9));
        int nbSignalEvents = ((Object[])Conversions.unwrapArray(UmlNavigation.getSignalEvents(this.emfModel), Object.class)).length;
        List enumerations = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)this.emfModel.getAllContents(), Enumeration.class));
        int nbMaxEnumerationLiterals = 0;
        int _size = enumerations.size();
        boolean bl2 = _notEquals = _size != 0;
        if (_notEquals) {
            Functions.Function1 _function_10 = it -> it.getOwnedLiterals().size();
            nbMaxEnumerationLiterals = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)enumerations, (Functions.Function1)_function_10));
        }
        Functions.Function1 _function_11 = it -> it.getInterfaceRealizations().size();
        Integer nbInterfaceRealizations = (Integer)IteratorExtensions.max((Iterator)IteratorExtensions.map(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)this.emfModel.getAllContents(), Class.class), (Functions.Function1)_function_11));
        Functions.Function1 _function_12 = it -> it.getOwnedReceptions();
        List receptions = IteratorExtensions.toList((Iterator)IteratorExtensions.map(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)this.emfModel.getAllContents(), Class.class), (Functions.Function1)_function_12));
        Functions.Function1 _function_13 = it -> it.getOwnedReceptions();
        receptions.addAll(IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this.emfModel.getAllContents(), Interface.class), (Functions.Function1)_function_13)));
        Functions.Function1 _function_14 = it -> ((Object[])Conversions.unwrapArray((Object)it, Object.class)).length;
        Integer nbReceptions = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)receptions, (Functions.Function1)_function_14));
        Functions.Function1 _function_15 = it -> it.getEnds();
        List connectorEnds = IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this.emfModel.getAllContents(), Connector.class), (Functions.Function1)_function_15));
        Functions.Function1 _function_16 = it -> it.getEnds();
        connectorEnds.addAll(IteratorExtensions.toList((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this.emfModel.getAllContents(), Property.class), (Functions.Function1)_function_16)));
        Functions.Function1 _function_17 = it -> ((Object[])Conversions.unwrapArray((Object)it, Object.class)).length;
        Integer nbConnectorEnds = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)connectorEnds, (Functions.Function1)_function_17));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the metamodel.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        String _intType = this.getIntType(nbOwnedAttributes, false);
        _builder.append(_intType);
        _builder.append(" NbOwnedAttributes_t;\t// Number of ownedAttributes per class");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_1 = this.getIntType(nbMaxLanguages, false);
        _builder.append(_intType_1);
        _builder.append(" NbLanguages_t;\t\t\t// Number of languages in OpaqueBehaviors or OpaqueExpressions");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_2 = this.getIntType(nbMaxBodies, false);
        _builder.append(_intType_2);
        _builder.append(" NbBodies_t;\t\t\t// Number of bodies in OpaqueBehaviors or OpaqueExpressions");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_3 = this.getIntType(nbPrimitiveAttributes, false);
        _builder.append(_intType_3);
        _builder.append(" NbPrimitiveTypeProperties_t;\t// Number of primitives type properties per class");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_4 = this.getIntType(nbMaxRegions, false);
        _builder.append(_intType_4);
        _builder.append(" NbRegions_t;\t\t\t// Number of regions per state machine");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_5 = this.getIntType(nbMaxTransitions, false);
        _builder.append(_intType_5);
        _builder.append(" NbTransitions_t;\t\t// Number of transitions per state machine");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_6 = this.getIntType(nbMaxTransitions, false);
        _builder.append(_intType_6);
        _builder.append(" NbOutgoingTransitions_t;\t\t// Number of outgoing transitions per state");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_7 = this.getIntType(nbMaxTriggers, false);
        _builder.append(_intType_7);
        _builder.append(" NbTriggers_t;\t\t\t// Number of triggers per transition");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_8 = this.getIntType(nbMaxStates, true);
        _builder.append(_intType_8);
        _builder.append(" NbStates_t;\t\t\t// Number of states per state machine (signed to handle errors with -1 as error code)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_9 = this.getIntType(nbMaxEnumerationLiterals, false);
        _builder.append(_intType_9);
        _builder.append(" NbEnumerationLiteral_t; // Number of EnumerationLiterals in an Enumeration");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_10 = this.getIntType(nbSignalEvents + 1, false);
        _builder.append(_intType_10);
        _builder.append(" NbSignalEvents_t;\t\t// Number of signal events (+1 in order to reserve the maximum value for 'no signal event'");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_11 = this.getIntType(nbInterfaceRealizations, false);
        _builder.append(_intType_11);
        _builder.append(" NbInterfaceRealizations_t;\t\t\t// Number of interface realizations");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_12 = this.getIntType(nbReceptions, false);
        _builder.append(_intType_12);
        _builder.append(" NbReceptions_t;\t\t\t// Number of receptions per class or interface");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_13 = this.getIntType(nbConnectorEnds, false);
        _builder.append(_intType_13);
        _builder.append(" NbConnectorEnds_t;\t// Number of connector ends per connector or property");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String serializeInterpreterTypes() {
        String _xblockexpression = null;
        int nbActiveObjects = IterableExtensions.size(UmlNavigation.getActiveObjects(this.emfModel));
        int nbPassiveObjects = IterableExtensions.size(UmlNavigation.getPassiveObjects(this.emfModel));
        int nbObjects = nbActiveObjects + nbPassiveObjects;
        Functions.Function1 _function = it -> UmlNavigation.getPrimitiveAttributes(it).size();
        int nbPrimitiveAttributes = this.sum(IteratorExtensions.map(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)this.emfModel.getAllContents(), Class.class), (Functions.Function1)_function));
        this.getClass();
        this.getClass();
        this.getClass();
        this.getClass();
        int storeSize = nbActiveObjects * 4 + nbActiveObjects * 4 * 32 + nbPrimitiveAttributes * 4;
        Functions.Function1 _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> {
                PseudostateKind _kind = it_1.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.JUNCTION_LITERAL);
            };
            return ((Object[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)it.getSubvertices(), Pseudostate.class), (Functions.Function1)_function_2), Object.class)).length;
        };
        Integer nbJunctions = (Integer)IteratorExtensions.max((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this.emfModel.getAllContents(), Region.class), (Functions.Function1)_function_1));
        List<PartClassifierInstance> parts = UmlNavigation.collectPartClassifierInstance(this.emfModel);
        Peers peers = new Peers(this.emfModel);
        Functions.Function1 _function_2 = it -> {
            Classifier _classifier = it.getClassifier();
            return ((Object[])Conversions.unwrapArray(peers.getAllPeers((Class)_classifier), Object.class)).length;
        };
        Integer nbPeers = (Integer)IterableExtensions.max((Iterable)ListExtensions.map(parts, (Functions.Function1)_function_2));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the interpreter.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        String _intType = this.getIntType(nbActiveObjects, false);
        _builder.append(_intType);
        _builder.append(" NbActiveObjects_t;\t\t// Number of active objects");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_1 = this.getIntType(nbPassiveObjects, false);
        _builder.append(_intType_1);
        _builder.append(" NbPassiveObjects_t;\t\t// Number of passive objects");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_2 = this.getIntType(nbObjects, false);
        _builder.append(_intType_2);
        _builder.append(" NbObjects_t;\t\t// Number of objects");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef\t");
        this.getClass();
        String _intType_3 = this.getIntType(65535, false);
        _builder.append(_intType_3);
        _builder.append(" NbExecutionSteps_t;\t// Number of execution steps (limit)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef\t");
        this.getClass();
        String _intType_4 = this.getIntType(65535, false);
        _builder.append(_intType_4);
        _builder.append(" NbFireablesSum_t;\t\t// Number of fireable transitions in a configuration");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef\t");
        this.getClass();
        String _intType_5 = this.getIntType(65535, false);
        _builder.append(_intType_5);
        _builder.append(" NbFireables_t;\t\t\t// Number of fireable transitions per active object");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_6 = this.getIntType(storeSize, false);
        _builder.append(_intType_6);
        _builder.append(" StoreSize_t;\t\t\t// Size of the store");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_7 = this.getIntType(nbJunctions, false);
        _builder.append(_intType_7);
        _builder.append(" NbJunctions_t; \t// Number of junction pseudostates per active object.");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_8 = this.getIntType(nbPeers, false);
        _builder.append(_intType_8);
        _builder.append(" NbPeers_t; \t// Number of peers per active object.");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_9 = this.getIntType(3, false);
        _builder.append(_intType_9);
        _builder.append(" NbFifoLayers_t; \t// Number of layers per fifo.");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_10 = this.getIntType(3, false);
        _builder.append(_intType_10);
        _builder.append(" NbFifoElements_t; \t// Number of elements per fifo.");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String serializeEventPoolTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for event pools.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        this.getClass();
        String _intType = this.getIntType(32, false);
        _builder.append(_intType);
        _builder.append(" NbEvents_t;\t\t\t// Number of events on event pool");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_1 = this.getIntType(32, false);
        _builder.append(_intType_1);
        _builder.append(" EventSetSize_t;\t\t// Size of the event set (= Number of receptions)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_2 = this.getIntType(65535, false);
        _builder.append(_intType_2);
        _builder.append(" BitsField_t;\t\t\t// Type of the bits field");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String serializeDeploymentTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the deployment.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        this.getClass();
        String _intType = this.getIntType(255, false);
        _builder.append(_intType);
        _builder.append(" NbOutputsPM_t;\t\t\t// Number of outputs for the peripheral mapping");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_1 = this.getIntType(255, false);
        _builder.append(_intType_1);
        _builder.append(" NbInputsPM_t;\t\t\t// Number of inputs for the peripheral mapping");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String serializeCheckerTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the checker.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        String _intType = this.getIntType(this.NB_ATOMS, true);
        _builder.append(_intType);
        _builder.append(" NbAtoms_t;\t\t// Number of atoms that can be checked (signed to handle errors with -1 as error code)");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        String _intType_1 = this.getIntType(this.ATOM_SIZE, false);
        _builder.append(_intType_1);
        _builder.append(" AtomSize_t;\t// Size of an atom");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String serializePilotTypes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Types for the pilot.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef ");
        this.getClass();
        String _intType = this.getIntType(255, false);
        _builder.append(_intType);
        _builder.append(" NbCommands_t;\t\t\t// Number of commands");
        _builder.newLineIfNotEmpty();
        _builder.append("typedef ");
        this.getClass();
        String _intType_1 = this.getIntType(65535, false);
        _builder.append(_intType_1);
        _builder.append(" CommandSize_t;\t\t\t// Size of a command");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef MODELS_MODEL_TYPES_H");
        _builder.newLine();
        _builder.append("#define MODELS_MODEL_TYPES_H");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file types_calibration.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define all data types according to the model size.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <stdint.h>");
        _builder.newLine();
        _builder.newLine();
        String _serializeMetamodelTypes = this.serializeMetamodelTypes();
        _builder.append(_serializeMetamodelTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeInterpreterTypes = this.serializeInterpreterTypes();
        _builder.append(_serializeInterpreterTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeEventPoolTypes = this.serializeEventPoolTypes();
        _builder.append(_serializeEventPoolTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeDeploymentTypes = this.serializeDeploymentTypes();
        _builder.append(_serializeDeploymentTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeCheckerTypes = this.serializeCheckerTypes();
        _builder.append(_serializeCheckerTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializePilotTypes = this.serializePilotTypes();
        _builder.append(_serializePilotTypes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#endif /* MODELS_MODEL_TYPES_H */");
        _builder.newLine();
        return _builder.toString();
    }
}

