/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.symbols;

import com.google.common.collect.Iterators;
import emi.serializer.symbols.SymbolClass;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SymbolTable {
    private final List<String> flatActiveObjectsName;
    private final Map<String, SymbolClass> symbolClasses;
    private final Map<String, String> flatMappingObjectsClasses;
    private final Map<String, SignalEvent> symbolEvents;

    public SymbolTable(Resource r) {
        this.flatActiveObjectsName = this.generateFlatActiveObjectsName(r);
        this.symbolClasses = this.generateSymbolClasses(r);
        this.flatMappingObjectsClasses = this.generateFlatMappingWithObjects(r);
        this.symbolEvents = this.generateSymbolEvents(r);
    }

    private List<String> generateFlatActiveObjectsName(Resource r) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> objetsSymbols = new ArrayList<String>();
        Functions.Function1 _function = it -> it.getPart();
        List objects = ListExtensions.map(UmlNavigation.collectPartClassifierInstance(r), (Functions.Function1)_function);
        Consumer<Property> _function_1 = it -> {
            boolean _equals;
            String name = it.getName();
            int _lower = it.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                objetsSymbols.add(name);
            } else {
                int _lower_1 = it.getLower();
                int _minus = _lower_1 - 1;
                Consumer<Integer> _function_2 = it_1 -> objetsSymbols.add(name + "_" + it_1);
                new IntegerRange(0, _minus).forEach(_function_2);
            }
        };
        objects.forEach(_function_1);
        _xblockexpression = objetsSymbols;
        return _xblockexpression;
    }

    private Map<String, SymbolClass> generateSymbolClasses(Resource r) {
        HashMap<String, SymbolClass> _xblockexpression = null;
        HashMap<String, SymbolClass> symbolClasses = new HashMap<String, SymbolClass>();
        Functions.Function1 _function = it -> {
            boolean _equals = it.getName().equals("SUS");
            return !_equals;
        };
        Procedures.Procedure1 _function_1 = it -> {
            String _name = it.getName();
            SymbolClass _symbolClass = new SymbolClass((Class)it, r);
            symbolClasses.put(_name, _symbolClass);
        };
        IteratorExtensions.forEach((Iterator)IteratorExtensions.filter(emi.serializer.utils.IteratorExtensions.filterExact((Iterator<? super EObject>)r.getAllContents(), Class.class), (Functions.Function1)_function), (Procedures.Procedure1)_function_1);
        _xblockexpression = symbolClasses;
        return _xblockexpression;
    }

    private Map<String, String> generateFlatMappingWithObjects(Resource r) {
        HashMap<String, String> _xblockexpression = null;
        HashMap<String, String> objetsSymbols = new HashMap<String, String>();
        Functions.Function1 _function = it -> it.getPart();
        List objects = ListExtensions.map(UmlNavigation.collectPartClassifierInstance(r), (Functions.Function1)_function);
        Consumer<Property> _function_1 = it -> {
            boolean _equals;
            String name = it.getName();
            String typeName = it.getType().getName();
            int _lower = it.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                objetsSymbols.put(name, typeName);
            } else {
                int _lower_1 = it.getLower();
                int _minus = _lower_1 - 1;
                Consumer<Integer> _function_2 = it_1 -> objetsSymbols.put(name + "_" + it_1, typeName);
                new IntegerRange(0, _minus).forEach(_function_2);
            }
        };
        objects.forEach(_function_1);
        _xblockexpression = objetsSymbols;
        return _xblockexpression;
    }

    private Map<String, SignalEvent> generateSymbolEvents(Resource r) {
        HashMap<String, SignalEvent> _xblockexpression = null;
        HashMap<String, SignalEvent> symbolEvents = new HashMap<String, SignalEvent>();
        Procedures.Procedure1 _function = it -> symbolEvents.put(it.getSignal().getName(), (SignalEvent)it);
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)r.getAllContents(), SignalEvent.class), (Procedures.Procedure1)_function);
        _xblockexpression = symbolEvents;
        return _xblockexpression;
    }

    public List<String> getFlatActiveObjectsName() {
        return this.flatActiveObjectsName;
    }

    public Map<String, SymbolClass> getSymbolClasses() {
        return this.symbolClasses;
    }

    public Map<String, String> getFlatMapping() {
        return this.flatMappingObjectsClasses;
    }

    public Map<String, SignalEvent> getSymbolEvents() {
        return this.symbolEvents;
    }
}

