/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.symbols;

import emi.serializer.model.ModelLoader;
import emi.serializer.symbols.SymbolClass;
import emi.serializer.symbols.SymbolTable;
import emi.serializer.utils.UmlNavigation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class SymbolMatcher {
    private final ModelLoader modelLoader;
    private Resource emfModel;
    private final SymbolTable symbolTable;

    public SymbolMatcher(String emiModel, String modelName) {
        SymbolTable _symbolTable;
        ModelLoader _modelLoader;
        String umlFile = emiModel + "/uml/" + modelName + ".uml";
        this.modelLoader = _modelLoader = new ModelLoader();
        this.emfModel = this.modelLoader.load(umlFile);
        this.symbolTable = _symbolTable = new SymbolTable(this.emfModel);
    }

    public String searchActiveObject(int aoId) {
        return this.symbolTable.getFlatActiveObjectsName().get(aoId);
    }

    public Vertex searchState(String ao, int stateId) {
        Vertex _xblockexpression = null;
        String class_ = this.symbolTable.getFlatMapping().get(ao);
        SymbolClass symbolClass = this.symbolTable.getSymbolClasses().get(class_);
        _xblockexpression = symbolClass.getVertices().get(stateId);
        return _xblockexpression;
    }

    public Transition searchTransition(String ao, int stateId, int transitionId) {
        Transition _xblockexpression = null;
        String class_ = this.symbolTable.getFlatMapping().get(ao);
        SymbolClass symbolClass = this.symbolTable.getSymbolClasses().get(class_);
        _xblockexpression = (Transition)symbolClass.getVertices().get(stateId).getOutgoings().get(transitionId);
        return _xblockexpression;
    }

    public SignalEvent searchSignalEvent(int signalEventId) {
        return UmlNavigation.getSignalEvents(this.emfModel).get(signalEventId);
    }
}

