/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.model;

import emi.serializer.actionlanguage.ActionLanguages;
import emi.serializer.memoryobjects.ActiveObjects;
import emi.serializer.memoryobjects.EventPools;
import emi.serializer.memoryobjects.EventsParameters;
import emi.serializer.memoryobjects.PassiveObjects;
import emi.serializer.memoryobjects.Peers;
import emi.serializer.memoryobjects.SignalEvents;
import emi.serializer.memoryobjects.Store;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.serialization.uml.AUmlSerializer;
import emi.serializer.serialization.uml.UmlModelSerializer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ModelSerializer {
    public static final String INTERPRETER_DIR = "emi-uml-c/";
    private final UmlModelSerializer umlModel;
    private final AUmlSerializer umlSerializer;
    private final ActionLanguages actionLanguages;
    private final EventsParameters eventsParameters;
    private final Store store;
    private final Peers peers;
    private final SignalEvents signalEvents;
    private final ActiveObjects activeObjects;
    private final PassiveObjects passiveObjects;
    private final EventPools eventPools;

    public ModelSerializer(Resource r, MetamodelTable table, IStrategy strategy) {
        EventPools _eventPools;
        EventsParameters _eventsParameters;
        PassiveObjects _passiveObjects;
        ActiveObjects _activeObjects;
        SignalEvents _signalEvents;
        Peers _peers;
        Store _store;
        ActionLanguages _actionLanguages;
        AUmlSerializer _aUmlSerializer;
        UmlModelSerializer _umlModelSerializer;
        this.umlModel = _umlModelSerializer = new UmlModelSerializer(r);
        this.umlSerializer = _aUmlSerializer = new AUmlSerializer(r, table, strategy);
        this.actionLanguages = _actionLanguages = new ActionLanguages(r);
        this.store = _store = new Store(r);
        this.peers = _peers = new Peers(r);
        this.signalEvents = _signalEvents = new SignalEvents(r);
        this.activeObjects = _activeObjects = new ActiveObjects(r);
        this.passiveObjects = _passiveObjects = new PassiveObjects(r);
        this.eventsParameters = _eventsParameters = new EventsParameters(r);
        this.eventPools = _eventPools = new EventPools(r);
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef MODEL_H");
        _builder.newLine();
        _builder.append("#define MODEL_H");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file model.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define the UML model to interpret.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"types_calibration.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/active_object.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/passive_object.h\"");
        _builder.newLine();
        _builder.newLine();
        String _serializeHeaders = this.umlModel.serializeHeaders();
        _builder.append(_serializeHeaders);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_1 = this.eventsParameters.serializeHeaders();
        _builder.append(_serializeHeaders_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_2 = this.store.serializeHeaders();
        _builder.append(_serializeHeaders_2);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_3 = this.signalEvents.serializeHeaders();
        _builder.append(_serializeHeaders_3);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_4 = this.eventPools.serializeHeaders();
        _builder.append(_serializeHeaders_4);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_5 = this.activeObjects.serializeHeaders();
        _builder.append(_serializeHeaders_5);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_6 = this.passiveObjects.serializeHeaders();
        _builder.append(_serializeHeaders_6);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_7 = this.peers.serializeHeaders();
        _builder.append(_serializeHeaders_7);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#endif /* MODEL_H */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file model.c");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define the UML model to interpret.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <stdlib.h>");
        _builder.newLine();
        _builder.append("#include <stdio.h>");
        _builder.newLine();
        _builder.append("#include <string.h>");
        _builder.newLine();
        _builder.append("#include \"model.h\"");
        _builder.newLine();
        _builder.append("#include \"metamodel/uml.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/guard_evaluator/guard_evaluator.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/effect_interpreter/effect_interpreter.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/event_pool/event_pool.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/store.h\"");
        _builder.newLine();
        _builder.append("#include \"trace/trace.h\"");
        _builder.newLine();
        _builder.append("#include \"target/bsp/uml_api.h\"");
        _builder.newLine();
        _builder.append("#include \"target/bsp/utils.h\"");
        _builder.newLine();
        _builder.newLine();
        String _serializeDeclarations = this.umlSerializer.serializeDeclarations();
        _builder.append(_serializeDeclarations);
        _builder.newLineIfNotEmpty();
        String _serializeDeclarations_1 = this.actionLanguages.serializeDeclarations();
        _builder.append(_serializeDeclarations_1);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize = this.umlModel.serialize();
        _builder.append(_serialize);
        _builder.newLineIfNotEmpty();
        String _serialize_1 = this.umlSerializer.serialize();
        _builder.append(_serialize_1);
        _builder.newLineIfNotEmpty();
        String _serialize_2 = this.actionLanguages.serialize();
        _builder.append(_serialize_2);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_3 = this.eventsParameters.serialize();
        _builder.append(_serialize_3);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_4 = this.store.serialize();
        _builder.append(_serialize_4);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_5 = this.signalEvents.serialize();
        _builder.append(_serialize_5);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_6 = this.eventPools.serialize();
        _builder.append(_serialize_6);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_7 = this.activeObjects.serialize();
        _builder.append(_serialize_7);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_8 = this.passiveObjects.serialize();
        _builder.append(_serialize_8);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_9 = this.peers.serialize();
        _builder.append(_serialize_9);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

