/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.metamodel;

import com.google.common.collect.Iterables;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class OffsetsTableStrategy
implements IStrategy {
    private MetamodelTable table;
    private Set<Map.Entry<EClassifier, Metaclass>> sortedClasses;
    private Set<Map.Entry<EClassifier, Metaclass>> classesMI;
    private List<String> attributesNamesMI;

    public OffsetsTableStrategy(MetamodelTable table) {
        this.table = table;
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Functions.Function1 _function_1 = it -> ((Metaclass)it.getValue()).isHasMultipleInheritances();
        this.classesMI = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(this.table.getMetaclasses().entrySet(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        this.sortedClasses = this.sortClasses();
        this.attributesNamesMI = this.computeDescriptorIndex();
    }

    private Set<Map.Entry<EClassifier, Metaclass>> sortClasses() {
        LinkedHashSet<Map.Entry<EClassifier, Metaclass>> _xblockexpression = null;
        LinkedHashSet<Map.Entry<EClassifier, Metaclass>> collection = new LinkedHashSet<Map.Entry<EClassifier, Metaclass>>();
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Functions.Function1 _function_1 = it -> {
            boolean _isHasMultipleInheritances = ((Metaclass)it.getValue()).isHasMultipleInheritances();
            return !_isHasMultipleInheritances;
        };
        Set classesSI = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(this.table.getMetaclasses().entrySet(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        collection.addAll(this.classesMI);
        collection.addAll(classesSI);
        _xblockexpression = collection;
        return _xblockexpression;
    }

    private List<String> computeDescriptorIndex() {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> attributesList = new ArrayList<String>();
        Consumer<Map.Entry> _function = it -> attributesList.addAll(this.table.getAllAttributesNames((Metaclass)it.getValue()));
        this.classesMI.forEach(_function);
        _xblockexpression = attributesList;
        return _xblockexpression;
    }

    @Override
    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Definition of types needed to handle multiple inheritance.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef enum DescriptorType DescriptorType;");
        _builder.newLine();
        _builder.append("typedef enum DescriptorIndex DescriptorIndex;");
        _builder.newLine();
        _builder.newLine();
        String _enumClassesToC = this.enumClassesToC();
        _builder.append(_enumClassesToC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _enumAttributesToC = this.enumAttributesToC();
        _builder.append(_enumAttributesToC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _descriptorsTableHeaderToC = this.descriptorsTableHeaderToC();
        _builder.append(_descriptorsTableHeaderToC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _macroAccessToC = this.macroAccessToC();
        _builder.append((Object)_macroAccessToC);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    @Override
    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        String _descriptorsTableToC = this.descriptorsTableToC();
        _builder.append(_descriptorsTableToC);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String descriptorsTableHeaderToC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The number of classes that have multiple inheritance.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define NB_MI_CLASSES\t(");
        int _length = ((Object[])Conversions.unwrapArray(this.classesMI, Object.class)).length;
        _builder.append((Object)_length);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The global offsets table for all classes that have multiple inheritance.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("extern uint8_t * offsets_table[NB_MI_CLASSES];");
        _builder.newLine();
        return _builder.toString();
    }

    private String descriptorsTableToC() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            EClassifier _key = (EClassifier)it.getKey();
            String _descriptorsTableToC = this.descriptorsTableToC((EClass)_key, (Metaclass)it.getValue());
            _builder_1.append(_descriptorsTableToC);
            _builder_1.newLineIfNotEmpty();
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.classesMI, (Functions.Function1)_function), (CharSequence)"");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The global offsets table for all classes that have multiple inheritance.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("uint8_t * offsets_table[NB_MI_CLASSES] = {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("offsets_");
            String _typeName = UmlSerializerExtensions.typeName((EObject)it.getKey());
            _builder_1.append(_typeName);
            return _builder_1.toString();
        };
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(this.classesMI, (Functions.Function1)_function_1), (CharSequence)",\n");
        _builder.append(_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }

    private String descriptorsTableToC(EClass eClass, Metaclass metaclass) {
        String _xblockexpression = null;
        List<String> allAttributes = this.table.getAllAttributesNames(metaclass);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Macro to used if there is a hole.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* A white space is present in the descriptor table if the considered class has not this attribute.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define NO_DESC_TYPE   (0)");
        _builder.newLine();
        StringConcatenation _xifexpression = null;
        boolean _isHasMultipleInheritances = metaclass.isHasMultipleInheritances();
        if (_isHasMultipleInheritances) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("/**");
            _builder_1.newLine();
            _builder_1.append(" ");
            _builder_1.append("* The table of descriptor offsets for the class ");
            String _name = eClass.getName();
            _builder_1.append(_name, " ");
            _builder_1.append(".");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(" ");
            _builder_1.append("*/");
            _builder_1.newLine();
            _builder_1.append("uint8_t offsets_");
            String _typeName = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder_1.append(_typeName);
            _builder_1.append("[NB_DESC_INDEX] = {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            Functions.Function1 _function = it -> {
                String _xifexpression_1 = null;
                boolean _contains = allAttributes.contains(it);
                if (_contains) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("offsetof(");
                    String _typeName_1 = UmlSerializerExtensions.typeName((EObject)eClass);
                    _builder_2.append(_typeName_1);
                    _builder_2.append(", ");
                    _builder_2.append(it);
                    _builder_2.append(")");
                    _xifexpression_1 = _builder_2.toString();
                } else {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("NO_DESC_TYPE");
                    _xifexpression_1 = _builder_3.toString();
                }
                return _xifexpression_1;
            };
            String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.attributesNamesMI, (Functions.Function1)_function), (CharSequence)",\n");
            _builder_1.append(_join, "\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("};");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    @Override
    public String addFieldsTypes(Metaclass metaclass) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("DescriptorType c_type;");
        return _builder.toString();
    }

    @Override
    public String addFieldsInitializers(EObject e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".c_type = DESC_TYPE_");
        String _typeName = UmlSerializerExtensions.typeName(e);
        _builder.append(_typeName);
        _builder.append(",");
        return _builder.toString();
    }

    @Override
    public String addFieldsInitializers(EClass e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".c_type = DESC_TYPE_");
        String _typeName = UmlSerializerExtensions.typeName((EObject)e);
        _builder.append(_typeName);
        _builder.append(",");
        return _builder.toString();
    }

    private String enumClassesToC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Definition of the enum DescriptorType.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* A descriptor type is generated for each class.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("enum DescriptorType {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("DESC_TYPE_");
            String _typeName = UmlSerializerExtensions.typeName((EObject)it.getKey());
            _builder_1.append(_typeName);
            _builder_1.append(",");
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.sortedClasses, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("NB_DESC_TYPE");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }

    private String enumAttributesToC() {
        String _xblockexpression = null;
        LinkedHashSet unusedAttributes = new LinkedHashSet();
        Functions.Function1 _function = it -> this.table.getAllAttributesNames((Metaclass)it.getValue());
        Iterables.addAll(unusedAttributes, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(this.sortedClasses, (Functions.Function1)_function)));
        unusedAttributes.removeAll(this.attributesNamesMI);
        LinkedList<String> collection = new LinkedList<String>();
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("DESC_INDEX_");
            _builder.append(it);
            return _builder.toString();
        };
        collection.addAll(ListExtensions.map(this.attributesNamesMI, (Functions.Function1)_function_1));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("NB_DESC_INDEX");
        collection.add(_builder.toString());
        Functions.Function1 _function_2 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("DESC_INDEX_");
            _builder_1.append(it);
            return _builder_1.toString();
        };
        Iterables.addAll(collection, (Iterable)IterableExtensions.map(unusedAttributes, (Functions.Function1)_function_2));
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("/**");
        _builder_1.newLine();
        _builder_1.append(" ");
        _builder_1.append("* Definition of the enum DescriptorIndex.");
        _builder_1.newLine();
        _builder_1.append(" ");
        _builder_1.append("* A descriptor index is generated for all attributes of classes that have multiple inheritance.");
        _builder_1.newLine();
        _builder_1.append(" ");
        _builder_1.append("* All DESC_INDEX after NB_DESC_INDEX are unused for multiple inheritance access but useful for compilation");
        _builder_1.newLine();
        _builder_1.append(" ");
        _builder_1.append("* because the access is compute at runtime.");
        _builder_1.newLine();
        _builder_1.append(" ");
        _builder_1.append("*/");
        _builder_1.newLine();
        _builder_1.append("enum DescriptorIndex {");
        _builder_1.newLine();
        _builder_1.append("\t");
        Functions.Function1 _function_3 = it -> {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(it);
            return _builder_2.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(collection, (Functions.Function1)_function_3), (CharSequence)",\n");
        _builder_1.append(_join, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("};");
        _builder_1.newLine();
        _xblockexpression = _builder_1.toString();
        return _xblockexpression;
    }

    private CharSequence macroAccessToC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The C macro used to access elements of the UML model per address (var must be a pointer).");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This macro provides:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* - a direct access in case of single inheritance");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* - an access through the descriptor table (vtable) in case of multiple inheritance.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define GETP(var, field) (((var)->c_type < NB_MI_CLASSES) ? \\");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("(*(__typeof__(&((var)->field))) ((void*)((var)) + offsets_table[(var)->c_type][DESC_INDEX_##field])) : ((var)->field))");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The C macro used to access elements of the UML model per value (var must be a value).");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This macro provides:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* - a direct access in case of single inheritance");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* - an access through the descriptor table (vtable) in case of multiple inheritance.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define GETV(var, field) (((var).c_type < NB_MI_CLASSES) ? \\");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("(*(__typeof__(&((var).field))) ((void*)(&(var)) + offsets_table[(var).c_type][DESC_INDEX_##field])) : ((var).field))");
        _builder.newLine();
        return _builder;
    }
}

