/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.actionlanguage.C;

import com.google.common.base.Objects;
import emi.serializer.actionlanguage.C.MatchingUnitC;
import emi.serializer.actionlanguage.C.RegexKindC;
import emi.serializer.actionlanguage.C.RegexUnitC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MatcherC {
    private final List<RegexUnitC> regexList = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RegexUnitC[]{new RegexUnitC(RegexKindC.REGEX_SEND, "send(?:\\s)?\\((?:\\s)?([\\p{Alpha}_]+)(?:\\s)?(?:(?:\\s)?\\((?:\\s)?([\\p{Alnum},\\s]+)(?:\\s)?\\)(?:\\s)?)?,(?:\\s)?((([\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?([\\d]+)(?:\\s)?\\])?)(?:\\s)?\\.(?:\\s)?)*([\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?([\\d]+)(?:\\s)?\\])?))(?:\\s)?\\)(?:\\s)?;", new int[]{1, 2, 3}), new RegexUnitC(RegexKindC.REGEX_SEND_PEERS, "sendPeers(?:\\s)?\\((?:\\s)?([\\p{Alpha}_]+)(?:\\s)?(?:(?:\\s)?\\((?:\\s)?([\\p{Alnum},\\s]+)(?:\\s)?\\)(?:\\s)?)?\\)(?:\\s)?;", new int[]{1, 2}), new RegexUnitC(RegexKindC.REGEX_EP_CONTAINS, "contains(?:\\s)?\\((?:\\s)?((?:(?:[\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?(?:[\\d]+)(?:\\s)?\\])?)(?:\\s)?\\.(?:\\s)?)*event_pool)(?:\\s)?,(?:\\s)?([\\p{Alpha}_]+)(?:\\((?:\\s)?([\\p{Alnum},\\s]+)(?:\\s)?\\))?(?:\\s)?\\)", new int[]{1, 2, 3}), new RegexUnitC(RegexKindC.REGEX_EP_GET_FIRST, "getFirst(?:\\s)?\\((?:\\s)?((?:(?:[\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?(?:[\\d]+)(?:\\s)?\\])?)(?:\\s)?\\.(?:\\s)?)*event_pool)(?:\\s)?\\)", new int[]{1}), new RegexUnitC(RegexKindC.REGEX_EP_GET_LAST, "getLast(?:\\s)?\\((?:\\s)?((?:(?:[\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?(?:[\\d]+)(?:\\s)?\\])?)(?:\\s)?\\.(?:\\s)?)*event_pool)(?:\\s)?\\)", new int[]{1}), new RegexUnitC(RegexKindC.REGEX_EP_GET_AT, "getAt(?:\\s)?\\((?:\\s)?((?:(?:[\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?(?:[\\d]+)(?:\\s)?\\])?)(?:\\s)?\\.(?:\\s)?)*event_pool)(?:\\s)?,(?:\\s)?((\\d+))(?:\\s)?\\)", new int[]{1, 2}), new RegexUnitC(RegexKindC.REGEX_EP_IS_FULL, "isFull(?:\\s)?\\((?:\\s)?((?:(?:[\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?(?:[\\d]+)(?:\\s)?\\])?)(?:\\s)?\\.(?:\\s)?)*event_pool)(?:\\s)?\\)", new int[]{1}), new RegexUnitC(RegexKindC.REGEX_EP_IS_EMPTY, "isEmpty(?:\\s)?\\((?:\\s)?((?:(?:[\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?(?:[\\d]+)(?:\\s)?\\])?)(?:\\s)?\\.(?:\\s)?)*event_pool)(?:\\s)?\\)", new int[]{1}), new RegexUnitC(RegexKindC.REGEX_STATE_NAME, "STATE_[A-Z_]*", new int[0]), new RegexUnitC(RegexKindC.REGEX_ATTRIBUTE_ACCESS, "((?:(?:[\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?(?:[\\d]+)(?:\\s)?\\])?)(?:\\s)?\\.(?:\\s)?)*[\\p{Alpha}_]+(?:\\s)?(?:\\[(?:\\s)?(?:[\\d]+)(?:\\s)?\\])?)", null)}));
    public static final String regexPart = "([\\p{Alpha}_]+)(?:\\s)?(?:\\[(?:\\s)?((\\d+))(?:\\s)?\\])?";

    public String removeWhiteSpaces(String s) {
        return s.replaceAll("\\p{Space}", "");
    }

    public List<MatchingUnitC> matchAll(String s) {
        List<MatchingUnitC> _xblockexpression = null;
        ArrayList<MatchingUnitC> tmp = null;
        boolean match = false;
        MatchingUnitC _matchingUnitC = new MatchingUnitC(RegexKindC.REGEX_NO_MATCH, s);
        List<MatchingUnitC> units = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new MatchingUnitC[]{_matchingUnitC}));
        for (RegexUnitC regexUnit : this.regexList) {
            ArrayList<MatchingUnitC> _arrayList;
            tmp = _arrayList = new ArrayList<MatchingUnitC>();
            for (MatchingUnitC unit : units) {
                match = false;
                RegexKindC _kind = unit.getKind();
                boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)RegexKindC.REGEX_NO_MATCH));
                if (_equals) {
                    List<MatchingUnitC> result = this.genericMatch(unit.getString(), regexUnit);
                    tmp.addAll(result);
                    continue;
                }
                tmp.add(unit);
            }
            units = tmp;
        }
        _xblockexpression = units;
        return _xblockexpression;
    }

    public List<MatchingUnitC> match(String s, RegexKindC kind) {
        ArrayList _arrayList;
        List<MatchingUnitC> _xblockexpression = null;
        ArrayList tmp = null;
        boolean match = false;
        MatchingUnitC _matchingUnitC = new MatchingUnitC(RegexKindC.REGEX_NO_MATCH, s);
        List<MatchingUnitC> units = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new MatchingUnitC[]{_matchingUnitC}));
        Functions.Function1 _function = it -> {
            RegexKindC _kind = it.getKind();
            return Objects.equal((Object)((Object)_kind), (Object)((Object)kind));
        };
        RegexUnitC regexUnit = ((RegexUnitC[])Conversions.unwrapArray((Object)IterableExtensions.filter(this.regexList, (Functions.Function1)_function), RegexUnitC.class))[0];
        tmp = _arrayList = new ArrayList();
        for (MatchingUnitC unit : units) {
            match = false;
            RegexKindC _kind = unit.getKind();
            boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)RegexKindC.REGEX_NO_MATCH));
            if (_equals) {
                List<MatchingUnitC> result = this.genericMatch(unit.getString(), regexUnit);
                tmp.addAll(result);
                continue;
            }
            tmp.add(unit);
        }
        _xblockexpression = units = tmp;
        return _xblockexpression;
    }

    private List<MatchingUnitC> genericMatch(String s, RegexUnitC regexUnit) {
        boolean _lessThan;
        ArrayList<MatchingUnitC> _xblockexpression = null;
        ArrayList<MatchingUnitC> target = new ArrayList<MatchingUnitC>();
        int indexString = 0;
        Matcher m = Pattern.compile(regexUnit.getRegex(), 4).matcher(s);
        while (m.find()) {
            if (m.start() != 0 && m.start() != indexString) {
                String substring = s.substring(indexString, m.start());
                MatchingUnitC unit = new MatchingUnitC(RegexKindC.REGEX_NO_MATCH, substring);
                target.add(unit);
            }
            MatchingUnitC unit_1 = null;
            if (regexUnit.getGroups() != null && regexUnit.getGroups().length != 0) {
                MatchingUnitC _matchingUnitC;
                ArrayList<String> groupsToStore = new ArrayList<String>();
                Procedures.Procedure2 _function = (x, i) -> groupsToStore.add((int)i, m.group((int)x));
                IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)regexUnit.getGroups())), (Procedures.Procedure2)_function);
                RegexKindC _kind = regexUnit.getKind();
                String _group = m.group(0);
                unit_1 = _matchingUnitC = new MatchingUnitC(_kind, _group, groupsToStore);
            } else {
                MatchingUnitC _matchingUnitC_1;
                RegexKindC _kind_1 = regexUnit.getKind();
                String _group_1 = m.group(0);
                unit_1 = _matchingUnitC_1 = new MatchingUnitC(_kind_1, _group_1);
            }
            target.add(unit_1);
            indexString = m.end();
        }
        int _length = s.length();
        boolean bl = _lessThan = indexString < _length;
        if (_lessThan) {
            String substring = s.substring(indexString, s.length());
            MatchingUnitC unit = new MatchingUnitC(RegexKindC.REGEX_NO_MATCH, substring);
            target.add(unit);
        }
        _xblockexpression = target;
        return _xblockexpression;
    }

    public List<String> oneMatch(String s, String regex) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> target = new ArrayList<String>();
        Matcher m = Pattern.compile(regex, 4).matcher(s);
        boolean _find = m.find();
        if (_find) {
            int _groupCount = m.groupCount();
            int _minus = _groupCount - 1;
            Consumer<Integer> _function = it -> target.add(m.group((int)it));
            new IntegerRange(0, _minus).forEach(_function);
        }
        _xblockexpression = target;
        return _xblockexpression;
    }
}

